/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.TableOfContentsServlet;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.crfdata.DynamicsMetadataService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class MarkEventCRFCompleteServlet
extends SecureController {
    Locale locale;
    public static final String INPUT_EVENT_CRF_ID = "eventCRFId";
    public static final String INPUT_MARK_COMPLETE = "markComplete";
    public static final String VALUE_YES = "Yes";
    public static final String VALUE_NO = "No";
    public static final String BEAN_DISPLAY = "toc";
    private FormProcessor fp;
    private EventCRFDAO ecdao;
    private EventCRFBean ecb;
    private EventDefinitionCRFDAO edcdao;
    private EventDefinitionCRFBean edcb;

    private void getEventCRFBean() {
        this.fp = new FormProcessor(this.request);
        int eventCRFId = this.fp.getInt(INPUT_EVENT_CRF_ID);
        this.ecdao = new EventCRFDAO(this.sm.getDataSource());
        this.ecb = (EventCRFBean)this.ecdao.findByPK(eventCRFId);
    }

    private boolean isEachRequiredFieldFillout() {
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        ArrayList dataList = iddao.findAllBlankRequiredByEventCRFId(this.ecb.getId(), this.ecb.getCRFVersionId());
        return dataList.isEmpty();
    }

    private boolean isEachSectionReviewedOnce() {
        SectionDAO sdao = new SectionDAO(this.sm.getDataSource());
        DataEntryStage stage = this.ecb.getStage();
        ArrayList sections = sdao.findAllByCRFVersionId(this.ecb.getCRFVersionId());
        HashMap numItemsHM = sdao.getNumItemsBySectionId();
        HashMap numItemsPendingHM = sdao.getNumItemsPendingBySectionId(this.ecb);
        HashMap numItemsCompletedHM = sdao.getNumItemsCompletedBySectionId(this.ecb);
        for (int i = 0; i < sections.size(); ++i) {
            SectionBean sb = (SectionBean)sections.get(i);
            Integer key = new Integer(sb.getId());
            int numItems = TableOfContentsServlet.getIntById((HashMap)numItemsHM, (Integer)key);
            int numItemsPending = TableOfContentsServlet.getIntById((HashMap)numItemsPendingHM, (Integer)key);
            int numItemsCompleted = TableOfContentsServlet.getIntById((HashMap)numItemsCompletedHM, (Integer)key);
            if (!(stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && this.edcb.isDoubleEntry() ? numItemsPending == 0 && numItems > 0 : numItemsCompleted == 0 && numItems > 0)) continue;
            return false;
        }
        return true;
    }

    private void getEventDefinitionCRFBean() {
        this.edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        this.edcb = this.edcdao.findForStudyByStudyEventIdAndCRFVersionId(this.ecb.getStudyEventId(), this.ecb.getCRFVersionId());
    }

    protected void processRequest() throws Exception {
        this.getEventCRFBean();
        this.getEventDefinitionCRFBean();
        DataEntryStage stage = this.ecb.getStage();
        this.request.setAttribute("eventCRF", (Object)this.ecb);
        Page errorPage = Page.LIST_STUDY_SUBJECTS_SERVLET;
        if (stage.equals((Term)DataEntryStage.UNCOMPLETED) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.LOCKED)) {
            throw new InconsistentStateException(errorPage, respage.getString("not_mark_CRF_complete1"));
        }
        if ((stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) && !this.edcb.isDoubleEntry()) {
            throw new InconsistentStateException(errorPage, respage.getString("not_mark_CRF_complete2"));
        }
        if (!this.isEachRequiredFieldFillout()) {
            throw new InconsistentStateException(errorPage, respage.getString("not_mark_CRF_complete4"));
        }
        if (this.ecb.getInterviewerName().trim().equals("")) {
            throw new InconsistentStateException(errorPage, respage.getString("not_mark_CRF_complete5"));
        }
        if (!this.fp.isSubmitted()) {
            DisplayTableOfContentsBean toc = TableOfContentsServlet.getDisplayBean((EventCRFBean)this.ecb, (DataSource)this.sm.getDataSource(), (StudyBean)this.currentStudy);
            toc = TableOfContentsServlet.getDisplayBeanWithShownSections((DataSource)this.sm.getDataSource(), (DisplayTableOfContentsBean)toc, (DynamicsMetadataService)((DynamicsMetadataService)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("dynamicsMetadataService")));
            this.request.setAttribute(BEAN_DISPLAY, (Object)toc);
            this.resetPanel();
            this.panel.setStudyInfoShown(false);
            this.panel.setOrderedData(true);
            this.setToPanel(resword.getString("subject"), toc.getStudySubject().getLabel());
            this.setToPanel(resword.getString("study_event_definition"), toc.getStudyEventDefinition().getName());
            StudyEventBean seb = toc.getStudyEvent();
            this.setToPanel(resword.getString("location"), seb.getLocation());
            this.setToPanel(resword.getString("start_date"), seb.getDateStarted().toString());
            this.setToPanel(resword.getString("end_date"), seb.getDateEnded().toString());
            this.setToPanel(resword.getString("CRF"), toc.getCrf().getName());
            this.setToPanel(resword.getString("CRF_version"), toc.getCrfVersion().getName());
            this.forwardPage(Page.MARK_EVENT_CRF_COMPLETE);
        } else {
            boolean markComplete = this.fp.getString(INPUT_MARK_COMPLETE).equals(VALUE_YES);
            if (markComplete) {
                Status newStatus = this.ecb.getStatus();
                boolean ide = true;
                if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && this.edcb.isDoubleEntry()) {
                    newStatus = Status.PENDING;
                    this.ecb.setUpdaterId(this.ub.getId());
                    this.ecb.setUpdatedDate(new Date());
                    this.ecb.setDateCompleted(new Date());
                } else if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && !this.edcb.isDoubleEntry()) {
                    newStatus = Status.UNAVAILABLE;
                    this.ecb.setUpdaterId(this.ub.getId());
                    this.ecb.setUpdatedDate(new Date());
                    this.ecb.setDateCompleted(new Date());
                    this.ecb.setDateValidateCompleted(new Date());
                } else if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                    newStatus = Status.UNAVAILABLE;
                    this.ecb.setDateValidateCompleted(new Date());
                    ide = false;
                }
                this.ecb.setStatus(newStatus);
                this.ecb = (EventCRFBean)this.ecdao.update((EntityBean)this.ecb);
                this.ecdao.markComplete(this.ecb, ide);
                ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                iddao.updateStatusByEventCRF(this.ecb, newStatus);
                StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
                StudyEventBean seb = (StudyEventBean)sedao.findByPK(this.ecb.getStudyEventId());
                seb.setUpdatedDate(new Date());
                seb.setUpdater(this.ub);
                EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
                ArrayList allCRFs = this.ecdao.findAllByStudyEvent(seb);
                ArrayList allEDCs = edcdao.findAllActiveByEventDefinitionId(seb.getStudyEventDefinitionId());
                boolean eventCompleted = true;
                for (int i = 0; i < allCRFs.size(); ++i) {
                    EventCRFBean ec = (EventCRFBean)allCRFs.get(i);
                    if (ec.getStatus().equals((Term)Status.UNAVAILABLE)) continue;
                    eventCompleted = false;
                    break;
                }
                if (eventCompleted && allCRFs.size() >= allEDCs.size()) {
                    seb.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                }
                seb = (StudyEventBean)sedao.update((EntityBean)seb);
                this.addPageMessage(respage.getString("event_CRF_marked_complete"));
                this.request.setAttribute("eventId", (Object)String.valueOf(this.ecb.getStudyEventId()));
                this.forwardPage(Page.ENTER_DATA_FOR_STUDY_EVENT_SERVLET);
            } else {
                this.request.setAttribute("ignore", (Object)Boolean.TRUE);
                this.addPageMessage(respage.getString("event_CRF_not_marked_complete"));
                this.forwardPage(errorPage);
            }
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        this.fp = new FormProcessor(this.request);
        if (this.currentRole.equals((Object)Role.COORDINATOR) || this.currentRole.equals((Object)Role.STUDYDIRECTOR)) {
            return;
        }
        this.getEventCRFBean();
        Role r = this.currentRole.getRole();
        if (this.ecb.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY)) {
            if (this.ecb.getOwnerId() != this.ub.getId() && !r.equals((Term)Role.COORDINATOR) && !r.equals((Term)Role.STUDYDIRECTOR)) {
                this.request.setAttribute("eventCRF", (Object)this.ecb);
                this.addPageMessage(respage.getString("not_mark_CRF_complete6"));
                throw new InsufficientPermissionException(Page.TABLE_OF_CONTENTS_SERVLET, resexception.getString("not_study_owner"), "1");
            }
        } else if (this.ecb.getStage().equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY) && this.ecb.getValidatorId() != this.ub.getId() && !r.equals((Term)Role.COORDINATOR) && !r.equals((Term)Role.STUDYDIRECTOR)) {
            this.request.setAttribute("eventCRF", (Object)this.ecb);
            this.addPageMessage(respage.getString("not_mark_CRF_complete7"));
            throw new InsufficientPermissionException(Page.TABLE_OF_CONTENTS_SERVLET, resexception.getString("not_study_owner"), "1");
        }
    }
}

