/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.hibernate.RuleSetDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleAuditDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleAuditBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveRuleSetServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    RuleSetDao ruleSetDao;
    RuleSetServiceInterface ruleSetService;
    RuleSetRuleAuditDao ruleSetRuleAuditDao;
    RuleSetRuleDao ruleSetRuleDao;
    private static String RULESET_ID = "ruleSetId";
    private static String RULESET = "ruleSet";
    private static String ACTION = "action";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        String action = this.request.getParameter(ACTION);
        if (ruleSetId == null) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            RuleSetBean ruleSetBean = null;
            ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
            if (action != null && action.equals("confirm")) {
                this.request.setAttribute(RULESET, (Object)ruleSetBean);
                this.forwardPage(Page.REMOVE_RULE_SET);
            } else {
                for (RuleSetRuleBean ruleSetRuleBean : ruleSetBean.getRuleSetRules()) {
                    if (ruleSetRuleBean.getStatus() == Status.DELETED) continue;
                    ruleSetRuleBean.setStatus(Status.DELETED);
                    ruleSetRuleBean.setUpdater(this.ub);
                    ruleSetRuleBean = (RuleSetRuleBean)this.getRuleSetRuleDao().saveOrUpdate((DomainObject)ruleSetRuleBean);
                    this.createRuleSetRuleAuditBean(ruleSetRuleBean, this.ub, Status.DELETED);
                }
                this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
            }
        }
    }

    private void createRuleSetRuleAuditBean(RuleSetRuleBean ruleSetRuleBean, UserAccountBean ub, Status status) {
        RuleSetRuleAuditBean ruleSetRuleAuditBean = new RuleSetRuleAuditBean();
        ruleSetRuleAuditBean.setRuleSetRuleBean(ruleSetRuleBean);
        ruleSetRuleAuditBean.setUpdater(ub);
        ruleSetRuleAuditBean.setStatus(status);
        this.getRuleSetRuleAuditDao().saveOrUpdate((DomainObject)ruleSetRuleAuditBean);
    }

    public RuleSetDao getRuleSetDao() {
        return this.ruleSetDao;
    }

    public void setRuleSetDao(RuleSetDao ruleSetDao) {
        this.ruleSetDao = ruleSetDao;
    }

    private RuleSetRuleAuditDao getRuleSetRuleAuditDao() {
        this.ruleSetRuleAuditDao = this.ruleSetRuleAuditDao != null ? this.ruleSetRuleAuditDao : (RuleSetRuleAuditDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleAuditDao");
        return this.ruleSetRuleAuditDao;
    }

    private RuleSetRuleDao getRuleSetRuleDao() {
        this.ruleSetRuleDao = this.ruleSetRuleDao != null ? this.ruleSetRuleDao : (RuleSetRuleDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleDao");
        return this.ruleSetRuleDao;
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }
}

