/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewStudySubjectServlet;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.service.crfdata.DynamicsMetadataService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableOfContentsServlet
extends SecureController {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String BEAN_DISPLAY = "toc";
    public static final String INPUT_ACTION = "action";
    public static final String INPUT_ID = "ecid";
    public static final String INPUT_EVENT_CRF_BEAN = "eventCRF";
    public static final String INPUT_EVENT_DEFINITION_CRF_ID = "eventDefinitionCRFId";
    public static final String INPUT_CRF_VERSION_ID = "crfVersionId";
    public static final String INPUT_STUDY_EVENT_ID = "studyEventId";
    public static final String INPUT_SUBJECT_ID = "subjectId";
    public static final String INPUT_EVENT_CRF_ID = "eventCRFId";
    public static final String INPUT_INTERVIEWER = "interviewer";
    public static final String INPUT_INTERVIEW_DATE = "interviewDate";
    public static final String ACTION_START_INITIAL_DATA_ENTRY = "ide_s";
    public static final String ACTION_CONTINUE_INITIAL_DATA_ENTRY = "ide_c";
    public static final String ACTION_START_DOUBLE_DATA_ENTRY = "dde_s";
    public static final String ACTION_CONTINUE_DOUBLE_DATA_ENTRY = "dde_c";
    public static final String ACTION_ADMINISTRATIVE_EDITING = "ae";
    public static final String[] ACTIONS = new String[]{"ide_s", "ide_c", "dde_s", "dde_c", "ae"};
    private FormProcessor fp;
    private EventCRFDAO ecdao;
    private EventCRFBean ecb;
    private String action;

    private void getEventCRFAndAction() {
        this.ecdao = new EventCRFDAO(this.sm.getDataSource());
        this.ecb = (EventCRFBean)this.request.getAttribute("eventCRF");
        if (this.ecb == null) {
            int ecid = this.fp.getInt("ecid", true);
            AuditableEntityBean aeb = this.ecdao.findByPKAndStudy(ecid, this.currentStudy);
            this.ecb = !aeb.isActive() ? new EventCRFBean() : (EventCRFBean)aeb;
            this.action = this.fp.getString("action", true);
        } else {
            this.action = TableOfContentsServlet.getActionForStage((DataEntryStage)this.ecb.getStage());
        }
    }

    private boolean invalidAction(String action) {
        ArrayList<String> validActions = new ArrayList<String>(Arrays.asList(ACTIONS));
        return !validActions.contains(action);
    }

    private boolean isConsistentAction(String action, EventCRFBean ecb) {
        DataEntryStage stage = ecb.getStage();
        boolean isConsistent = true;
        if (action.equals("ide_s") && !stage.equals((Term)DataEntryStage.UNCOMPLETED)) {
            isConsistent = false;
        } else if (action.equals("ide_c") && !stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY)) {
            isConsistent = false;
        } else if (action.equals("dde_s") && !stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE)) {
            isConsistent = false;
        } else if (action.equals("dde_c") && !stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
            isConsistent = false;
        } else if (action.equals("ae") && !stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE)) {
            isConsistent = false;
        }
        return isConsistent;
    }

    private EventCRFBean createEventCRF() throws Exception {
        AuditableEntityBean aeb;
        this.ecdao = new EventCRFDAO(this.sm.getDataSource());
        int crfVersionId = this.fp.getInt("crfVersionId");
        int studyEventId = this.fp.getInt("studyEventId");
        int eventDefinitionCRFId = this.fp.getInt("eventDefinitionCRFId");
        int subjectId = this.fp.getInt("subjectId");
        int eventCRFId = this.fp.getInt("eventCRFId");
        this.logger.info("Creating event CRF within Table of Contents.  Study id: " + this.currentStudy.getId() + "; CRF Version id: " + crfVersionId + "; Study Event id: " + studyEventId + "; Event Definition CRF id: " + eventDefinitionCRFId + "; Subject: " + subjectId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean ssb = ssdao.findBySubjectIdAndStudy(subjectId, this.currentStudy);
        if (!ssb.isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("trying_to_begin_DE1"));
        }
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sedb = seddao.findByEventDefinitionCRFId(eventDefinitionCRFId);
        if (!ssb.isActive() || !sedb.isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("trying_to_begin_DE2"));
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        EntityBean eb = cvdao.findByPK(crfVersionId);
        if (!eb.isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("trying_to_begin_DE3"));
        }
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventBean sEvent = (StudyEventBean)sedao.findByPK(studyEventId);
        StudyBean studyWithSED = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithSED = new StudyBean();
            studyWithSED.setId(this.currentStudy.getParentStudyId());
        }
        if (!(aeb = sedao.findByPKAndStudy(studyEventId, studyWithSED)).isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("trying_to_begin_DE4"));
        }
        EventCRFBean ecb = new EventCRFBean();
        if (eventCRFId == 0) {
            ecb.setAnnotations("");
            ecb.setCreatedDate(new Date());
            ecb.setCRFVersionId(crfVersionId);
            ecb.setInterviewerName("");
            if (sEvent.getDateStarted() != null) {
                ecb.setDateInterviewed(sEvent.getDateStarted());
            } else {
                ecb.setDateInterviewed(null);
            }
            ecb.setOwnerId(this.ub.getId());
            ecb.setStatus(Status.AVAILABLE);
            ecb.setCompletionStatusId(1);
            ecb.setStudySubjectId(ssb.getId());
            ecb.setStudyEventId(studyEventId);
            ecb.setValidateString("");
            ecb.setValidatorAnnotations("");
            ecb = (EventCRFBean)this.ecdao.create((EntityBean)ecb);
            this.logger.info("CREATED EVENT CRF");
        } else {
            ecb = (EventCRFBean)this.ecdao.findByPK(eventCRFId);
            ecb.setCRFVersionId(crfVersionId);
            ecb.setUpdatedDate(new Date());
            ecb.setUpdater(this.ub);
            ecb = (EventCRFBean)this.ecdao.update((EntityBean)ecb);
        }
        if (!ecb.isActive()) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("new_event_CRF_not_created_database_error"));
        }
        sEvent.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
        sEvent.setUpdater(this.ub);
        sEvent.setUpdatedDate(new Date());
        sedao.update((EntityBean)sEvent);
        return ecb;
    }

    private void validateEventCRFAndAction() throws Exception {
        if (this.invalidAction(this.action)) {
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("no_action_specified_or_invalid"));
        }
        if (!this.isConsistentAction(this.action, this.ecb)) {
            HashMap<String, String> verbs = new HashMap<String, String>();
            verbs.put("ide_s", resword.getString("start_initial_data_entry"));
            verbs.put("ide_c", resword.getString("continue_initial_data_entry"));
            verbs.put("dde_s", resword.getString("start_double_data_entry"));
            verbs.put("dde_c", resword.getString("continue_double_data_entry"));
            verbs.put("ae", resword.getString("perform_administrative_editing"));
            String verb = (String)verbs.get(this.action);
            if (verb == null) {
                verb = "start initial data entry";
            }
            throw new InconsistentStateException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("you_are_trying_to") + verb + " " + resexception.getString("on_event_CRF_inappropiate_action"));
        }
        if (this.action.equals("dde_s")) {
            this.ecb.setValidatorId(this.ub.getId());
            this.ecb.setDateValidate(new Date());
            this.ecb = (EventCRFBean)this.ecdao.update((EntityBean)this.ecb);
        }
    }

    private void updatePresetValues(EventCRFBean ecb) {
        this.fp.addPresetValue("interviewer", ecb.getInterviewerName());
        if (ecb.getDateInterviewed() != null) {
            String idateFormatted = this.local_df.format(ecb.getDateInterviewed());
            this.fp.addPresetValue("interviewDate", idateFormatted);
        } else {
            this.fp.addPresetValue("interviewDate", "");
        }
        this.setPresetValues(this.fp.getPresetValues());
    }

    protected void processRequest() throws Exception {
        FormDiscrepancyNotes discNotes;
        if (this.action.equals("ide_s")) {
            this.ecb = this.createEventCRF();
        } else {
            this.validateEventCRFAndAction();
        }
        this.updatePresetValues(this.ecb);
        Boolean b = (Boolean)this.request.getAttribute("ignore");
        if (this.fp.isSubmitted() && b == null) {
            discNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
            if (discNotes == null) {
                discNotes = new FormDiscrepancyNotes();
                this.session.setAttribute("fdnotes", (Object)discNotes);
            }
            DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
            v.addValidation("interviewer", 1);
            v.addValidation("interviewDate", 4);
            v.alwaysExecuteLastValidation("interviewDate");
            this.errors = v.validate();
            if (this.errors.isEmpty()) {
                this.ecb.setInterviewerName(this.fp.getString("interviewer"));
                this.ecb.setDateInterviewed(this.fp.getDate("interviewDate"));
                if (this.ecdao == null) {
                    this.ecdao = new EventCRFDAO(this.sm.getDataSource());
                }
                this.ecb = (EventCRFBean)this.ecdao.update((EntityBean)this.ecb);
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                AddNewSubjectServlet.saveFieldNotes((String)"interviewer", (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)this.ecb.getId(), (String)"EventCRF", (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)"interviewDate", (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)this.ecb.getId(), (String)"EventCRF", (StudyBean)this.currentStudy);
                if (this.ecdao.isQuerySuccessful()) {
                    this.updatePresetValues(this.ecb);
                    if (!this.fp.getBoolean("editInterview", true)) {
                        this.addPageMessage(respage.getString("interviewer_name_date_updated"));
                    }
                } else {
                    this.addPageMessage(respage.getString("database_error_interviewer_name_date_not_updated"));
                }
            } else {
                String[] textFields = new String[]{"interviewer", "interviewDate"};
                this.fp.setCurrentStringValuesAsPreset(textFields);
                this.setInputMessages(this.errors);
                this.setPresetValues(this.fp.getPresetValues());
            }
        } else {
            discNotes = new FormDiscrepancyNotes();
            this.session.setAttribute("fdnotes", (Object)discNotes);
        }
        DisplayTableOfContentsBean displayBean = TableOfContentsServlet.getDisplayBean((EventCRFBean)this.ecb, (DataSource)this.sm.getDataSource(), (StudyBean)this.currentStudy);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean ssb = (StudySubjectBean)ssdao.findByPK(this.ecb.getStudySubjectId());
        ArrayList beans = ViewStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudySubjectBean)ssb, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole);
        this.request.setAttribute("studySubject", (Object)ssb);
        this.request.setAttribute("beans", (Object)beans);
        this.request.setAttribute("eventCRF", (Object)this.ecb);
        this.request.setAttribute("toc", (Object)displayBean);
        boolean allowEnterData = true;
        if (StringUtil.isBlank((String)this.ecb.getInterviewerName()) && (discNotes == null || discNotes.getNotes("interviewer").isEmpty())) {
            allowEnterData = false;
        }
        if (this.ecb.getDateInterviewed() == null && (discNotes == null || discNotes.getNotes("interviewDate").isEmpty())) {
            allowEnterData = false;
        }
        if (!allowEnterData) {
            this.request.setAttribute("allowEnterData", (Object)"no");
            this.forwardPage(Page.INTERVIEWER_ENTIRE_PAGE);
        } else if (this.fp.getBoolean("editInterview", true)) {
            this.request.setAttribute("allowEnterData", (Object)"yes");
            this.forwardPage(Page.INTERVIEWER);
        } else if (this.fp.isSubmitted() && !this.errors.isEmpty()) {
            this.request.setAttribute("allowEnterData", (Object)"no");
            this.forwardPage(Page.INTERVIEWER);
        } else {
            this.request.setAttribute("allowEnterData", (Object)"yes");
            this.forwardPage(Page.TABLE_OF_CONTENTS);
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.fp = new FormProcessor(this.request);
        this.getEventCRFAndAction();
        Role r = this.currentRole.getRole();
        boolean isSuper = DisplayEventCRFBean.isSuper((UserAccountBean)this.ub, (Role)r);
        if (!SubmitDataServlet.maySubmitData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            String exceptionName = resexception.getString("no_permission_to_perform_data_entry");
            String noAccessMessage = respage.getString("you_may_not_perform_data_entry_on_a_CRF") + " " + respage.getString("change_study_contact_study_coordinator");
            this.addPageMessage(noAccessMessage);
            throw new InsufficientPermissionException(Page.MENU, exceptionName, "1");
        }
        if (this.action.equals("ide_s")) {
            return;
        }
        if (!this.ecb.isActive()) {
            this.addPageMessage(respage.getString("event_CRF_not_exist_contact_study_coordinator"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("event_CRF_not_belong_current_study"), "1");
        }
        if (this.action.equals("ide_c")) {
            if (this.ecb.getOwnerId() == this.ub.getId() || isSuper) {
                return;
            }
            this.addPageMessage(respage.getString("not_begin_DE_on_CRF_not_resume_DE"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("event_CRF_not_belong_current_user"), "1");
        }
        if (this.action.equals("dde_s")) {
            if (this.ecb.getOwnerId() != this.ub.getId()) {
                return;
            }
            if (!DisplayEventCRFBean.initialDataEntryCompletedMoreThanTwelveHoursAgo((EventCRFBean)this.ecb) && !isSuper) {
                this.addPageMessage(respage.getString("began_DE_on_CRF_marked_complete_less_12_not_begin_DE"));
                throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("owner_attempting_DDE_12_hours"), "1");
            }
            return;
        }
        if (this.action.equals("ide_c")) {
            if (this.ecb.getValidatorId() == this.ub.getId() || isSuper) {
                return;
            }
            this.addPageMessage(respage.getString("not_begin_DDE_on_CRF_not_resume_DE"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("validation_event_CRF_not_begun_user"), "1");
        }
        if (this.action.equals("ae")) {
            if (isSuper) {
                return;
            }
            this.addPageMessage(respage.getString("you_may_not_perform_administrative_editing") + " " + respage.getString("change_study_contact_study_coordinator"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("no_permission_to_perform_administrative_editing"), "1");
        }
    }

    public static int getIntById(HashMap h, Integer key) {
        Integer value = (Integer)h.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static String getLink(EventCRFBean ecb) {
        DataEntryStage stage = ecb.getStage();
        String answer = Page.TABLE_OF_CONTENTS_SERVLET.getFileName();
        answer = Page.TABLE_OF_CONTENTS_SERVLET.getFileName();
        answer = answer + "?action=" + TableOfContentsServlet.getActionForStage((DataEntryStage)ecb.getStage());
        answer = answer + "&ecid=" + ecb.getId();
        return answer;
    }

    public static String getActionForStage(DataEntryStage stage) {
        if (!stage.equals((Term)DataEntryStage.UNCOMPLETED)) {
            if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY)) {
                return "ide_c";
            }
            if (stage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE)) {
                return "dde_s";
            }
            if (stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                return "dde_c";
            }
            if (stage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE)) {
                return "ae";
            }
        }
        return "";
    }

    public static ArrayList getSections(EventCRFBean ecb, DataSource ds) {
        SectionDAO sdao = new SectionDAO(ds);
        ItemGroupDAO igdao = new ItemGroupDAO(ds);
        HashMap numItemsBySectionId = sdao.getNumItemsBySectionId();
        HashMap numItemsPlusRepeatBySectionId = sdao.getNumItemsPlusRepeatBySectionId(ecb);
        HashMap numItemsCompletedBySectionId = sdao.getNumItemsCompletedBySectionId(ecb);
        HashMap numItemsPendingBySectionId = sdao.getNumItemsPendingBySectionId(ecb);
        ArrayList sections = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
        for (int i = 0; i < sections.size(); ++i) {
            SectionBean sb = (SectionBean)sections.get(i);
            int sectionId = sb.getId();
            Integer key = new Integer(sectionId);
            int numItems = TableOfContentsServlet.getIntById((HashMap)numItemsBySectionId, (Integer)key);
            List itemGroups = igdao.findLegitGroupBySectionId(sectionId);
            if (!itemGroups.isEmpty()) {
                int numItemsPlusRepeat = TableOfContentsServlet.getIntById((HashMap)numItemsPlusRepeatBySectionId, (Integer)key);
                if (numItemsPlusRepeat > numItems) {
                    sb.setNumItems(numItemsPlusRepeat);
                } else {
                    sb.setNumItems(numItems);
                }
            } else {
                sb.setNumItems(numItems);
            }
            int numItemsCompleted = TableOfContentsServlet.getIntById((HashMap)numItemsCompletedBySectionId, (Integer)key);
            sb.setNumItemsCompleted(numItemsCompleted);
            sb.setNumItemsNeedingValidation(TableOfContentsServlet.getIntById((HashMap)numItemsPendingBySectionId, (Integer)key));
            sections.set(i, sb);
        }
        return sections;
    }

    public static DisplayTableOfContentsBean getDisplayBean(EventCRFBean ecb, DataSource ds, StudyBean currentStudy) {
        DisplayTableOfContentsBean answer = new DisplayTableOfContentsBean();
        answer.setEventCRF(ecb);
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        StudySubjectBean ssb = (StudySubjectBean)ssdao.findByPK(ecb.getStudySubjectId());
        answer.setStudySubject(ssb);
        StudyEventDAO sedao = new StudyEventDAO(ds);
        StudyEventBean seb = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
        answer.setStudyEvent(seb);
        SectionDAO sdao = new SectionDAO(ds);
        ArrayList sections = TableOfContentsServlet.getSections((EventCRFBean)ecb, (DataSource)ds);
        answer.setSections(sections);
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(ds);
        StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(seb.getStudyEventDefinitionId());
        answer.setStudyEventDefinition(sedb);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        CRFVersionBean cvb = (CRFVersionBean)cvdao.findByPK(ecb.getCRFVersionId());
        answer.setCrfVersion(cvb);
        CRFDAO cdao = new CRFDAO(ds);
        CRFBean cb = (CRFBean)cdao.findByPK(cvb.getCrfId());
        answer.setCrf(cb);
        StudyBean studyForStudySubject = new StudyDAO(ds).findByStudySubjectId(ssb.getId());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        EventDefinitionCRFBean edcb = edcdao.findByStudyEventDefinitionIdAndCRFId(studyForStudySubject, sedb.getId(), cb.getId());
        answer.setEventDefinitionCRF(edcb);
        answer.setAction(TableOfContentsServlet.getActionForStage((DataEntryStage)ecb.getStage()));
        return answer;
    }

    public static DisplayTableOfContentsBean getDisplayBeanWithShownSections(DataSource ds, DisplayTableOfContentsBean displayTableOfContentsBean, DynamicsMetadataService dynamicsMetadataService) {
        if (displayTableOfContentsBean == null) {
            return displayTableOfContentsBean;
        }
        EventCRFBean ecb = displayTableOfContentsBean.getEventCRF();
        SectionDAO sectionDAO = new SectionDAO(ds);
        ArrayList sectionBeans = TableOfContentsServlet.getSections((EventCRFBean)ecb, (DataSource)ds);
        ArrayList<SectionBean> showSections = new ArrayList<SectionBean>();
        if (sectionBeans != null && sectionBeans.size() > 0) {
            for (SectionBean s : sectionBeans) {
                if (sectionDAO.containNormalItem(Integer.valueOf(s.getCRFVersionId()), Integer.valueOf(s.getId()))) {
                    showSections.add(s);
                    continue;
                }
                if (dynamicsMetadataService.hasShowingDynGroupInSection(s.getId(), s.getCRFVersionId(), ecb.getId()).booleanValue()) {
                    showSections.add(s);
                    continue;
                }
                if (!dynamicsMetadataService.hasShowingDynItemInSection(s.getId(), s.getCRFVersionId(), ecb.getId()).booleanValue()) continue;
                showSections.add(s);
            }
            displayTableOfContentsBean.setSections(showSections);
        }
        return displayTableOfContentsBean;
    }

    public static LinkedList<Integer> sectionIdsInToc(DisplayTableOfContentsBean toc) {
        ArrayList sectionBeans;
        LinkedList<Integer> ids = new LinkedList<Integer>();
        if (toc != null && (sectionBeans = toc.getSections()) != null && sectionBeans.size() > 0) {
            for (int i = 0; i < sectionBeans.size(); ++i) {
                SectionBean s = (SectionBean)sectionBeans.get(i);
                ids.add(s.getId());
            }
        }
        return ids;
    }

    public static int sectionIndexInToc(SectionBean sb, DisplayTableOfContentsBean toc, LinkedList<Integer> sectionIdsInToc) {
        ArrayList sectionBeans = new ArrayList();
        int index = -1;
        if (toc != null) {
            sectionBeans = toc.getSections();
        }
        if (sectionBeans != null && sectionBeans.size() > 0) {
            for (int i = 0; i < sectionIdsInToc.size(); ++i) {
                if (sb.getId() != sectionIdsInToc.get(i).intValue()) continue;
                index = i;
                break;
            }
        }
        return index;
    }
}

