/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableSubstitutionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(VariableSubstitutionHelper.class);
    private static final String ENCODING = "UTF-8";
    private static final String TOKEN_REGEX = "\\$\\{.*?\\}";

    public static void replaceVariables(DisplaySectionBean section, StudyBean study, StudySubjectBean studySubject, StudyEventDefinitionBean eventDef, StudyEventBean event, DataSource dataSource) {
        StrSubstitutor subst = new StrSubstitutor(VariableSubstitutionHelper.buildTokensMap((DisplaySectionBean)section, (StudySubjectBean)studySubject, (StudyBean)study, (StudyEventDefinitionBean)eventDef, (StudyEventBean)event, (DataSource)dataSource));
        for (DisplayItemBean displayItem : section.getItems()) {
            ItemFormMetadataBean metadata = displayItem.getMetadata();
            metadata.setRightItemText(VariableSubstitutionHelper.replace((StrSubstitutor)subst, (String)metadata.getRightItemText()));
            metadata.setLeftItemText(VariableSubstitutionHelper.replace((StrSubstitutor)subst, (String)metadata.getLeftItemText()));
            metadata.setHeader(VariableSubstitutionHelper.replace((StrSubstitutor)subst, (String)metadata.getHeader()));
            metadata.setSubHeader(VariableSubstitutionHelper.replace((StrSubstitutor)subst, (String)metadata.getSubHeader()));
        }
    }

    private static final String replace(StrSubstitutor subst, String value) {
        return subst.replace(value).replaceAll("\\$\\{.*?\\}", "");
    }

    private static Map<String, String> buildTokensMap(DisplaySectionBean section, StudySubjectBean studySubject, StudyBean study, StudyEventDefinitionBean eventDef, StudyEventBean event, DataSource dataSource) {
        ItemDAO itemDAO = new ItemDAO(dataSource);
        ArrayList items = itemDAO.findAllWithItemDataByCRFVersionId(section.getCrfVersion().getId(), section.getEventCRF().getId());
        HashMap<String, String> tokensMap = new HashMap<String, String>();
        tokensMap.put("studySubject", VariableSubstitutionHelper.encode((String)studySubject.getName()));
        if (studySubject.getOid() != null && !studySubject.getOid().isEmpty()) {
            tokensMap.put("studySubjectOID", VariableSubstitutionHelper.encode((String)studySubject.getOid()));
        } else {
            tokensMap.put("studySubjectOID", "");
        }
        tokensMap.put("studyName", VariableSubstitutionHelper.encode((String)study.getName()));
        tokensMap.put("eventName", VariableSubstitutionHelper.encode((String)eventDef.getName()));
        if (event == null) {
            tokensMap.put("eventOrdinal", "");
        } else {
            tokensMap.put("eventOrdinal", VariableSubstitutionHelper.encode((String)Integer.toString(event.getSampleOrdinal())));
        }
        tokensMap.put("crfName", VariableSubstitutionHelper.encode((String)section.getCrf().getName()));
        tokensMap.put("crfVersion", VariableSubstitutionHelper.encode((String)section.getCrfVersion().getName()));
        for (ItemBean item : items) {
            ArrayList<String> values = new ArrayList<String>();
            for (ItemDataBean itemData : item.getItemDataElements()) {
                values.add(itemData.getValue());
            }
            String value = StringUtils.join(values, (char)',');
            tokensMap.put("item['" + item.getName() + "']", VariableSubstitutionHelper.encode((String)value));
        }
        if (LOG.isDebugEnabled()) {
            for (String key : tokensMap.keySet()) {
                LOG.debug("Substitution context: {} = {}", (Object)key, tokensMap.get(key));
            }
        }
        return tokensMap;
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid encoding UTF-8", e);
        }
    }
}

