/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.domain.rule.RulesPostImportContainer;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class VerifyImportedRuleServlet
extends SecureController {
    Locale locale;
    RuleSetServiceInterface ruleSetService;

    public void processRequest() throws Exception {
        RulesPostImportContainer rulesContainer;
        String action = this.request.getParameter("action");
        FormProcessor fp = new FormProcessor(this.request);
        if ("confirm".equalsIgnoreCase(action)) {
            rulesContainer = (RulesPostImportContainer)this.session.getAttribute("importedData");
            this.logger.info("Size of ruleDefs : " + rulesContainer.getRuleDefs().size());
            this.logger.info("Size of ruleSets : " + rulesContainer.getRuleSets().size());
            this.forwardPage(Page.VERIFY_RULES_IMPORT);
        }
        if ("save".equalsIgnoreCase(action)) {
            rulesContainer = (RulesPostImportContainer)this.session.getAttribute("importedData");
            this.getRuleSetService().saveImport(rulesContainer);
            MessageFormat mf = new MessageFormat("");
            mf.applyPattern(resword.getString("successful_rule_upload"));
            Object[] arguments = new Object[]{rulesContainer.getValidRuleDefs().size() + rulesContainer.getDuplicateRuleDefs().size(), rulesContainer.getValidRuleSetDefs().size() + rulesContainer.getDuplicateRuleSetDefs().size()};
            this.addPageMessage(mf.format(arguments));
            ArrayList pageMessages = (ArrayList)this.request.getAttribute("pageMessages");
            this.session.setAttribute("pageMessages", (Object)pageMessages);
            this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
        }
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }
}

