/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.hibernate.RuleSetAuditDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleAuditDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.domain.rule.RuleSetAuditBean;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleAuditBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewRuleSetAuditServlet
extends SecureController {
    private static String RULESET_ID = "ruleSetId";
    private static String RULESET = "ruleSet";
    private static String RULESETAUDITS = "ruleSetAudits";
    private static String RULESETRULEAUDITS = "ruleSetRuleAudits";
    private RuleSetServiceInterface ruleSetService;
    private RuleSetAuditDao ruleSetAuditDao;
    private RuleSetRuleAuditDao ruleSetRuleAuditDao;
    private UserAccountDAO userAccountDAO;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        if (ruleSetId == null) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            RuleSetBean ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
            ArrayList ruleSetAudits = this.getRuleSetAuditDao().findAllByRuleSet(ruleSetBean);
            ArrayList ruleSetRuleAudits = this.getRuleSetRuleAuditDao().findAllByRuleSet(ruleSetBean);
            for (RuleSetRuleAuditBean ruleSetRuleAuditBean : ruleSetRuleAudits) {
                ruleSetRuleAuditBean.setUpdater((UserAccountBean)this.getUserAccountDAO().findByPK(ruleSetRuleAuditBean.getUpdaterId().intValue()));
            }
            for (RuleSetAuditBean ruleSetAudit : ruleSetAudits) {
                ruleSetAudit.setUpdater((UserAccountBean)this.getUserAccountDAO().findByPK(ruleSetAudit.getUpdaterId().intValue()));
            }
            this.request.setAttribute(RULESET, (Object)ruleSetBean);
            this.request.setAttribute(RULESETAUDITS, (Object)ruleSetAudits);
            this.request.setAttribute(RULESETRULEAUDITS, (Object)ruleSetRuleAudits);
            this.forwardPage(Page.VIEW_RULESET_AUDITS);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }

    private RuleSetAuditDao getRuleSetAuditDao() {
        this.ruleSetAuditDao = this.ruleSetAuditDao != null ? this.ruleSetAuditDao : (RuleSetAuditDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetAuditDao");
        return this.ruleSetAuditDao;
    }

    private RuleSetRuleAuditDao getRuleSetRuleAuditDao() {
        this.ruleSetRuleAuditDao = this.ruleSetRuleAuditDao != null ? this.ruleSetRuleAuditDao : (RuleSetRuleAuditDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleAuditDao");
        return this.ruleSetRuleAuditDao;
    }

    private UserAccountDAO getUserAccountDAO() {
        this.userAccountDAO = this.userAccountDAO != null ? this.userAccountDAO : new UserAccountDAO(this.sm.getDataSource());
        return this.userAccountDAO;
    }
}

