/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewRuleSetServlet
extends SecureController {
    private static String RULESET_ID = "ruleSetId";
    private static String RULESET = "ruleSet";
    private static String TARGET = "target";
    private static String RULE_OID = "ruleOid";
    private RuleSetServiceInterface ruleSetService;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        if (ruleSetId == null) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            RuleSetBean ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
            Boolean firstTime = true;
            String validRuleSetRuleIds = "";
            for (int j = 0; j < ruleSetBean.getRuleSetRules().size(); ++j) {
                RuleSetRuleBean rsr = (RuleSetRuleBean)ruleSetBean.getRuleSetRules().get(j);
                if (rsr.getStatus() != Status.AVAILABLE) continue;
                if (firstTime.booleanValue()) {
                    validRuleSetRuleIds = validRuleSetRuleIds + rsr.getId();
                    firstTime = false;
                    continue;
                }
                validRuleSetRuleIds = validRuleSetRuleIds + "," + rsr.getId();
            }
            CoreResources core = (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
            String designerUrl = CoreResources.getField((String)"designer.url") + "access?host=" + this.getHostPathFromSysUrl(CoreResources.getField((String)"sysURL.base"), this.request.getContextPath()) + "&app=" + this.getContextPath(this.request);
            UserAccountBean currentUser = (UserAccountBean)this.request.getSession().getAttribute("userBean");
            this.request.setAttribute("designerUrl", (Object)designerUrl);
            this.request.setAttribute("currentStudy", (Object)this.currentStudy.getOid());
            this.request.setAttribute("providerUser", (Object)currentUser.getName());
            this.request.setAttribute("validRuleSetRuleIds", (Object)validRuleSetRuleIds);
            this.request.setAttribute("ruleSetRuleBeans", (Object)this.orderRuleSetRulesByStatus(ruleSetBean));
            this.request.setAttribute(RULESET, (Object)ruleSetBean);
            this.forwardPage(Page.VIEW_RULES);
        }
    }

    private String getHostPathFromSysUrl(String sysURL, String contextPath) {
        return sysURL.replaceAll(contextPath + "/", "");
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath().replaceAll("/", "");
        return contextPath;
    }

    List<RuleSetRuleBean> orderRuleSetRulesByStatus(RuleSetBean ruleSet) {
        ArrayList<RuleSetRuleBean> availableRuleSetRules = new ArrayList<RuleSetRuleBean>();
        ArrayList<RuleSetRuleBean> nonAvailableRuleSetRules = new ArrayList<RuleSetRuleBean>();
        for (RuleSetRuleBean ruleSetRuleBean : ruleSet.getRuleSetRules()) {
            if (ruleSetRuleBean.getStatus() == Status.AVAILABLE) {
                availableRuleSetRules.add(ruleSetRuleBean);
                continue;
            }
            nonAvailableRuleSetRules.add(ruleSetRuleBean);
        }
        availableRuleSetRules.addAll(nonAvailableRuleSetRules);
        return availableRuleSetRules;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }
}

