/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.urlRewrite;

import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.control.core.CoreSecureController;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.urlRewrite.OpenClinicaResource;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRewriteServlet
extends CoreSecureController {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String requestURI = request.getRequestURI();
            String requestQueryStr = request.getQueryString();
            OpenClinicaResource ocResource = null;
            String requestOIDStr = null;
            String RESTUrlStart = "/ClinicalData/html/view/";
            if (null != requestURI && requestURI.contains("/ClinicalData/html/view/")) {
                requestOIDStr = requestURI.substring(requestURI.indexOf(RESTUrlStart) + RESTUrlStart.length(), requestURI.length());
            }
            if (null != (ocResource = this.getOpenClinicaResourceFromURL(requestOIDStr))) {
                if (ocResource.isInValid()) {
                    response.sendError(404);
                    this.errors = new HashMap();
                    Validator.addError((HashMap)this.errors, (String)"error:", (String)((String)ocResource.getMessages().get(0)));
                    request.setAttribute("formMessages", (Object)this.errors);
                }
                if (null != ocResource && ocResource.getFormVersionOID() != null) {
                    HashMap mapQueryParams = this.getQueryStringParameters(requestQueryStr);
                    if (null != ocResource.getEventDefinitionCrfId()) {
                        request.setAttribute("eventDefinitionCRFId", (Object)ocResource.getEventDefinitionCrfId());
                    }
                    if (null != ocResource.getEventCrfId()) {
                        request.setAttribute("ecId", (Object)ocResource.getEventCrfId().toString());
                    }
                    if (null != ocResource.getStudyEventId()) {
                        request.setAttribute("eventId", (Object)ocResource.getStudyEventId().toString());
                    }
                    if (null != ocResource.getStudySubjectID()) {
                        request.setAttribute("studySubjectId", (Object)ocResource.getStudySubjectID().toString());
                    }
                    if (null != mapQueryParams && mapQueryParams.size() != 0) {
                        if (mapQueryParams.containsKey("tabId")) {
                            request.setAttribute("tabId", mapQueryParams.get("tabId"));
                        }
                        if (null != ocResource.getStudySubjectID() && mapQueryParams.containsKey("exitTo")) {
                            request.setAttribute("exitTo", (Object)("ViewStudySubject?id=" + ocResource.getStudySubjectID()));
                        }
                        SectionDAO sdao = new SectionDAO(this.getDataSource());
                        if (mapQueryParams.containsKey("tabId")) {
                            HashMap sectionIdMap = sdao.getSectionIdForTabId(ocResource.getFormVersionID().intValue(), Integer.parseInt((String)mapQueryParams.get("tabId")));
                            Integer sectionId = null;
                            if (sectionIdMap != null && sectionIdMap.size() != 0) {
                                sectionId = (Integer)sectionIdMap.get("section_id");
                            }
                            if (null != sectionId) {
                                request.setAttribute("sectionId", sectionId);
                            }
                        }
                    }
                    this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_SERVLET_REST_URL, request, response);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> getQueryStringParameters(String queryString) {
        HashMap<String, String> mapQueryParams = new HashMap<String, String>();
        if (null != queryString && !queryString.equalsIgnoreCase("")) {
            if (queryString.contains("&")) {
                String[] tokens = queryString.split("&");
                if (tokens.length != 0) {
                    String token = null;
                    String tokenBeforeEq = null;
                    String tokenAfterEq = null;
                    for (int i = 0; i < tokens.length; ++i) {
                        token = tokens[i];
                        if (null == token || token.equalsIgnoreCase("") || !token.contains("=")) continue;
                        tokenBeforeEq = token.substring(0, token.indexOf("="));
                        tokenAfterEq = token.substring(token.indexOf("=") + 1);
                        mapQueryParams.put(tokenBeforeEq, tokenAfterEq);
                    }
                }
            } else if (queryString.contains("=")) {
                mapQueryParams.put(queryString.substring(0, queryString.indexOf("=")), queryString.substring(queryString.indexOf("=") + 1));
            }
        }
        return mapQueryParams;
    }

    public OpenClinicaResource getOpenClinicaResourceFromURL(String URLPath) {
        String[] tokens;
        OpenClinicaResource openClinicaResource = new OpenClinicaResource();
        if (null != URLPath && !URLPath.equals("") && URLPath.contains("/") && (tokens = URLPath.split("/")).length != 0) {
            String URLParamValue = "";
            StudyDAO stdao = new StudyDAO(this.getDataSource());
            StudySubjectDAO ssubdao = new StudySubjectDAO(this.getDataSource());
            StudyEventDefinitionDAO sedefdao = new StudyEventDefinitionDAO(this.getDataSource());
            CRFDAO crfdao = new CRFDAO(this.getDataSource());
            CRFVersionDAO crfvdao = new CRFVersionDAO(this.getDataSource());
            ItemDAO idao = new ItemDAO(this.getDataSource());
            ItemGroupDAO igdao = new ItemGroupDAO(this.getDataSource());
            StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
            StudyBean study = null;
            StudySubjectBean subject = null;
            StudyEventDefinitionBean sed = null;
            Object c = null;
            CRFVersionBean cv = null;
            Object item = null;
            ItemGroupBean ig = null;
            StudyEventBean studyEvent = null;
            Integer studySubjectId = 0;
            Integer eventDefId = 0;
            Integer eventRepeatKey = 0;
            block7: for (int i = 0; i < tokens.length; ++i) {
                URLParamValue = tokens[i].trim();
                this.logger.info("URLPAramValue::" + URLParamValue);
                if (null == URLParamValue || URLParamValue.equals("")) continue;
                switch (i) {
                    case 0: {
                        study = stdao.findByOid(URLParamValue);
                        if (study == null) {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("invalid_study_oid"));
                            return openClinicaResource;
                        }
                        openClinicaResource.setStudyOID(URLParamValue);
                        if (null == study) continue block7;
                        openClinicaResource.setStudyID(Integer.valueOf(study.getId()));
                        continue block7;
                    }
                    case 1: {
                        subject = ssubdao.findByOidAndStudy(URLParamValue, study.getId());
                        if (subject == null) {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("invalid_subject_oid"));
                            return openClinicaResource;
                        }
                        openClinicaResource.setStudySubjectOID(URLParamValue);
                        if (null == subject) continue block7;
                        studySubjectId = subject.getId();
                        openClinicaResource.setStudySubjectID(studySubjectId);
                        continue block7;
                    }
                    case 2: {
                        String seoid = "";
                        String eventOrdinal = "";
                        if (URLParamValue.contains("%5B") && URLParamValue.contains("%5D")) {
                            seoid = URLParamValue.substring(0, URLParamValue.indexOf("%5B"));
                            openClinicaResource.setStudyEventDefOID(seoid);
                            eventOrdinal = URLParamValue.substring(URLParamValue.indexOf("%5B") + 3, URLParamValue.indexOf("%5D"));
                        } else if (URLParamValue.contains("[") && URLParamValue.contains("]")) {
                            seoid = URLParamValue.substring(0, URLParamValue.indexOf("["));
                            this.logger.info("seoid" + seoid);
                            openClinicaResource.setStudyEventDefOID(seoid);
                            eventOrdinal = URLParamValue.substring(URLParamValue.indexOf("[") + 1, URLParamValue.indexOf("]"));
                            this.logger.info("eventOrdinal::" + eventOrdinal);
                        } else {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("event_ordinal_not_specified"));
                            return openClinicaResource;
                        }
                        if (null != seoid && null != study) {
                            sed = sedefdao.findByOidAndStudy(seoid, study.getId(), study.getParentStudyId());
                            if (null == sed) {
                                openClinicaResource.setInValid(true);
                                openClinicaResource.getMessages().add(resexception.getString("invalid_event_oid"));
                                return openClinicaResource;
                            }
                            eventDefId = sed.getId();
                            openClinicaResource.setStudyEventDefID(eventDefId);
                        }
                        if (null == eventRepeatKey) continue block7;
                        eventRepeatKey = Integer.parseInt(eventOrdinal.trim());
                        studyEvent = (StudyEventBean)sedao.findByStudySubjectIdAndDefinitionIdAndOrdinal(subject.getId(), sed.getId(), eventRepeatKey.intValue());
                        if (null == studyEvent || studyEvent.getId() == 0) {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("invalid_event_ordinal"));
                            return openClinicaResource;
                        }
                        openClinicaResource.setStudyEventRepeatKey(eventRepeatKey);
                        continue block7;
                    }
                    case 3: {
                        openClinicaResource.setFormVersionOID(URLParamValue);
                        cv = crfvdao.findByOid(URLParamValue);
                        if (cv == null) {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("invalid_crf_oid"));
                            return openClinicaResource;
                        }
                        openClinicaResource.setFormVersionID(Integer.valueOf(cv.getId()));
                        if (cv.getStatus().equals((Term)Status.DELETED)) {
                            openClinicaResource.setInValid(true);
                            openClinicaResource.getMessages().add(resexception.getString("removed_crf"));
                            return openClinicaResource;
                        }
                        if (null == study) continue block7;
                        HashMap studySubjectCRFDataDetails = sedao.getStudySubjectCRFData(study, studySubjectId.intValue(), eventDefId.intValue(), URLParamValue, eventRepeatKey.intValue());
                        if (null != studySubjectCRFDataDetails && studySubjectCRFDataDetails.size() != 0) {
                            if (studySubjectCRFDataDetails.containsKey("event_crf_id")) {
                                openClinicaResource.setEventCrfId((Integer)studySubjectCRFDataDetails.get("event_crf_id"));
                            }
                            if (studySubjectCRFDataDetails.containsKey("event_definition_crf_id")) {
                                openClinicaResource.setEventDefinitionCrfId((Integer)studySubjectCRFDataDetails.get("event_definition_crf_id"));
                            }
                            if (!studySubjectCRFDataDetails.containsKey("study_event_id")) continue block7;
                            openClinicaResource.setStudyEventId((Integer)studySubjectCRFDataDetails.get("study_event_id"));
                            continue block7;
                        }
                        openClinicaResource.setInValid(true);
                        openClinicaResource.getMessages().add(resexception.getString("either_no_data_for_crf_or_data_entry_not_started"));
                        return openClinicaResource;
                    }
                    case 4: {
                        String igoid = "";
                        String igRepeatKey = "";
                        if (URLParamValue.contains("[")) {
                            igoid = URLParamValue.substring(1, URLParamValue.indexOf("["));
                            igRepeatKey = URLParamValue.substring(URLParamValue.indexOf("["), URLParamValue.indexOf("}]"));
                        }
                        if (null != igoid && null != cv && null != (ig = igdao.findByOidAndCrf(URLParamValue, cv.getCrfId()))) {
                            openClinicaResource.setItemGroupID(Integer.valueOf(ig.getId()));
                        }
                        if (null == igRepeatKey) continue block7;
                        openClinicaResource.setItemGroupRepeatKey(Integer.valueOf(Integer.parseInt(igRepeatKey)));
                        continue block7;
                    }
                }
            }
        }
        return openClinicaResource;
    }
}

