/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.verification.ClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.DefaultClientAuthenticationCache;
import org.springframework.security.oauth2.provider.verification.VerificationCodeAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AccessConfirmationController
extends AbstractController {
    private final ClientAuthenticationCache authenticationCache = new DefaultClientAuthenticationCache();
    private ClientDetailsService clientDetailsService;

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        Assert.notNull((Object)this.clientDetailsService, (String)"A client details service must be supplied.");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VerificationCodeAuthenticationToken clientAuth = this.getAuthenticationCache().getAuthentication(request, response);
        if (clientAuth == null) {
            throw new IllegalStateException("No client authentication request to authorize.");
        }
        ClientDetails client = this.getClientDetailsService().loadClientByClientId(clientAuth.getClientId());
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        model.put("auth_request", clientAuth);
        model.put("client", client);
        return new ModelAndView("access_confirmation", model);
    }

    public ClientAuthenticationCache getAuthenticationCache() {
        return this.authenticationCache;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    @Autowired
    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

