/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.restful.ODMClinicaDataResource;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/auth/api/v1/clinicaldata"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class ODMClinicalDataController {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Autowired
    ODMClinicaDataResource odmClinicaDataResource;

    @RequestMapping(value={"/json/view/{studyOID}/{studySubjectIdentifier}/{studyEventOID}/{formVersionOID}"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getClinicalData(@PathVariable(value="studyOID") String studyOID, @PathVariable(value="formVersionOID") String formVersionOID, @PathVariable(value="studyEventOID") String studyEventOID, @PathVariable(value="studySubjectIdentifier") String studySubjectIdentifier, @RequestParam(value="includeDNs", defaultValue="n", required=false) String includeDns, @RequestParam(value="includeAudits", defaultValue="n", required=false) String includeAudits, HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        String result = this.odmClinicaDataResource.getODMClinicaldata(studyOID, formVersionOID, studyEventOID, studySubjectIdentifier, includeDns, includeAudits, request);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(result);
    }
}

