/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.controller.RuleController;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.EventCrfDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.ParticipantEventService;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.web.pform.PFormCache;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.cdisc.ns.odm.v130_api.ODM;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionClinicalData;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionFormData;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionStudyEventData;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionSubjectData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/odmk"})
public class OdmController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    @Autowired
    RuleController ruleController;
    @Autowired
    EventCrfDao eventCrfDao;
    public static final String FORM_CONTEXT = "ecid";
    ParticipantPortalRegistrar participantPortalRegistrar;
    StudyDAO sdao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/studies/{study}/metadata"}, method={RequestMethod.GET})
    public ModelAndView getStudyMetadata(Model model, HttpSession session, @PathVariable(value="study") String studyOid, HttpServletResponse response) throws Exception {
        if (!this.mayProceed(studyOid)) {
            return null;
        }
        return this.ruleController.studyMetadata(model, session, studyOid, response);
    }

    @RequestMapping(value={"/study/{studyOid}/studysubject/{studySubjectOid}/events"}, method={RequestMethod.GET})
    @ResponseBody
    public ODM getEvent(@PathVariable(value="studyOid") String studyOid, @PathVariable(value="studySubjectOid") String studySubjectOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        return this.getODM(studyOid, studySubjectOid);
    }

    private ODM getODM(String studyOID, String subjectKey) {
        ODM odm = new ODM();
        String ssoid = subjectKey;
        if (ssoid == null) {
            return null;
        }
        CRFVersionDAO versionDAO = new CRFVersionDAO((DataSource)this.dataSource);
        StudyDAO studyDAO = new StudyDAO((DataSource)this.dataSource);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO((DataSource)this.dataSource);
        EventCRFDAO eventCRFDAO = new EventCRFDAO((DataSource)this.dataSource);
        ItemDataDAO itemDataDAO = new ItemDataDAO((DataSource)this.dataSource);
        CRFDAO crfDAO = new CRFDAO((DataSource)this.dataSource);
        ArrayList<ODMcomplexTypeDefinitionFormData> formDatas = new ArrayList<ODMcomplexTypeDefinitionFormData>();
        try {
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOid(ssoid);
            ParticipantEventService participantEventService = new ParticipantEventService((DataSource)this.dataSource);
            StudyEventBean nextEvent = participantEventService.getNextParticipantEvent(studySubjectBean);
            if (nextEvent != null) {
                this.logger.debug("Found event: " + nextEvent.getName() + " - ID: " + nextEvent.getId());
                ArrayList eventCrfs = eventCRFDAO.findAllByStudyEvent(nextEvent);
                StudyBean study = studyDAO.findByOid(studyOID);
                if (!this.mayProceed(studyOID, studySubjectBean)) {
                    return odm;
                }
                List eventDefCrfs = participantEventService.getEventDefCrfsForStudyEvent(studySubjectBean, nextEvent);
                for (EventDefinitionCRFBean eventDefCrf : eventDefCrfs) {
                    if (!eventDefCrf.isParticipantForm()) continue;
                    EventCRFBean eventCRF = participantEventService.getExistingEventCRF(studySubjectBean, nextEvent, eventDefCrf);
                    boolean itemDataExists = false;
                    boolean validStatus = true;
                    CRFVersionBean crfVersion = null;
                    if (eventCRF != null) {
                        if (eventCRF.getStatus().getId() != 1 && eventCRF.getStatus().getId() != 2) {
                            validStatus = false;
                        }
                        if (itemDataDAO.findAllByEventCRFId(eventCRF.getId()).size() > 0) {
                            itemDataExists = true;
                        }
                        crfVersion = (CRFVersionBean)versionDAO.findByPK(eventCRF.getCRFVersionId());
                    } else {
                        crfVersion = (CRFVersionBean)versionDAO.findByPK(eventDefCrf.getDefaultVersionId());
                    }
                    if (!validStatus) continue;
                    String formUrl = null;
                    formUrl = !itemDataExists ? this.createEnketoUrl(studyOID, crfVersion, nextEvent, ssoid) : this.createEditUrl(studyOID, crfVersion, nextEvent, ssoid);
                    formDatas.add(this.getFormDataPerCrf(crfVersion, nextEvent, (List)eventCrfs, crfDAO, formUrl, itemDataExists));
                }
                return this.createOdm(study, studySubjectBean, nextEvent, formDatas);
            }
            this.logger.debug("Unable to find next event for subject.");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return odm;
    }

    private StudyEventDefinitionBean getStudyEventDefinitionBean(int ID) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO((DataSource)this.dataSource);
        StudyEventDefinitionBean studyEventDefinitionBean = (StudyEventDefinitionBean)seddao.findByPK(ID);
        return studyEventDefinitionBean;
    }

    private ODM createOdm(StudyBean study, StudySubjectBean studySubjectBean, StudyEventBean nextEvent, List<ODMcomplexTypeDefinitionFormData> formDatas) {
        ODM odm = new ODM();
        ODMcomplexTypeDefinitionClinicalData clinicalData = this.generateClinicalData(study);
        ODMcomplexTypeDefinitionSubjectData subjectData = this.generateSubjectData(studySubjectBean);
        ODMcomplexTypeDefinitionStudyEventData studyEventData = this.generateStudyEventData(nextEvent);
        studyEventData.getFormData().addAll(formDatas);
        subjectData.getStudyEventData().add(studyEventData);
        clinicalData.getSubjectData().add(subjectData);
        odm.getClinicalData().add(clinicalData);
        return odm;
    }

    private String createEnketoUrl(String studyOID, CRFVersionBean crfVersion, StudyEventBean nextEvent, String ssoid) throws Exception {
        PFormCache cache = PFormCache.getInstance((ServletContext)this.context);
        String enketoURL = cache.getPFormURL(studyOID, crfVersion.getOid());
        String contextHash = cache.putSubjectContext(ssoid, String.valueOf(nextEvent.getStudyEventDefinitionId()), String.valueOf(nextEvent.getSampleOrdinal()), crfVersion.getOid());
        String url = enketoURL + "?" + FORM_CONTEXT + "=" + contextHash;
        this.logger.debug("Enketo URL for " + crfVersion.getName() + "= " + url);
        return url;
    }

    private String createEditUrl(String studyOID, CRFVersionBean crfVersion, StudyEventBean nextEvent, String ssoid) throws Exception {
        PFormCache cache = PFormCache.getInstance((ServletContext)this.context);
        String contextHash = cache.putSubjectContext(ssoid, String.valueOf(nextEvent.getStudyEventDefinitionId()), String.valueOf(nextEvent.getSampleOrdinal()), crfVersion.getOid());
        String editURL = CoreResources.getField((String)"sysURL.base") + "pages/api/v1/editform/" + studyOID + "/url";
        String url = editURL + "?" + FORM_CONTEXT + "=" + contextHash;
        this.logger.debug("Edit URL for " + crfVersion.getName() + "= " + url);
        return url;
    }

    private ODMcomplexTypeDefinitionFormData getFormDataPerCrf(CRFVersionBean crfVersion, StudyEventBean nextEvent, List<EventCRFBean> eventCrfs, CRFDAO crfDAO, String formUrl, boolean itemDataExists) {
        EventCRFBean selectedEventCRFBean = null;
        CRFBean crfBean = crfDAO.findByVersionId(crfVersion.getId());
        for (EventCRFBean eventCRFBean : eventCrfs) {
            if (eventCRFBean.getCRFVersionId() != crfVersion.getId()) continue;
            selectedEventCRFBean = eventCRFBean;
            break;
        }
        return this.generateFormData(crfVersion, nextEvent, selectedEventCRFBean, crfBean, formUrl, itemDataExists);
    }

    private ODMcomplexTypeDefinitionClinicalData generateClinicalData(StudyBean study) {
        ODMcomplexTypeDefinitionClinicalData clinicalData = new ODMcomplexTypeDefinitionClinicalData();
        clinicalData.setStudyName(study.getName());
        clinicalData.setStudyOID(study.getOid());
        return clinicalData;
    }

    private ODMcomplexTypeDefinitionSubjectData generateSubjectData(StudySubjectBean studySubject) {
        ODMcomplexTypeDefinitionSubjectData subjectData = new ODMcomplexTypeDefinitionSubjectData();
        subjectData.setSubjectKey(studySubject.getOid());
        subjectData.setStudySubjectID(studySubject.getLabel());
        subjectData.setStatus(studySubject.getStatus().getName());
        return subjectData;
    }

    private ODMcomplexTypeDefinitionStudyEventData generateStudyEventData(StudyEventBean studyEvent) {
        ODMcomplexTypeDefinitionStudyEventData studyEventData = new ODMcomplexTypeDefinitionStudyEventData();
        studyEventData.setStartDate(studyEvent.getDateStarted().toString());
        StudyEventDefinitionBean studyEventDefBean = this.getStudyEventDefinitionBean(studyEvent.getStudyEventDefinitionId());
        studyEventData.setEventName(studyEventDefBean.getName());
        studyEventData.setStudyEventOID(studyEventDefBean.getOid());
        studyEventData.setStudyEventRepeatKey(String.valueOf(studyEvent.getSampleOrdinal()));
        return studyEventData;
    }

    private ODMcomplexTypeDefinitionFormData generateFormData(CRFVersionBean crfVersionBean, StudyEventBean nextEvent, EventCRFBean eventCRFBean, CRFBean crfBean, String formUrl, boolean itemDataExists) {
        ODMcomplexTypeDefinitionFormData formData = new ODMcomplexTypeDefinitionFormData();
        formData.setFormOID(crfVersionBean.getOid());
        formData.setFormName(crfBean.getName());
        formData.setVersionDescription(crfVersionBean.getDescription());
        formData.setUrl(formUrl);
        if (eventCRFBean == null) {
            formData.setStatus("Not Started");
        } else {
            EventCrf eventCrf = (EventCrf)this.eventCrfDao.findById(Integer.valueOf(eventCRFBean.getId()));
            if (!itemDataExists) {
                formData.setStatus("Not Started");
            } else {
                formData.setStatus(eventCRFBean.getStatus().getName());
            }
            if (eventCrf.getDateUpdated() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                formData.setStatusChangeTimeStamp(sdf.format(eventCrf.getDateUpdated()));
            }
        }
        return formData;
    }

    private String generateXmlFromObj(Class clazz, ODM odm) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller m = context.createMarshaller();
        StringWriter w = new StringWriter();
        m.marshal((Object)odm, (Writer)w);
        return w.toString();
    }

    private void sortList(ArrayList<EventDefinitionCRFBean> edcBeans) {
        Collections.sort(edcBeans, new /* Unavailable Anonymous Inner Class!! */);
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private boolean mayProceed(String studyOid, StudySubjectBean ssBean) throws Exception {
        boolean accessPermission = false;
        this.logger.info("  studySubjectStatus: " + ssBean.getStatus().getName());
        System.out.println("  studySubjectStatus: " + ssBean.getStatus().getName());
        if (this.mayProceed(studyOid) && ssBean.getStatus() == Status.AVAILABLE) {
            accessPermission = true;
        }
        return accessPermission;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(studyOid).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        System.out.println("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

