/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.controller.ExtractController;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.job.XsltStatefulJob;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobTableFactory;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobs;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.jmesa.facade.TableFacade;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.JobDetailBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="ScheduledJobController")
public class ScheduledJobController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledJobController.class);
    public static final String SCHEDULED_TABLE_ATTRIBUTE = "scheduledTableAttribute";
    @Autowired
    @Qualifier(value="scheduledJobTableFactory")
    private ScheduledJobTableFactory scheduledJobTableFactory;
    public static final String EP_BEAN = "epBean";
    @Autowired
    @Qualifier(value="sdvUtil")
    private SDVUtil sdvUtil;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/listCurrentScheduledJobs"})
    public ModelMap listScheduledJobs(HttpServletRequest request, HttpServletResponse response) throws SchedulerException {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundleProvider.updateLocale((Locale)locale);
        ModelMap gridMap = new ModelMap();
        boolean showMoreLink = false;
        showMoreLink = request.getParameter("showMoreLink") != null ? Boolean.parseBoolean(request.getParameter("showMoreLink").toString()) : true;
        request.setAttribute("showMoreLink", (Object)(showMoreLink + ""));
        request.setAttribute("imagePathPrefix", (Object)"../");
        ArrayList pageMessages = (ArrayList)request.getAttribute("pageMessages");
        if (pageMessages == null) {
            pageMessages = new ArrayList();
        }
        request.setAttribute("pageMessages", pageMessages);
        List listCurrentJobs = new ArrayList();
        listCurrentJobs = this.scheduler.getCurrentlyExecutingJobs();
        Iterator itCurrentJobs = listCurrentJobs.iterator();
        ArrayList<String> currentJobList = new ArrayList<String>();
        while (itCurrentJobs.hasNext()) {
            JobExecutionContext temp = (JobExecutionContext)itCurrentJobs.next();
            currentJobList.add(temp.getTrigger().getJobName() + temp.getTrigger().getGroup());
        }
        String[] triggerGroups = this.scheduler.getTriggerGroupNames();
        ArrayList<SimpleTrigger> simpleTriggers = new ArrayList<SimpleTrigger>();
        int index1 = 0;
        for (String triggerGroup : triggerGroups) {
            String[] triggerNames;
            logger.debug("Group: " + triggerGroup + " contains the following triggers");
            for (String triggerName : triggerNames = this.scheduler.getTriggerNames(triggerGroup)) {
                int state = this.scheduler.getTriggerState(triggerName, triggerGroup);
                logger.debug("- " + triggerName);
                if (state == 1) continue;
                simpleTriggers.add(index1, (SimpleTrigger)this.scheduler.getTrigger(triggerName, triggerGroup));
                ++index1;
            }
        }
        ArrayList<ScheduledJobs> jobsScheduled = new ArrayList<ScheduledJobs>();
        int index = 0;
        for (SimpleTrigger st : simpleTriggers) {
            boolean isExecuting = currentJobList.contains(st.getJobName() + st.getGroup());
            ScheduledJobs jobs = new ScheduledJobs();
            ExtractPropertyBean epBean = null;
            if (st.getJobDataMap() != null) {
                epBean = (ExtractPropertyBean)st.getJobDataMap().get((Object)EP_BEAN);
            }
            if (epBean == null) continue;
            StringBuilder checkbox = new StringBuilder();
            checkbox.append("<input style='margin-right: 5px' type='checkbox'/>");
            StringBuilder actions = new StringBuilder("<table><tr><td>");
            if (isExecuting) {
                actions.append("&nbsp;");
            } else {
                String contextPath = request.getContextPath();
                StringBuilder jsCodeString = new StringBuilder("this.form.method='GET'; this.form.action='").append(contextPath).append("/pages/cancelScheduledJob").append("';").append("this.form.theJobName.value='").append(st.getJobName()).append("';").append("this.form.theJobGroupName.value='").append(st.getJobGroup()).append("';").append("this.form.theTriggerName.value='").append(st.getName()).append("';").append("this.form.theTriggerGroupName.value='").append(st.getGroup()).append("';").append("this.form.submit();");
                actions.append("<td><input type=\"submit\" class=\"button\" value=\"Cancel Job\" ").append("name=\"cancelJob\" onclick=\"").append(jsCodeString.toString()).append("\" />");
            }
            actions.append("</td></tr></table>");
            jobs.setCheckbox(checkbox.toString());
            jobs.setDatasetId(epBean.getDatasetName());
            String fireTime = st.getStartTime() != null ? this.longFormat(locale).format(st.getStartTime()) : "";
            jobs.setFireTime(fireTime);
            if (st.getNextFireTime() != null) {
                jobs.setScheduledFireTime(this.longFormat(locale).format(st.getNextFireTime()));
            }
            jobs.setExportFileName(epBean.getExportFileName()[0]);
            jobs.setAction(actions.toString());
            jobs.setJobStatus(isExecuting ? "Currently Executing" : "Scheduled");
            jobsScheduled.add(index, jobs);
            ++index;
        }
        logger.debug("totalRows" + index);
        request.setAttribute("totalJobs", (Object)index);
        request.setAttribute("jobs", jobsScheduled);
        TableFacade facade = this.scheduledJobTableFactory.createTable(request, response);
        String sdvMatrix = facade.render();
        gridMap.addAttribute(SCHEDULED_TABLE_ATTRIBUTE, (Object)sdvMatrix);
        return gridMap;
    }

    @RequestMapping(value={"/cancelScheduledJob"})
    public String cancelScheduledJob(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="theJobName") String theJobName, @RequestParam(value="theJobGroupName") String theJobGroupName, @RequestParam(value="theTriggerName") String triggerName, @RequestParam(value="theTriggerGroupName") String triggerGroupName, @RequestParam(value="redirection") String redirection, ModelMap model) throws SchedulerException {
        this.scheduler.getJobDetail(theJobName, theJobGroupName);
        logger.debug("About to pause the job-->" + theJobName + "Job Group Name -->" + theJobGroupName);
        SimpleTrigger oldTrigger = (SimpleTrigger)this.scheduler.getTrigger(triggerName, triggerGroupName);
        if (oldTrigger != null) {
            Date startTime = new Date(oldTrigger.getStartTime().getTime() + oldTrigger.getRepeatInterval());
            if (triggerGroupName.equals(ExtractController.TRIGGER_GROUP_NAME)) {
                this.interruptQuartzJob(this.scheduler, theJobName, theJobGroupName);
            }
            this.scheduler.pauseJob(theJobName, theJobGroupName);
            SimpleTrigger newTrigger = new SimpleTrigger(triggerName, triggerGroupName);
            newTrigger.setJobName(theJobName);
            newTrigger.setJobGroup(theJobGroupName);
            newTrigger.setJobDataMap(oldTrigger.getJobDataMap());
            newTrigger.setVolatility(false);
            newTrigger.setRepeatCount(oldTrigger.getRepeatCount());
            newTrigger.setRepeatInterval(oldTrigger.getRepeatInterval());
            newTrigger.setMisfireInstruction(4);
            newTrigger.setStartTime(startTime);
            newTrigger.setRepeatInterval(oldTrigger.getRepeatInterval());
            this.scheduler.unscheduleJob(triggerName, triggerGroupName);
            ArrayList<String> pageMessages = new ArrayList<String>();
            if (triggerGroupName.equals(ExtractController.TRIGGER_GROUP_NAME)) {
                this.scheduler.rescheduleJob(triggerName, triggerGroupName, (Trigger)newTrigger);
                pageMessages.add("The Job  " + theJobName + " has been cancelled");
            } else if (triggerGroupName.equals(XsltTriggerService.TRIGGER_GROUP_NAME)) {
                JobDetailBean jobDetailBean = new JobDetailBean();
                jobDetailBean.setGroup(XsltTriggerService.TRIGGER_GROUP_NAME);
                jobDetailBean.setName(newTrigger.getName());
                jobDetailBean.setJobClass(XsltStatefulJob.class);
                jobDetailBean.setJobDataMap(newTrigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.setVolatility(false);
                this.scheduler.deleteJob(theJobName, theJobGroupName);
                this.scheduler.scheduleJob((JobDetail)jobDetailBean, (Trigger)newTrigger);
                pageMessages.add("The Job " + theJobName + "  has been rescheduled");
            }
            request.setAttribute("pageMessages", pageMessages);
            logger.debug("jobDetails>" + this.scheduler.getJobDetail(theJobName, theJobGroupName));
        }
        this.sdvUtil.forwardRequestFromController(request, response, "/pages/" + redirection);
        return null;
    }

    private void interruptQuartzJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        scheduler.interrupt(jobName, jobGroup);
    }

    private String longFormatString() {
        return "EEE MMM dd HH:mm:ss zzz yyyy";
    }

    private SimpleDateFormat longFormat(Locale locale) {
        return new SimpleDateFormat(this.longFormatString(), locale);
    }
}

