/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.openrosa;

import org.akaza.openclinica.controller.openrosa.ItemItemDataContainer;
import org.akaza.openclinica.logic.expressionTree.ExpressionTreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PformValidator
implements Validator {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public boolean supports(Class<?> clazz) {
        return ItemItemDataContainer.class.equals(clazz);
    }

    public void validate(Object target, Errors e) {
        ItemItemDataContainer container = (ItemItemDataContainer)target;
        String origValue = container.getItemData().getValue();
        Integer responseTypeId = container.getResponseTypeId();
        Integer itemDataTypeId = container.getItem().getItemDataType().getItemDataTypeId();
        this.logger.info("*** Data type id:  ***" + itemDataTypeId);
        if (responseTypeId == 3 || responseTypeId == 7) {
            String[] values;
            for (String value : values = origValue.split(",")) {
                this.subValidator(itemDataTypeId, value.trim(), e);
            }
        } else {
            this.subValidator(itemDataTypeId, origValue, e);
        }
    }

    public void subValidator(Integer itemDataTypeId, String value, Errors e) {
        if (value != null && value != "") {
            switch (itemDataTypeId) {
                case 5: {
                    if (value.length() <= 3999) break;
                    e.reject("value.invalid.STRING");
                    this.logger.info(value + "  ***   value.invalid.STRING    ** TEXT VALUE IS OVER 3999 Characters*");
                    break;
                }
                case 6: {
                    try {
                        Integer.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        e.reject("value.invalid.Integer");
                        this.logger.info(value + "  ***value.invalid.INTEGER***");
                    }
                    break;
                }
                case 7: {
                    try {
                        Float.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        e.reject("value.invalid.float");
                        this.logger.info(value + "   ***value.invalid.REAL***");
                    }
                    break;
                }
                case 9: {
                    if (ExpressionTreeHelper.isDateyyyyMMddDashes((String)value)) break;
                    e.reject("value.invalid.date");
                    this.logger.info(value + "   ***value.invalid.DATE***");
                    break;
                }
                case 10: {
                    if (ExpressionTreeHelper.isDateyyyyMMddDashes((String)value) || ExpressionTreeHelper.isDateyyyyMMDashes((String)value) || ExpressionTreeHelper.isDateyyyyDashes((String)value)) break;
                    e.reject("value.invalid.pdate");
                    this.logger.info(value + "  ***value.invalid.PDATE***");
                    break;
                }
                case 11: {
                    break;
                }
            }
        }
    }
}

