/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.openrosa.processor;

import java.util.Date;
import java.util.List;
import org.akaza.openclinica.controller.openrosa.SubmissionContainer;
import org.akaza.openclinica.controller.openrosa.processor.Processor;
import org.akaza.openclinica.dao.hibernate.CompletionStatusDao;
import org.akaza.openclinica.dao.hibernate.CrfVersionDao;
import org.akaza.openclinica.dao.hibernate.EventCrfDao;
import org.akaza.openclinica.dao.hibernate.EventDefinitionCrfDao;
import org.akaza.openclinica.dao.hibernate.ItemDataDao;
import org.akaza.openclinica.dao.hibernate.StudyDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDefinitionDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.datamap.CrfVersion;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.domain.datamap.Study;
import org.akaza.openclinica.domain.datamap.StudyEvent;
import org.akaza.openclinica.domain.datamap.StudyEventDefinition;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.domain.datamap.SubjectEventStatus;
import org.akaza.openclinica.domain.user.UserAccount;
import org.akaza.openclinica.patterns.ocobserver.StudyEventChangeDetails;
import org.akaza.openclinica.patterns.ocobserver.StudyEventContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class EventProcessor
implements Processor,
Ordered {
    @Autowired
    StudyEventDao studyEventDao;
    @Autowired
    StudyEventDefinitionDao studyEventDefinitionDao;
    @Autowired
    EventCrfDao eventCrfDao;
    @Autowired
    CrfVersionDao crfVersionDao;
    @Autowired
    CompletionStatusDao completionStatusDao;
    @Autowired
    EventDefinitionCrfDao eventDefinitionCrfDao;
    @Autowired
    ItemDataDao itemDataDao;
    @Autowired
    StudyDao studyDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public void process(SubmissionContainer container) throws Exception {
        this.logger.info("Executing Event Processor.");
        Errors errors = container.getErrors();
        StudySubject studySubject = container.getSubject();
        StudyEventDefinition studyEventDefinition = this.studyEventDefinitionDao.findByStudyEventDefinitionId(Integer.valueOf((String)container.getSubjectContext().get("studyEventDefinitionID")).intValue());
        boolean isAnonymous = false;
        if (container.getSubjectContext().get("studySubjectOID") == null) {
            isAnonymous = true;
        }
        if (isAnonymous) {
            this.processAnonymous(container, errors, studySubject, studyEventDefinition);
        } else {
            this.processParticipant(container, errors, studySubject, studyEventDefinition);
        }
        Study study = null;
        study = container.getSubjectContext().get("studyOID") != null ? (Study)this.studyDao.findByOcOID((String)container.getSubjectContext().get("studyOID")) : container.getStudy();
        container.setEventCrf(this.updateEventCrf(container.getEventCrf(), study, studySubject, container.getUser(), isAnonymous));
        container.setStudyEvent(this.updateStudyEvent(container.getStudyEvent(), studyEventDefinition, study, studySubject, container.getUser(), isAnonymous));
    }

    public int getOrder() {
        return 3;
    }

    private void processParticipant(SubmissionContainer container, Errors errors, StudySubject studySubject, StudyEventDefinition studyEventDefinition) throws Exception {
        Integer ordinal = Integer.valueOf((String)container.getSubjectContext().get("studyEventOrdinal"));
        StudyEvent existingEvent = this.studyEventDao.fetchByStudyEventDefOIDAndOrdinal(studyEventDefinition.getOc_oid(), ordinal, Integer.valueOf(studySubject.getStudySubjectId()));
        if (existingEvent == null) {
            container.setStudyEvent(this.createStudyEvent(studySubject, studyEventDefinition, ordinal, container.getUser()));
        } else {
            container.setStudyEvent(existingEvent);
        }
        if (studyEventDefinition.getStatus() != Status.AVAILABLE) {
            this.logger.info("This Crf Version has a Status Not available in this Study Event Defn");
            errors.reject("This Crf Version has a Status Not available in this Study Event Defn");
            throw new Exception("This Crf Version has a Status Not available in this Study Event Defn");
        }
        CrfVersion crfVersion = this.crfVersionDao.findByOcOID((String)container.getSubjectContext().get("crfVersionOID"));
        EventCrf existingEventCrf = this.eventCrfDao.findByStudyEventIdStudySubjectIdCrfId(container.getStudyEvent().getStudyEventId(), container.getSubject().getStudySubjectId(), crfVersion.getCrf().getCrfId());
        if (existingEventCrf == null) {
            this.logger.info("***New EventCrf is created***");
            container.setEventCrf(this.createEventCrf(crfVersion, container.getStudyEvent(), container.getSubject(), container.getUser()));
        } else if (existingEventCrf.getCrfVersion().getOcOid().equals(crfVersion.getOcOid())) {
            this.logger.info("***  Existing EventCrf with same CRF Version  ***");
            container.setEventCrf(existingEventCrf);
        } else {
            errors.reject("Existing EventCrf with other CRF version");
            this.logger.info("***  Existing EventCrf with other CRF version  ***");
            throw new Exception("***  Existing EventCrf with other CRF version  ***");
        }
    }

    private void processAnonymous(SubmissionContainer container, Errors errors, StudySubject studySubject, StudyEventDefinition studyEventDefinition) throws Exception {
        Integer ordinal = 1;
        Integer maxExistingOrdinal = this.studyEventDao.findMaxOrdinalByStudySubjectStudyEventDefinition(studySubject.getStudySubjectId(), studyEventDefinition.getStudyEventDefinitionId());
        CrfVersion crfVersion = this.crfVersionDao.findByOcOID((String)container.getSubjectContext().get("crfVersionOID"));
        while (ordinal <= maxExistingOrdinal + 1) {
            StudyEvent existingStudyEvent = this.studyEventDao.fetchByStudyEventDefOIDAndOrdinal(studyEventDefinition.getOc_oid(), ordinal, Integer.valueOf(studySubject.getStudySubjectId()));
            if (existingStudyEvent == null) {
                container.setStudyEvent(this.createStudyEvent(studySubject, studyEventDefinition, ordinal, container.getUser()));
                container.setEventCrf(this.createEventCrf(crfVersion, container.getStudyEvent(), container.getSubject(), container.getUser()));
                break;
            }
            if (!existingStudyEvent.getStatusId().equals(Status.AVAILABLE.getCode()) || !existingStudyEvent.getSubjectEventStatusId().equals(SubjectEventStatus.SCHEDULED.getCode()) && !existingStudyEvent.getSubjectEventStatusId().equals(SubjectEventStatus.NOT_SCHEDULED.getCode()) && !existingStudyEvent.getSubjectEventStatusId().equals(SubjectEventStatus.DATA_ENTRY_STARTED.getCode())) {
                if (studyEventDefinition.getRepeating().booleanValue()) {
                    Integer n = ordinal;
                    Integer n2 = ordinal = Integer.valueOf(ordinal + 1);
                    continue;
                }
                errors.reject("Existing StudyEvent is not Available and EventDef is not repeating");
                this.logger.info("***  Existing StudyEvent is not Available and EventDef is not repeating  ***");
                throw new Exception("***  Existing StudyEvent is not Available and EventDef is not repeating  ***");
            }
            EventCrf existingEventCrf = this.eventCrfDao.findByStudyEventIdStudySubjectIdCrfId(existingStudyEvent.getStudyEventId(), container.getSubject().getStudySubjectId(), crfVersion.getCrf().getCrfId());
            if (existingEventCrf == null) {
                container.setStudyEvent(existingStudyEvent);
                container.setEventCrf(this.createEventCrf(crfVersion, container.getStudyEvent(), container.getSubject(), container.getUser()));
                break;
            }
            List itemDataList = this.itemDataDao.findByEventCrfId(Integer.valueOf(existingEventCrf.getEventCrfId()));
            if (existingEventCrf.getStatusId().equals(Status.AVAILABLE.getCode()) && itemDataList.size() == 0) {
                container.setStudyEvent(existingStudyEvent);
                container.setEventCrf(existingEventCrf);
                break;
            }
            if (studyEventDefinition.getRepeating().booleanValue()) {
                Integer n = ordinal;
                Integer n3 = ordinal = Integer.valueOf(ordinal + 1);
                continue;
            }
            errors.reject("Existing EventCRF is not usable and EventDef is not repeating");
            this.logger.info("***  Existing EventCRF is not usable and EventDef is not repeating  ***");
            throw new Exception("***  Existing EventCRF is not usable and EventDef is not repeating  ***");
        }
        if (container.getStudyEvent() == null || container.getEventCrf() == null) {
            errors.reject("Unable to identify StudyEvent or EventCrf.");
            this.logger.info("***  Unable to identify StudyEvent or EventCrf.  ***");
            throw new Exception("***  Unable to identify StudyEvent or EventCrf.  ***");
        }
    }

    private StudyEvent createStudyEvent(StudySubject studySubject, StudyEventDefinition studyEventDefinition, Integer ordinal, UserAccount user) {
        Date currentDate = new Date();
        StudyEvent studyEvent = new StudyEvent();
        studyEvent.setStudySubject(studySubject);
        studyEvent.setStudyEventDefinition(studyEventDefinition);
        studyEvent.setSampleOrdinal(ordinal);
        studyEvent.setStatusId(Status.AVAILABLE.getCode());
        studyEvent.setUserAccount(user);
        studyEvent.setDateStart(currentDate);
        studyEvent.setSubjectEventStatusId(SubjectEventStatus.SCHEDULED.getCode());
        studyEvent.setStartTimeFlag(Boolean.valueOf(false));
        studyEvent.setEndTimeFlag(Boolean.valueOf(false));
        studyEvent.setDateCreated(currentDate);
        studyEvent.setLocation("");
        StudyEventChangeDetails changeDetails = new StudyEventChangeDetails(Boolean.valueOf(true), Boolean.valueOf(true));
        StudyEventContainer container = new StudyEventContainer(studyEvent, changeDetails);
        this.studyEventDao.saveOrUpdateTransactional(container);
        studyEvent = this.studyEventDao.fetchByStudyEventDefOIDAndOrdinal(studyEventDefinition.getOc_oid(), ordinal, Integer.valueOf(studySubject.getStudySubjectId()));
        return studyEvent;
    }

    private EventCrf createEventCrf(CrfVersion crfVersion, StudyEvent studyEvent, StudySubject studySubject, UserAccount user) {
        EventCrf eventCrf = new EventCrf();
        Date currentDate = new Date();
        eventCrf.setAnnotations("");
        eventCrf.setDateCreated(currentDate);
        eventCrf.setCrfVersion(crfVersion);
        eventCrf.setInterviewerName("");
        eventCrf.setDateInterviewed(null);
        eventCrf.setUserAccount(user);
        eventCrf.setStatusId(Status.AVAILABLE.getCode());
        eventCrf.setCompletionStatus(this.completionStatusDao.findByCompletionStatusId(1));
        eventCrf.setStudySubject(studySubject);
        eventCrf.setStudyEvent(studyEvent);
        eventCrf.setValidateString("");
        eventCrf.setValidatorAnnotations("");
        eventCrf.setUpdateId(Integer.valueOf(user.getUserId()));
        eventCrf.setDateUpdated(new Date());
        eventCrf.setValidatorId(Integer.valueOf(0));
        eventCrf.setOldStatusId(Integer.valueOf(0));
        eventCrf.setSdvUpdateId(Integer.valueOf(0));
        this.eventCrfDao.saveOrUpdate((DomainObject)eventCrf);
        eventCrf = this.eventCrfDao.findByStudyEventIdStudySubjectIdCrfVersionId(studyEvent.getStudyEventId(), studySubject.getStudySubjectId(), crfVersion.getCrfVersionId());
        this.logger.debug("*********CREATED EVENT CRF");
        return eventCrf;
    }

    private StudyEvent updateStudyEvent(StudyEvent studyEvent, StudyEventDefinition studyEventDefinition, Study study, StudySubject studySubject, UserAccount user, boolean isAnonymous) {
        SubjectEventStatus newStatus = null;
        int crfCount = 0;
        int hiddenSiteCrfCount = 0;
        int completedCrfCount = 0;
        if (!isAnonymous) {
            if (studyEvent.getSubjectEventStatusId().intValue() == SubjectEventStatus.SCHEDULED.getCode().intValue()) {
                newStatus = SubjectEventStatus.DATA_ENTRY_STARTED;
            }
        } else {
            if (study.getStudy() != null) {
                hiddenSiteCrfCount = this.eventDefinitionCrfDao.findSiteHiddenByStudyEventDefStudy(Integer.valueOf(studyEventDefinition.getStudyEventDefinitionId()), Integer.valueOf(study.getStudyId())).size();
                crfCount = this.eventDefinitionCrfDao.findAvailableByStudyEventDefStudy(Integer.valueOf(studyEventDefinition.getStudyEventDefinitionId()), Integer.valueOf(study.getStudy().getStudyId())).size();
            } else {
                crfCount = this.eventDefinitionCrfDao.findAvailableByStudyEventDefStudy(Integer.valueOf(studyEventDefinition.getStudyEventDefinitionId()), Integer.valueOf(study.getStudyId())).size();
            }
            completedCrfCount = this.eventCrfDao.findByStudyEventStatus(Integer.valueOf(studyEvent.getStudyEventId()), Status.UNAVAILABLE.getCode()).size();
            if (crfCount - hiddenSiteCrfCount == completedCrfCount) {
                if (studyEvent.getSubjectEventStatusId().intValue() == SubjectEventStatus.SCHEDULED.getCode().intValue() || studyEvent.getSubjectEventStatusId().intValue() == SubjectEventStatus.DATA_ENTRY_STARTED.getCode().intValue()) {
                    newStatus = SubjectEventStatus.COMPLETED;
                }
            } else if (studyEvent.getSubjectEventStatusId().intValue() == SubjectEventStatus.SCHEDULED.getCode().intValue()) {
                newStatus = SubjectEventStatus.DATA_ENTRY_STARTED;
            }
        }
        if (newStatus != null) {
            studyEvent.setUpdateId(Integer.valueOf(user.getUserId()));
            studyEvent.setDateUpdated(new Date());
            studyEvent.setSubjectEventStatusId(newStatus.getCode());
            StudyEventChangeDetails changeDetails = new StudyEventChangeDetails(Boolean.valueOf(true), Boolean.valueOf(false));
            StudyEventContainer container = new StudyEventContainer(studyEvent, changeDetails);
            studyEvent = this.studyEventDao.saveOrUpdateTransactional(container);
            this.logger.debug("*********UPDATED STUDY EVENT ");
        }
        return studyEvent;
    }

    private EventCrf updateEventCrf(EventCrf eventCrf, Study study, StudySubject studySubject, UserAccount user, boolean isAnonymous) {
        eventCrf.setUpdateId(Integer.valueOf(user.getUserId()));
        eventCrf.setDateUpdated(new Date());
        if (isAnonymous) {
            eventCrf.setStatusId(Status.UNAVAILABLE.getCode());
        } else {
            eventCrf.setStatusId(Status.AVAILABLE.getCode());
        }
        eventCrf = (EventCrf)this.eventCrfDao.saveOrUpdate((DomainObject)eventCrf);
        this.logger.debug("*********UPDATED EVENT CRF");
        return eventCrf;
    }
}

