/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.openrosa.processor;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.akaza.openclinica.controller.openrosa.ItemItemDataContainer;
import org.akaza.openclinica.controller.openrosa.PformValidator;
import org.akaza.openclinica.controller.openrosa.SubmissionContainer;
import org.akaza.openclinica.controller.openrosa.processor.Processor;
import org.akaza.openclinica.dao.hibernate.CrfVersionDao;
import org.akaza.openclinica.dao.hibernate.DiscrepancyNoteDao;
import org.akaza.openclinica.dao.hibernate.DiscrepancyNoteTypeDao;
import org.akaza.openclinica.dao.hibernate.DnItemDataMapDao;
import org.akaza.openclinica.dao.hibernate.ItemDao;
import org.akaza.openclinica.dao.hibernate.ItemDataDao;
import org.akaza.openclinica.dao.hibernate.ItemFormMetadataDao;
import org.akaza.openclinica.dao.hibernate.ItemGroupDao;
import org.akaza.openclinica.dao.hibernate.ItemGroupMetadataDao;
import org.akaza.openclinica.dao.hibernate.ResolutionStatusDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.datamap.CrfVersion;
import org.akaza.openclinica.domain.datamap.DiscrepancyNote;
import org.akaza.openclinica.domain.datamap.DnItemDataMap;
import org.akaza.openclinica.domain.datamap.DnItemDataMapId;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.domain.datamap.Item;
import org.akaza.openclinica.domain.datamap.ItemData;
import org.akaza.openclinica.domain.datamap.ItemFormMetadata;
import org.akaza.openclinica.domain.datamap.ItemGroup;
import org.akaza.openclinica.domain.datamap.ItemGroupMetadata;
import org.akaza.openclinica.domain.datamap.ResolutionStatus;
import org.akaza.openclinica.domain.datamap.Study;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.domain.user.UserAccount;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class ItemProcessor
implements Processor,
Ordered {
    @Autowired
    ItemDataDao itemDataDao;
    @Autowired
    ItemDao itemDao;
    @Autowired
    ItemGroupDao itemGroupDao;
    @Autowired
    ItemGroupMetadataDao itemGroupMetadataDao;
    @Autowired
    ItemFormMetadataDao itemFormMetadataDao;
    @Autowired
    CrfVersionDao crfVersionDao;
    @Autowired
    DiscrepancyNoteDao discrepancyNoteDao;
    @Autowired
    ResolutionStatusDao resolutionStatusDao;
    @Autowired
    DiscrepancyNoteTypeDao discrepancyNoteTypeDao;
    @Autowired
    DnItemDataMapDao dnItemDataMapDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public int getOrder() {
        return 4;
    }

    public void process(SubmissionContainer container) throws Exception {
        this.logger.info("Executing Item Processor.");
        ArrayList listOfUploadFilePaths = container.getListOfUploadFilePaths();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(container.getRequestBody()));
        Document doc = db.parse(is);
        String groupNodeName = "";
        NodeList instanceNodeList = doc.getElementsByTagName("instance");
        for (int i = 0; i < instanceNodeList.getLength(); ++i) {
            Node instanceNode = instanceNodeList.item(i);
            if (!(instanceNode instanceof Element)) continue;
            NodeList crfNodeList = instanceNode.getChildNodes();
            for (int j = 0; j < crfNodeList.getLength(); ++j) {
                Node crfNode = crfNodeList.item(j);
                if (!(crfNode instanceof Element)) continue;
                CrfVersion crfVersion = container.getEventCrf().getCrfVersion();
                EventCrf eventCrf = container.getEventCrf();
                ArrayList<ItemData> itemDataList = new ArrayList<ItemData>();
                HashMap<Integer, Set> groupOrdinalMapping = new HashMap<Integer, Set>();
                NodeList groupNodeList = crfNode.getChildNodes();
                List items = this.itemDao.findAllByCrfVersionId(Integer.valueOf(crfVersion.getCrfVersionId()));
                List itemDatas = this.itemDataDao.findAllByEventCrf(Integer.valueOf(container.getEventCrf().getEventCrfId()));
                ArrayList itemGroups = this.itemGroupDao.findByCrfVersionId(Integer.valueOf(crfVersion.getCrfVersionId()));
                List itemGroupMetadatas = this.itemGroupMetadataDao.findAllByCrfVersion(crfVersion.getCrfVersionId());
                List itemFormMetadatas = this.itemFormMetadataDao.findAllByCrfVersion(crfVersion.getCrfVersionId());
                for (int k = 0; k < groupNodeList.getLength(); ++k) {
                    Node groupNode = groupNodeList.item(k);
                    if (!(groupNode instanceof Element) || groupNode.getNodeName().startsWith("SECTION_")) continue;
                    groupNodeName = groupNode.getNodeName();
                    ItemGroup itemGroup = this.lookupItemGroup(groupNodeName, crfVersion, (List)itemGroups);
                    if (itemGroup == null) {
                        this.logger.error("Failed to lookup item group: '" + groupNodeName + "'.  Continuing with submission.");
                        continue;
                    }
                    if (itemGroup != null && !groupOrdinalMapping.containsKey(itemGroup.getItemGroupId())) {
                        groupOrdinalMapping.put(itemGroup.getItemGroupId(), new TreeSet());
                    }
                    NodeList itemNodeList = groupNode.getChildNodes();
                    for (int m = 0; m < itemNodeList.getLength(); ++m) {
                        Node itemNode = itemNodeList.item(m);
                        if (!(itemNode instanceof Element) || itemNode.getNodeName().endsWith(".HEADER") || itemNode.getNodeName().endsWith(".SUBHEADER") || itemNode.getNodeName().equals("OC.REPEAT_ORDINAL") || itemNode.getNodeName().equals("OC.STUDY_SUBJECT_ID") || itemNode.getNodeName().equals("OC.STUDY_SUBJECT_ID_CONFIRM")) continue;
                        String itemName = itemNode.getNodeName().trim();
                        String itemValue = itemNode.getTextContent();
                        Item item = this.lookupItem(itemName, crfVersion, items);
                        if (item == null) {
                            this.logger.error("Failed to lookup item: '" + itemName + "'.  Continuing with submission.");
                            continue;
                        }
                        ItemGroupMetadata itemGroupMeta = this.lookupItemGroupMetadata(Integer.valueOf(item.getItemId()), Integer.valueOf(crfVersion.getCrfVersionId()), itemGroupMetadatas);
                        ItemFormMetadata itemFormMetadata = this.lookupItemFormMetadata(Integer.valueOf(item.getItemId()), Integer.valueOf(crfVersion.getCrfVersionId()), itemFormMetadatas);
                        Integer itemOrdinal = this.getItemOrdinal(groupNode, itemGroupMeta.isRepeatingGroup(), itemDataList, item);
                        Integer responseTypeId = itemFormMetadata.getResponseSet().getResponseType().getResponseTypeId();
                        if (responseTypeId == 3 || responseTypeId == 7) {
                            itemValue = itemValue.replaceAll(" ", ",");
                        }
                        if (responseTypeId == 4) {
                            for (HashMap uploadFilePath : listOfUploadFilePaths) {
                                if (!uploadFilePath.containsKey(itemValue) || itemValue == "") continue;
                                itemValue = (String)uploadFilePath.get(itemValue);
                                break;
                            }
                        }
                        Set ordinals = (Set)groupOrdinalMapping.get(itemGroup.getItemGroupId());
                        ordinals.add(itemOrdinal);
                        groupOrdinalMapping.put(itemGroup.getItemGroupId(), ordinals);
                        ItemData newItemData = this.createItemData(item, itemValue, itemOrdinal, eventCrf, container.getStudy(), container.getSubject(), container.getUser());
                        Errors itemErrors = this.validateItemData(newItemData, item, responseTypeId);
                        if (itemErrors.hasErrors()) {
                            container.getErrors().addAllErrors(itemErrors);
                            throw new Exception("Item validation error.  Rolling back submission changes.");
                        }
                        itemDataList.add(newItemData);
                        ItemData existingItemData = this.lookupItemData(Integer.valueOf(item.getItemId()), Integer.valueOf(eventCrf.getEventCrfId()), itemOrdinal, itemDatas);
                        if (existingItemData == null) {
                            if (newItemData.getOrdinal() < 0) {
                                newItemData.setOrdinal(Integer.valueOf(this.itemDataDao.getMaxGroupRepeat(Integer.valueOf(eventCrf.getEventCrfId()), Integer.valueOf(item.getItemId())) + 1));
                                ((Set)groupOrdinalMapping.get(itemGroup.getItemGroupId())).add(newItemData.getOrdinal());
                            }
                            this.itemDataDao.saveOrUpdate((DomainObject)newItemData);
                            newItemData.setStatus(Status.UNAVAILABLE);
                            this.itemDataDao.saveOrUpdate((DomainObject)newItemData);
                            continue;
                        }
                        if (existingItemData.getValue().equals(newItemData.getValue())) continue;
                        existingItemData.setValue(newItemData.getValue());
                        existingItemData.setUpdateId(Integer.valueOf(container.getUser().getUserId()));
                        existingItemData.setDateUpdated(new Date());
                        this.itemDataDao.saveOrUpdate((DomainObject)existingItemData);
                    }
                }
                this.removeDeletedRows(groupOrdinalMapping, eventCrf, crfVersion, container.getStudy(), container.getSubject(), container.getLocale(), container.getUser());
            }
        }
    }

    private ItemFormMetadata lookupItemFormMetadata(Integer itemId, Integer crfVersionId, List<ItemFormMetadata> itemFormMetadataList) {
        for (ItemFormMetadata itemFormMetadata : itemFormMetadataList) {
            if (itemFormMetadata.getItem().getItemId() != itemId.intValue() || itemFormMetadata.getCrfVersionId().intValue() != crfVersionId.intValue()) continue;
            return itemFormMetadata;
        }
        return null;
    }

    private ItemGroupMetadata lookupItemGroupMetadata(Integer itemId, Integer crfVersionId, List<ItemGroupMetadata> itemGroupMetadataList) {
        for (ItemGroupMetadata itemGroupMetadata : itemGroupMetadataList) {
            if (itemGroupMetadata.getItem().getItemId() != itemId.intValue() || itemGroupMetadata.getCrfVersion().getCrfVersionId() != crfVersionId.intValue()) continue;
            return itemGroupMetadata;
        }
        return null;
    }

    private ItemData lookupItemData(Integer itemId, Integer eventCrfId, Integer itemOrdinal, List<ItemData> itemDataList) {
        for (ItemData itemData : itemDataList) {
            if (itemData.getItem().getItemId() != itemId.intValue() || itemData.getEventCrf().getEventCrfId() != eventCrfId.intValue() || itemData.getOrdinal().intValue() != itemOrdinal.intValue()) continue;
            return itemData;
        }
        return null;
    }

    private Item lookupItem(String itemName, CrfVersion crfVersion, List<Item> itemList) {
        if (crfVersion.getXform() == null || crfVersion.getXform().equals("")) {
            return this.lookupItemByOid(itemName, itemList);
        }
        return this.lookupItemByName(itemName, itemList);
    }

    private Item lookupItemByOid(String oid, List<Item> itemList) {
        for (Item item : itemList) {
            if (!item.getOcOid().equals(oid)) continue;
            return item;
        }
        return null;
    }

    private Item lookupItemByName(String name, List<Item> itemList) {
        for (Item item : itemList) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    private ItemGroup lookupItemGroup(String groupNodeName, CrfVersion crfVersion, List<ItemGroup> itemGroupList) {
        if (crfVersion.getXform() == null || crfVersion.getXform().equals("")) {
            return this.lookupItemGroupByOId(groupNodeName, itemGroupList);
        }
        return this.lookupItemGroupByName(groupNodeName, itemGroupList);
    }

    private ItemGroup lookupItemGroupByOId(String oid, List<ItemGroup> itemGroupList) {
        for (ItemGroup group : itemGroupList) {
            if (!group.getOcOid().equals(oid)) continue;
            return group;
        }
        return null;
    }

    private ItemGroup lookupItemGroupByName(String groupName, List<ItemGroup> itemGroupList) {
        for (ItemGroup group : itemGroupList) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    private ItemData createItemData(Item item, String itemValue, Integer itemOrdinal, EventCrf eventCrf, Study study, StudySubject studySubject, UserAccount user) {
        ItemData itemData = new ItemData();
        itemData.setItem(item);
        itemData.setEventCrf(eventCrf);
        itemData.setValue(itemValue);
        itemData.setDateCreated(new Date());
        itemData.setStatus(Status.AVAILABLE);
        itemData.setOrdinal(itemOrdinal);
        itemData.setUserAccount(user);
        itemData.setDeleted(Boolean.valueOf(false));
        return itemData;
    }

    private Errors validateItemData(ItemData itemData, Item item, Integer responseTypeId) {
        ItemItemDataContainer container = new ItemItemDataContainer(item, itemData, responseTypeId);
        DataBinder dataBinder = new DataBinder(null);
        BindingResult errors = dataBinder.getBindingResult();
        PformValidator pformValidator = new PformValidator();
        pformValidator.validate((Object)container, (Errors)errors);
        return errors;
    }

    private Integer getItemOrdinal(Node groupNode, boolean isRepeating, ArrayList<ItemData> itemDataList, Item item) {
        if (!isRepeating) {
            return 1;
        }
        int ordinal = -1;
        NodeList items = groupNode.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node xmlItem = items.item(i);
            if (!(xmlItem instanceof Element) || !((Element)xmlItem).getTagName().equals("OC.REPEAT_ORDINAL") || ((Element)xmlItem).getTextContent().equals("")) continue;
            ordinal = Integer.valueOf(((Element)xmlItem).getTextContent());
        }
        for (ItemData itemdata : itemDataList) {
            if (itemdata.getItem().getItemId() != item.getItemId() || itemdata.getOrdinal() != ordinal) continue;
            ordinal = -1;
            break;
        }
        return ordinal;
    }

    private void removeDeletedRows(HashMap<Integer, Set<Integer>> groupOrdinalMapping, EventCrf eventCrf, CrfVersion crfVersion, Study study, StudySubject studySubject, Locale locale, UserAccount user) {
        for (Integer itemGroupId : groupOrdinalMapping.keySet()) {
            List itemDatas = this.itemDataDao.findByEventCrfGroup(Integer.valueOf(eventCrf.getEventCrfId()), itemGroupId);
            for (ItemData itemData : itemDatas) {
                if (groupOrdinalMapping.get(itemGroupId).contains(itemData.getOrdinal()) || itemData.isDeleted().booleanValue()) continue;
                itemData.setDeleted(Boolean.valueOf(true));
                itemData.setValue("");
                itemData.setOldStatus(itemData.getStatus());
                itemData.setUserAccount(user);
                itemData.setStatus(Status.AVAILABLE);
                itemData.setUpdateId(Integer.valueOf(user.getUserId()));
                itemData = (ItemData)this.itemDataDao.saveOrUpdate((DomainObject)itemData);
                this.closeItemDiscrepancyNotes(itemData, study, studySubject, locale, user);
            }
        }
    }

    private void closeItemDiscrepancyNotes(ItemData itemData, Study study, StudySubject studySubject, Locale locale, UserAccount user) {
        ResourceBundleProvider.updateLocale((Locale)locale);
        ResourceBundle resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        List parentDiscrepancyNoteList = this.discrepancyNoteDao.findParentNotesByItemData(Integer.valueOf(itemData.getItemDataId()));
        for (DiscrepancyNote parentDiscrepancyNote : parentDiscrepancyNoteList) {
            if (parentDiscrepancyNote.getResolutionStatus().getResolutionStatusId() == 4) continue;
            String description = resword.getString("dn_auto-closed_description");
            String detailedNotes = resword.getString("dn_auto_closed_item_detailed_notes");
            DiscrepancyNote dn = new DiscrepancyNote();
            ResolutionStatus resStatus = this.resolutionStatusDao.findByResolutionStatusId(Integer.valueOf(4));
            dn.setStudy(study);
            dn.setEntityType("itemData");
            dn.setDescription(description);
            dn.setDetailedNotes(detailedNotes);
            dn.setDiscrepancyNoteType(parentDiscrepancyNote.getDiscrepancyNoteType());
            dn.setResolutionStatus(resStatus);
            dn.setUserAccount(user);
            dn.setUserAccountByOwnerId(user);
            dn.setParentDiscrepancyNote(parentDiscrepancyNote);
            dn.setDateCreated(new Date());
            dn = (DiscrepancyNote)this.discrepancyNoteDao.saveOrUpdate((DomainObject)dn);
            DnItemDataMapId dnItemDataMapId = new DnItemDataMapId();
            dnItemDataMapId.setDiscrepancyNoteId(Integer.valueOf(dn.getDiscrepancyNoteId()));
            dnItemDataMapId.setItemDataId(Integer.valueOf(itemData.getItemDataId()));
            dnItemDataMapId.setStudySubjectId(Integer.valueOf(studySubject.getStudySubjectId()));
            dnItemDataMapId.setColumnName("value");
            DnItemDataMap mapping = new DnItemDataMap();
            mapping.setDnItemDataMapId(dnItemDataMapId);
            mapping.setItemData(itemData);
            mapping.setStudySubject(studySubject);
            mapping.setActivated(false);
            mapping.setDiscrepancyNote(dn);
            this.dnItemDataMapDao.saveOrUpdate((DomainObject)mapping);
            DiscrepancyNote itemParentNote = this.discrepancyNoteDao.findByDiscrepancyNoteId(dn.getParentDiscrepancyNote().getDiscrepancyNoteId());
            itemParentNote.setResolutionStatus(resStatus);
            itemParentNote.setUserAccount(user);
            this.discrepancyNoteDao.saveOrUpdate((DomainObject)itemParentNote);
        }
        List existingMappings = this.dnItemDataMapDao.findByItemData(Integer.valueOf(itemData.getItemDataId()));
        for (DnItemDataMap mapping : existingMappings) {
            mapping.setActivated(false);
            this.dnItemDataMapDao.saveOrUpdate((DomainObject)mapping);
        }
    }
}

