/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.openrosa.processor;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.akaza.openclinica.controller.openrosa.SubmissionContainer;
import org.akaza.openclinica.controller.openrosa.processor.Processor;
import org.akaza.openclinica.dao.hibernate.StudyDao;
import org.akaza.openclinica.dao.hibernate.StudySubjectDao;
import org.akaza.openclinica.dao.hibernate.SubjectDao;
import org.akaza.openclinica.dao.hibernate.UserAccountDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.datamap.Study;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.domain.datamap.Subject;
import org.akaza.openclinica.domain.user.UserAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class StudySubjectProcessor
implements Processor,
Ordered {
    @Autowired
    StudySubjectDao studySubjectDao;
    @Autowired
    UserAccountDao userAccountDao;
    @Autowired
    SubjectDao subjectDao;
    @Autowired
    StudyDao studyDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public void process(SubmissionContainer container) throws Exception {
        this.logger.info("Executing study subject processor.");
        String studySubjectOid = (String)container.getSubjectContext().get("studySubjectOID");
        String embeddedStudySubjectId = this.getEmbeddedStudySubjectOid(container);
        Date currentDate = new Date();
        UserAccount rootUser = this.userAccountDao.findByUserId(Integer.valueOf(1));
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
        if (studySubjectOid != null) {
            StudySubject studySubject = this.studySubjectDao.findByOcOID(studySubjectOid);
            container.setSubject(studySubject);
            if (studySubject.getStatus() != Status.AVAILABLE) {
                container.getErrors().reject("value.incorrect.STATUS");
                throw new Exception("StudySubject status is not Available.");
            }
        } else if (embeddedStudySubjectId != null) {
            Study study = (Study)this.studyDao.findByOcOID((String)container.getSubjectContext().get("studyOID"));
            StudySubject embeddedStudySubject = this.studySubjectDao.findByLabelAndStudyOrParentStudy(embeddedStudySubjectId, study);
            if (embeddedStudySubject != null && embeddedStudySubject.getStatus() == Status.AVAILABLE) {
                container.setSubject(embeddedStudySubject);
            } else {
                if (embeddedStudySubject != null && embeddedStudySubject.getStatus() != Status.AVAILABLE) {
                    container.getErrors().reject("value.incorrect.STATUS");
                    throw new Exception("Embedded StudySubject status is not Available");
                }
                if (this.subjectExistsInParentSiblingStudy(embeddedStudySubjectId, study)) {
                    String subjectLabel = "FIXME-" + dateFormatter.format(currentDate);
                    Subject subject = this.createSubject(currentDate, rootUser);
                    StudySubject studySubject = this.createStudySubject(subjectLabel, subject, study, rootUser, currentDate, embeddedStudySubjectId);
                    container.setSubject(studySubject);
                } else {
                    Subject subject = this.createSubject(currentDate, rootUser);
                    StudySubject studySubject = this.createStudySubject(embeddedStudySubjectId, subject, study, rootUser, currentDate, null);
                    container.setSubject(studySubject);
                }
            }
        } else {
            Study study = (Study)this.studyDao.findByOcOID((String)container.getSubjectContext().get("studyOID"));
            Integer studyId = study.getStudy() != null ? study.getStudy().getStudyId() : study.getStudyId();
            int nextLabel = this.studySubjectDao.findTheGreatestLabelByStudy(studyId) + 1;
            Subject subject = this.createSubject(currentDate, rootUser);
            StudySubject studySubject = this.createStudySubject(Integer.toString(nextLabel), subject, study, rootUser, currentDate, null);
            container.setSubject(studySubject);
        }
    }

    private boolean subjectExistsInParentSiblingStudy(String embeddedStudySubjectId, Study study) {
        boolean subjectExists = false;
        if (study.getStudy() != null && this.studySubjectDao.findByLabelAndStudy(embeddedStudySubjectId, study.getStudy()) != null) {
            subjectExists = true;
        }
        if (study.getStudy() != null) {
            ArrayList siblingSubjects = this.studySubjectDao.findByLabelAndParentStudy(embeddedStudySubjectId, study.getStudy());
            for (StudySubject subject : siblingSubjects) {
                if (subject.getStudy().getStudyId() == study.getStudyId()) continue;
                subjectExists = true;
            }
        }
        return subjectExists;
    }

    public int getOrder() {
        return 1;
    }

    private Subject createSubject(Date currentDate, UserAccount rootUser) {
        Subject subject = new Subject();
        subject.setUserAccount(rootUser);
        subject.setStatus(Status.AVAILABLE);
        subject.setDobCollected(Boolean.valueOf(false));
        subject.setDateCreated(currentDate);
        subject.setUniqueIdentifier("");
        subject = (Subject)this.subjectDao.saveOrUpdate((DomainObject)subject);
        return subject;
    }

    private StudySubject createStudySubject(String label, Subject subject, Study study, UserAccount rootUser, Date currentDate, String secondaryLabel) {
        StudySubject studySubject = new StudySubject();
        studySubject.setStudy(study);
        studySubject.setSubject(subject);
        studySubject.setStatus(Status.AVAILABLE);
        studySubject.setUserAccount(rootUser);
        studySubject.setEnrollmentDate(currentDate);
        studySubject.setDateCreated(currentDate);
        studySubject.setSecondaryLabel("");
        studySubject.setLabel(label);
        if (secondaryLabel != null && !secondaryLabel.equals("")) {
            studySubject.setSecondaryLabel(secondaryLabel);
        }
        String studySubjectOid = this.studySubjectDao.getValidOid(studySubject, new ArrayList());
        studySubject.setOcOid(studySubjectOid);
        studySubject = (StudySubject)this.studySubjectDao.saveOrUpdate((DomainObject)studySubject);
        return studySubject;
    }

    private String getEmbeddedStudySubjectOid(SubmissionContainer container) throws Exception {
        String studySubjectId = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(container.getRequestBody()));
        Document doc = db.parse(is);
        Node instanceNode = doc.getElementsByTagName("instance").item(0);
        NodeList crfNodeList = instanceNode.getChildNodes();
        for (int j = 0; j < crfNodeList.getLength(); ++j) {
            Node crfNode = crfNodeList.item(j);
            if (!(crfNode instanceof Element)) continue;
            NodeList groupNodeList = crfNode.getChildNodes();
            for (int k = 0; k < groupNodeList.getLength(); ++k) {
                Node groupNode = groupNodeList.item(k);
                if (!(groupNode instanceof Element) || groupNode.getNodeName().startsWith("SECTION_")) continue;
                NodeList itemNodeList = groupNode.getChildNodes();
                for (int m = 0; m < itemNodeList.getLength(); ++m) {
                    String nodeValue;
                    Node itemNode = itemNodeList.item(m);
                    if (!(itemNode instanceof Element) || !itemNode.getNodeName().equals("OC.STUDY_SUBJECT_ID") || (nodeValue = itemNode.getTextContent()) == null || nodeValue.equals("")) continue;
                    studySubjectId = nodeValue;
                }
            }
        }
        return studySubjectId;
    }
}

