/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.user;

import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.user.LdapUserService;
import org.akaza.openclinica.service.user.OpenClinicaLdapUserSearch;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LdapUserController {
    private static final String PAGE_LIST_LDAP_USERS = "listLdapUsers";
    private static final Logger logger = LoggerFactory.getLogger((String)LdapUserController.class.getName());
    @Autowired
    private LdapUserService ldapUserService;
    @Autowired
    private UserAccountDAO userAccountDao;
    @Autowired
    private OpenClinicaLdapUserSearch openClinicaLdapUserSearch;

    @RequestMapping(value={"/listLdapUsers"})
    public String listLdapUsers(HttpServletRequest req, @RequestParam(value="filter", required=false) String filter) {
        if (!StringUtils.isEmpty((String)filter)) {
            Collection existingAccounts = this.userAccountDao.findAll();
            HashSet<String> existingUsernames = new HashSet<String>(existingAccounts.size());
            for (UserAccountBean existingAccount : existingAccounts) {
                existingUsernames.add(existingAccount.getName());
            }
            req.setAttribute("memberList", (Object)this.ldapUserService.listNewUsers(filter, existingUsernames));
        }
        return PAGE_LIST_LDAP_USERS;
    }

    @RequestMapping(value={"/selectLdapUser"})
    public String selectLdapUser(HttpServletRequest req, @RequestParam(value="dn", required=false) String dn, @RequestParam(value="un", required=false) String un) {
        try {
            if (!StringUtils.isEmpty((String)dn)) {
                req.getSession().setAttribute("ldapUser", (Object)this.ldapUserService.loadUser(dn));
            } else if (!StringUtils.isEmpty((String)un)) {
                req.getSession().setAttribute("ldapUser", (Object)this.ldapUserService.getLdapUser(this.openClinicaLdapUserSearch.searchForUser(un)));
            }
        }
        catch (Exception ex) {
            logger.error("Error getting ldap user: " + ex.getMessage(), (Throwable)ex);
        }
        return "redirect:/CreateUserAccount";
    }
}

