/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.EntityAction;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.admin.DeleteStudyUserRoleServlet;
import org.akaza.openclinica.control.admin.DeleteUserServlet;
import org.akaza.openclinica.control.admin.EditStudyUserRoleServlet;
import org.akaza.openclinica.control.admin.EditUserAccountServlet;
import org.akaza.openclinica.control.admin.ViewUserAccountServlet;
import org.akaza.openclinica.view.Table;

public class UserAccountTable
extends Table {
    public UserAccountTable() {
        this.columns.add("Username");
        this.columns.add("First Name");
        this.columns.add("Last Name");
        this.columns.add("Status");
        this.columns.add("Actions");
    }

    public String getEntitiesNamePlural() {
        return "users";
    }

    public String showRow(EntityBean e) {
        String studyName;
        StudyUserRoleBean sur;
        int i;
        String onClick;
        String confirmQuestion;
        UserAccountBean u = (UserAccountBean)e;
        Status s = u.getStatus();
        String row = "<tr>\n";
        String colorOn = s.equals((Term)Status.AVAILABLE) ? "" : "<font color='gray'>";
        String colorOff = s.equals((Term)Status.AVAILABLE) ? "" : "</font>";
        row = row + "<td>" + colorOn + u.getName() + colorOff + "</td>\n";
        row = row + "<td>" + u.getFirstName() + "</td>\n";
        row = row + "<td>" + u.getLastName() + "</td>\n";
        row = row + "<td>" + s.getName() + "</td>\n";
        row = row + "<td>";
        if (!s.equals((Term)Status.DELETED)) {
            confirmQuestion = "Are you sure you want to delete " + u.getName() + "?";
            onClick = "onClick=\"return confirm('" + confirmQuestion + "');\"";
            row = row + "<a href='" + ViewUserAccountServlet.getLink((int)u.getId()) + "'>view</a>";
            row = row + " <a href='" + EditUserAccountServlet.getLink((int)u.getId()) + "'>edit</a>";
            row = row + " <a href='" + DeleteUserServlet.getLink((UserAccountBean)u, (EntityAction)EntityAction.DELETE) + "'" + onClick + ">delete</a>";
        } else {
            confirmQuestion = "Are you sure you want to restore " + u.getName() + "?";
            onClick = "onClick=\"return confirm('" + confirmQuestion + "');\"";
            row = row + " <a href='" + DeleteUserServlet.getLink((UserAccountBean)u, (EntityAction)EntityAction.RESTORE) + "'" + onClick + ">restore</a>";
        }
        row = row + "</td>\n";
        row = row + "</tr>\n";
        row = row + "<tr>\n";
        row = row + "<td>&nbsp;</td>\n";
        ArrayList userRoles = u.getRoles();
        row = row + "<td colspan='3'>";
        if (userRoles.size() <= 0) {
            row = row + "<i>No roles assigned</i>";
        }
        for (i = 0; i < userRoles.size(); ++i) {
            sur = (StudyUserRoleBean)userRoles.get(i);
            colorOn = sur.getStatus().equals((Term)Status.AVAILABLE) ? "" : "<font color='gray'>";
            colorOff = sur.getStatus().equals((Term)Status.AVAILABLE) ? "" : "</font>";
            studyName = this.getStudyName(sur);
            row = row + studyName + " - " + colorOn + sur.getRole().getDescription() + colorOff + "<br/>\n";
        }
        row = row + "</td>\n";
        row = row + "<td>";
        for (i = 0; i < userRoles.size(); ++i) {
            sur = (StudyUserRoleBean)userRoles.get(i);
            if (!sur.getStatus().equals((Term)Status.DELETED)) {
                studyName = this.getStudyName(sur);
                String confirmQuestion2 = "Are you sure you want to delete the " + sur.getRole().getDescription() + " role for " + u.getName() + " in " + studyName + "?";
                row = row + " <a href='" + EditStudyUserRoleServlet.getLink((StudyUserRoleBean)sur, (UserAccountBean)u) + "'>edit role</a>";
                row = row + " <a href='" + DeleteStudyUserRoleServlet.getLink((String)u.getName(), (int)sur.getStudyId(), (EntityAction)EntityAction.DELETE) + "' onClick='return confirm(\"" + confirmQuestion2 + "\");'>delete role</a>";
            } else {
                String confirmQuestion3 = "Are you sure you want to restore the " + sur.getRole().getDescription() + " role for " + u.getName() + " in Study " + sur.getStudyId() + "?";
                row = row + " <a href='" + DeleteStudyUserRoleServlet.getLink((String)u.getName(), (int)sur.getStudyId(), (EntityAction)EntityAction.RESTORE) + "' onClick=\"return confirm('" + confirmQuestion3 + "');\">restore role</a>";
            }
            row = row + "<br/>\n";
        }
        row = row + "</td>\n";
        row = row + "<tr>\n";
        row = row + "</tr>\n";
        return row;
    }

    private String getStudyName(StudyUserRoleBean sur) {
        String studyName = sur.getStudyName().equals("") ? "Study " + sur.getStudyId() : sur.getStudyName();
        return studyName;
    }
}

