/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.util.ArrayList;
import java.util.List;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.view.form.DataEntryInputGenerator;
import org.jdom.Content;
import org.jdom.Element;

public class CellFactory {
    private final DataEntryInputGenerator inputGenerator = new DataEntryInputGenerator();
    public static final String RIGHT = "right";
    public static final String LEFT = "left";

    public Element createCellContents(Element td, String responseName, DisplayItemBean displayBean, Integer tabIndex, boolean hasDiscrepancyMgt, boolean hasSavedData, boolean forPrinting) {
        Element href;
        if (responseName.equalsIgnoreCase("text")) {
            td = this.inputGenerator.createTextInputTag(td, Integer.valueOf(displayBean.getItem().getId()), tabIndex, displayBean.getMetadata().getDefaultValue(), displayBean.getItem().getItemDataTypeId() == 9, displayBean.getData().getValue(), hasSavedData);
        } else if (responseName.equalsIgnoreCase("textarea")) {
            td = this.inputGenerator.createTextareaTag(td, Integer.valueOf(displayBean.getItem().getId()), tabIndex, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), hasSavedData);
        } else if (responseName.equalsIgnoreCase("checkbox")) {
            td = this.inputGenerator.createCheckboxTag(td, Integer.valueOf(displayBean.getItem().getId()), (List)displayBean.getMetadata().getResponseSet().getOptions(), tabIndex, true, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), "horizontal".equalsIgnoreCase(displayBean.getMetadata().getResponseLayout()), hasSavedData);
        } else if (responseName.equalsIgnoreCase("radio")) {
            td = this.inputGenerator.createRadioButtonTag(td, Integer.valueOf(displayBean.getItem().getId()), (List)displayBean.getMetadata().getResponseSet().getOptions(), tabIndex, true, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), "horizontal".equalsIgnoreCase(displayBean.getMetadata().getResponseLayout()), hasSavedData);
        } else if (responseName.equalsIgnoreCase("single-select")) {
            td = this.inputGenerator.createSingleSelectTag(td, Integer.valueOf(displayBean.getItem().getId()), (List)displayBean.getMetadata().getResponseSet().getOptions(), tabIndex, displayBean.getMetadata().getDefaultValue(), displayBean.getData().getValue(), hasSavedData);
        } else if (responseName.equalsIgnoreCase("multi-select")) {
            td = this.inputGenerator.createMultiSelectTag(td, Integer.valueOf(displayBean.getItem().getId()), (List)displayBean.getMetadata().getResponseSet().getOptions(), tabIndex, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), hasSavedData);
        } else if (responseName.equalsIgnoreCase("calculation") || responseName.equalsIgnoreCase("group-calculation")) {
            td = this.inputGenerator.createCaculationTag(td, Integer.valueOf(displayBean.getItem().getId()), displayBean.getMetadata().getResponseSet(), displayBean.getItem().getItemDataTypeId() == 9, displayBean.getData().getValue(), hasSavedData);
        } else if (responseName.equalsIgnoreCase("file")) {
            td = this.inputGenerator.createFileTag(td, displayBean.getData().getValue(), forPrinting);
        } else if (responseName.equalsIgnoreCase("instant-calculation")) {
            td = this.inputGenerator.createInstantTag(td, Integer.valueOf(displayBean.getItem().getId()), tabIndex, displayBean.getData().getValue(), hasSavedData);
        }
        String rightSideTxt = displayBean.getMetadata().getRightItemText();
        if (rightSideTxt != null && !"".equalsIgnoreCase(rightSideTxt)) {
            this.addTextToCell(td, rightSideTxt, RIGHT);
        }
        if (displayBean.getMetadata().isRequired()) {
            td = this.inputGenerator.createRequiredAlert(td);
        }
        if (hasDiscrepancyMgt && (href = this.inputGenerator.createDiscrepancyNoteSymbol(Integer.valueOf(displayBean.getNumDiscrepancyNotes()), tabIndex, Integer.valueOf(displayBean.getData().getId()), Integer.valueOf(displayBean.getItem().getId()), forPrinting)) != null) {
            td.addContent((Content)href);
        }
        if (responseName.equalsIgnoreCase("text") || responseName.equalsIgnoreCase("textarea") || responseName.equalsIgnoreCase("single-select") || responseName.equalsIgnoreCase("multi-select") || responseName.equalsIgnoreCase("calculation")) {
            td = this.addUnits(td, displayBean);
        }
        if (responseName.equalsIgnoreCase("radio") || responseName.equalsIgnoreCase("checkbox")) {
            boolean grouped;
            String grLabel = displayBean.getMetadata().getGroupLabel();
            boolean bl = grouped = grLabel != null && !"".equalsIgnoreCase(grLabel) && !grLabel.equalsIgnoreCase("ungrouped");
            if (!grouped) {
                td = this.addUnits(td, displayBean);
            } else if (!displayBean.getMetadata().getResponseLayout().equalsIgnoreCase("Horizontal")) {
                td = this.addUnits(td, displayBean);
            }
        }
        return td;
    }

    public Element[] createCellContentsForChecks(String responseName, DisplayItemBean displayBean, Integer optionsLength, Integer tabIndex, boolean hasDBValues, boolean forPrinting) {
        Element[] tdElements = new Element[optionsLength.intValue()];
        ArrayList<ResponseOptionBean> list = new ArrayList<ResponseOptionBean>();
        int indx = 0;
        for (ResponseOptionBean reOptBean : displayBean.getMetadata().getResponseSet().getOptions()) {
            list.add(reOptBean);
            Element td = new Element("td");
            td = responseName.equalsIgnoreCase("checkbox") ? this.inputGenerator.createCheckboxTag(td, Integer.valueOf(displayBean.getItem().getId()), list, tabIndex, false, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), true, hasDBValues) : this.inputGenerator.createRadioButtonTag(td, Integer.valueOf(displayBean.getItem().getId()), list, tabIndex, false, displayBean.getData().getValue(), displayBean.getMetadata().getDefaultValue(), true, hasDBValues);
            tdElements[indx] = td;
            ++indx;
            list.clear();
        }
        return tdElements;
    }

    public Element addTextToCell(Element cell, String text, String textPositionRelativeToInput) {
        if (textPositionRelativeToInput.equalsIgnoreCase(LEFT)) {
            Element el = new Element("span");
            el.setAttribute("class", "aka_text_block_shared");
            el.addContent(text + " ");
            cell.addContent(0, (Content)el);
        } else if (textPositionRelativeToInput.equalsIgnoreCase(RIGHT)) {
            Element el = new Element("span");
            el.setAttribute("style", "aka_text_block_shared");
            el.addContent(" " + text);
            cell.addContent((Content)el);
        }
        return cell;
    }

    public Element addUnits(Element tdCell, DisplayItemBean displayBean) {
        if (displayBean == null) {
            return tdCell;
        }
        ItemBean itemBean = displayBean.getItem();
        if (itemBean == null) {
            return tdCell;
        }
        StringBuilder units = new StringBuilder(displayBean.getItem().getUnits());
        if (units.length() < 1) {
            return tdCell;
        }
        units = units.insert(0, "(");
        units = units.append(")");
        tdCell.addContent(" " + units.toString());
        return tdCell;
    }

    public Element addRightItemText(Element tdCell, DisplayItemBean displayBean) {
        if (displayBean == null) {
            return tdCell;
        }
        String rightItemText = displayBean.getMetadata().getRightItemText();
        if (rightItemText.length() < 1) {
            return tdCell;
        }
        tdCell.addContent(" " + rightItemText);
        return tdCell;
    }
}

