/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.akaza.openclinica.view.form.FormBuilder;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DefaultFormBuilder
implements FormBuilder {
    private List<Object> displayItems;

    public DefaultFormBuilder() {
        this.displayItems = new ArrayList();
    }

    public DefaultFormBuilder(List<Object> displayItems) {
        this.displayItems = displayItems;
    }

    public String createMarkup() {
        Element root = this.createTable();
        Document doc = new Document(root);
        Element thead = this.createThead();
        Element th = this.createThCell("Col 1");
        Element th2 = this.createThCell("Col 2");
        thead.addContent((Content)th);
        thead.addContent((Content)th2);
        root.addContent((Content)thead);
        Element tfoot = this.createTfoot();
        Element trFoot = this.createRow();
        Element tdFoot = this.createCell("Some content in the footer");
        tdFoot.setAttribute("colspan", "2");
        trFoot.addContent((Content)tdFoot);
        tfoot.addContent((Content)trFoot);
        root.addContent((Content)tfoot);
        Element tbody = this.createTbody();
        Element tr1 = this.createRow();
        Element td1 = this.createCell("Some content");
        td1.setAttribute("valign", "top");
        tr1.addContent((Content)td1);
        Element td2 = this.createCell("Some more content");
        td1.setAttribute("valign", "top");
        tr1.addContent((Content)td2);
        tbody.addContent((Content)tr1);
        root.addContent((Content)tbody);
        XMLOutputter outp = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setOmitDeclaration(true);
        outp.setFormat(format);
        StringWriter writer = new StringWriter();
        try {
            outp.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    public Element createTable() {
        Element root = new Element("table");
        root.setAttribute("border", "0");
        root.setAttribute("cellspacing", "0");
        root.setAttribute("cellpadding", "0");
        return root;
    }

    public Element createThead() {
        return new Element("thead");
    }

    public Element createThCell() {
        return new Element("th");
    }

    public Element createThCell(String content) {
        return new Element("th").addContent(content);
    }

    public Element createColGroup() {
        return new Element("colgroup");
    }

    public Element createTbody() {
        return new Element("tbody");
    }

    public Element createTfoot() {
        return new Element("tfoot");
    }

    public Element createRow() {
        return new Element("tr");
    }

    public Element createCell() {
        return new Element("td");
    }

    public Element createCell(String content) {
        return new Element("td").addContent(content);
    }

    public Element setClassNames(Element styledElement) {
        return styledElement;
    }

    public static void main(String[] args) {
        DefaultFormBuilder dfb = new DefaultFormBuilder();
        System.out.println(dfb.createMarkup());
    }
}

