/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplayItemWithGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.service.crfdata.DynamicsMetadataService;
import org.akaza.openclinica.view.form.CellFactory;
import org.akaza.openclinica.view.form.CellFactoryPrintDecorator;
import org.akaza.openclinica.view.form.CssRules;
import org.akaza.openclinica.view.form.DataEntryInputGenerator;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormBeanUtil {
    private static Logger logger = LoggerFactory.getLogger(FormBeanUtil.class);
    public static final String UNGROUPED = "Ungrouped";
    public static final String ADMIN_EDIT = "administrativeEditing";
    private static DynamicsMetadataService itemMetadataService;
    private ServletContext context;

    private static DynamicsMetadataService getItemMetadataService(ServletContext context) {
        itemMetadataService = itemMetadataService != null ? itemMetadataService : (DynamicsMetadataService)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("dynamicsMetadataService");
        return itemMetadataService;
    }

    public static ItemFormMetadataBean runDynamicsCheck(ItemFormMetadataBean metadataBean, EventCRFBean eventCrfBean, ItemDataBean itemDataBean, ServletContext context) {
        if (!metadataBean.isShowItem()) {
            boolean showItem = FormBeanUtil.getItemMetadataService((ServletContext)context).isShown(new Integer(metadataBean.getItemId()), eventCrfBean, itemDataBean);
            metadataBean.setShowItem(showItem);
        }
        return metadataBean;
    }

    public static List<DisplayItemBean> getDisplayBeansFromItems(List<ItemBean> itemBeans, DataSource dataSource, EventCRFBean eventCrfBean, int sectionId, List<String> nullValuesList, ServletContext context) {
        ArrayList<DisplayItemBean> disBeans = new ArrayList<DisplayItemBean>();
        if (itemBeans == null || itemBeans.isEmpty()) {
            return disBeans;
        }
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        ItemDataDAO itemDataDAO = new ItemDataDAO(dataSource);
        boolean hasNullValues = nullValuesList != null && !nullValuesList.isEmpty();
        String tmpVal = "";
        for (ItemBean iBean : itemBeans) {
            DisplayItemBean displayBean = new DisplayItemBean();
            ItemFormMetadataBean meta = metaDao.findByItemIdAndCRFVersionId(iBean.getId(), eventCrfBean.getCRFVersionId());
            if (meta.getSectionId() != sectionId) continue;
            displayBean.setItem(iBean);
            ItemDataBean itemDataBean = itemDataDAO.findByItemIdAndEventCRFId(iBean.getId(), eventCrfBean.getId());
            displayBean.setMetadata(FormBeanUtil.runDynamicsCheck((ItemFormMetadataBean)meta, (EventCRFBean)eventCrfBean, (ItemDataBean)itemDataBean, (ServletContext)context));
            displayBean.setData(itemDataBean);
            displayBean.setDbData(itemDataBean);
            String responseName = displayBean.getMetadata().getResponseSet().getResponseType().getName();
            ArrayList respOptions = displayBean.getMetadata().getResponseSet().getOptions();
            if (hasNullValues && respOptions != null && ("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName) || "single-select".equalsIgnoreCase(responseName) || "multi-select".equalsIgnoreCase(responseName))) {
                for (String val : nullValuesList) {
                    ResponseOptionBean respBean = new ResponseOptionBean();
                    tmpVal = (String)DataEntryInputGenerator.NULL_VALUES_LONGVERSION.get(val);
                    if (tmpVal != null && tmpVal.length() > 0) {
                        respBean.setText(tmpVal);
                    } else {
                        respBean.setText(val);
                    }
                    respBean.setValue(val);
                    respOptions.add(respBean);
                }
            }
            disBeans.add(displayBean);
        }
        Collections.sort(disBeans);
        return disBeans;
    }

    public static List<DisplayItemBean> getDisplayBeansFromItemsForPrint(List<ItemBean> itemBeans, DataSource dataSource, EventCRFBean eventCrfBean, int sectionId, List<String> nullValuesList, ServletContext context, int crfVersionId) {
        ArrayList<DisplayItemBean> disBeans = new ArrayList<DisplayItemBean>();
        if (itemBeans == null || itemBeans.isEmpty()) {
            return disBeans;
        }
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        ItemDataDAO itemDataDAO = new ItemDataDAO(dataSource);
        boolean hasNullValues = nullValuesList != null && !nullValuesList.isEmpty();
        String tmpVal = "";
        for (ItemBean iBean : itemBeans) {
            DisplayItemBean displayBean = new DisplayItemBean();
            ItemFormMetadataBean meta = metaDao.findByItemIdAndCRFVersionId(iBean.getId(), crfVersionId);
            if (meta.getSectionId() != sectionId) continue;
            displayBean.setItem(iBean);
            ItemDataBean itemDataBean = itemDataDAO.findByItemIdAndEventCRFId(iBean.getId(), eventCrfBean.getId());
            displayBean.setMetadata(FormBeanUtil.runDynamicsCheck((ItemFormMetadataBean)meta, (EventCRFBean)eventCrfBean, (ItemDataBean)itemDataBean, (ServletContext)context));
            displayBean.setData(itemDataBean);
            displayBean.setDbData(itemDataBean);
            String responseName = displayBean.getMetadata().getResponseSet().getResponseType().getName();
            ArrayList respOptions = displayBean.getMetadata().getResponseSet().getOptions();
            if (hasNullValues && respOptions != null && ("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName) || "single-select".equalsIgnoreCase(responseName) || "multi-select".equalsIgnoreCase(responseName))) {
                for (String val : nullValuesList) {
                    ResponseOptionBean respBean = new ResponseOptionBean();
                    tmpVal = (String)DataEntryInputGenerator.NULL_VALUES_LONGVERSION.get(val);
                    if (tmpVal != null && tmpVal.length() > 0) {
                        respBean.setText(tmpVal);
                    } else {
                        respBean.setText(val);
                    }
                    respBean.setValue(val);
                    respOptions.add(respBean);
                }
            }
            disBeans.add(displayBean);
        }
        Collections.sort(disBeans);
        return disBeans;
    }

    public static List<DisplayItemBean> getDisplayBeansFromItems(List<ItemBean> itemBeans, DataSource dataSource, EventCRFBean eventCrfBean, int sectionId, EventDefinitionCRFBean edcb, int test, ServletContext context) {
        ArrayList<DisplayItemBean> disBeans = new ArrayList<DisplayItemBean>();
        if (itemBeans == null || itemBeans.isEmpty()) {
            return disBeans;
        }
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        ItemDataDAO itemDataDao = new ItemDataDAO(dataSource);
        for (ItemBean iBean : itemBeans) {
            DisplayItemBean displayBean = new DisplayItemBean();
            displayBean.setEventDefinitionCRF(edcb);
            ItemFormMetadataBean meta = metaDao.findByItemIdAndCRFVersionId(iBean.getId(), eventCrfBean.getCRFVersionId());
            ItemDataBean itemDataBean = itemDataDao.findByItemIdAndEventCRFId(iBean.getId(), eventCrfBean.getId());
            if (meta.getSectionId() != sectionId) continue;
            displayBean.setItem(iBean);
            displayBean.setMetadata(FormBeanUtil.runDynamicsCheck((ItemFormMetadataBean)meta, (EventCRFBean)eventCrfBean, (ItemDataBean)itemDataBean, (ServletContext)context));
            displayBean.setData(itemDataBean);
            disBeans.add(displayBean);
        }
        Collections.sort(disBeans);
        return disBeans;
    }

    public void addBeansToResponseOptions(List<String> values, List<ResponseOptionBean> respOptions) {
        String tmpVal = "";
        for (String val : values) {
            ResponseOptionBean respBean = new ResponseOptionBean();
            tmpVal = (String)DataEntryInputGenerator.NULL_VALUES_LONGVERSION.get(val);
            if (tmpVal != null && tmpVal.length() > 0) {
                respBean.setText(tmpVal);
            } else {
                respBean.setText(val);
            }
            respBean.setValue(val);
            respOptions.add(respBean);
        }
    }

    public List<ResponseOptionBean> getNullValuesListAsOptionBeans(List<NullValue> nullValues) {
        ArrayList<ResponseOptionBean> responseOptionBeans = new ArrayList<ResponseOptionBean>();
        if (nullValues == null || nullValues.isEmpty()) {
            return responseOptionBeans;
        }
        for (NullValue nullVal : nullValues) {
            String name = nullVal.getName();
            ResponseOptionBean respBean = new ResponseOptionBean();
            respBean.setText(name);
            respBean.setValue(name);
            responseOptionBeans.add(respBean);
        }
        return responseOptionBeans;
    }

    public DisplayItemBean getDisplayBeanFromSingleItem(ItemFormMetadataBean itemFBean, int sectionId, DataSource dataSource, EventCRFBean eventCrfBean, List<String> nullValuesList, ServletContext context) {
        boolean hasNullValues;
        DisplayItemBean disBean = new DisplayItemBean();
        ItemBean itemBean = new ItemBean();
        ItemDAO itemDAO = new ItemDAO(dataSource);
        ItemDataDAO itemDataDao = new ItemDataDAO(dataSource);
        if (itemFBean == null) {
            return disBean;
        }
        itemBean = (ItemBean)itemDAO.findByPK(itemFBean.getItemId());
        if (itemBean == null) {
            itemBean = new ItemBean();
        }
        boolean bl = hasNullValues = nullValuesList != null && !nullValuesList.isEmpty();
        if (itemFBean.getSectionId() == sectionId) {
            ItemDataBean itemDataBean = itemDataDao.findByItemIdAndEventCRFId(itemBean.getId(), eventCrfBean.getId());
            disBean.setItem(itemBean);
            disBean.setMetadata(FormBeanUtil.runDynamicsCheck((ItemFormMetadataBean)itemFBean, (EventCRFBean)eventCrfBean, (ItemDataBean)itemDataBean, (ServletContext)context));
            disBean.setData(itemDataBean);
            logger.debug("3. just set: " + itemDataBean.getValue());
            String responseName = disBean.getMetadata().getResponseSet().getResponseType().getName();
            ArrayList respOptions = disBean.getMetadata().getResponseSet().getOptions();
            if (hasNullValues && respOptions != null && ("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName) || "single-select".equalsIgnoreCase(responseName) || "multi-select".equalsIgnoreCase(responseName))) {
                this.addBeansToResponseOptions(nullValuesList, (List)respOptions);
            }
        }
        return disBean;
    }

    public Element createXHTMLTableFromNonGroup(List<DisplayItemBean> items, Integer tabindex, boolean hasDiscrepancyMgt, boolean hasDBValues, boolean forPrinting) {
        Element table = new Element("table");
        String cssClasses = CssRules.getClassNamesForTag((String)table.getName());
        table.setAttribute("class", cssClasses);
        Element tbody = new Element("tbody");
        table.addContent((Content)tbody);
        int numberOfColumns = this.getNumberOfColumnsFromItems(items);
        TreeMap colMap = new TreeMap();
        TreeMap multiRowMap = new TreeMap();
        if (numberOfColumns > 1) {
            for (DisplayItemBean displayItem : items) {
                int column = displayItem.getMetadata().getColumnNumber();
                if (colMap.get(column) == null) {
                    colMap.put(column, new ArrayList());
                }
                ((List)colMap.get(column)).add(displayItem);
            }
            int numberOfRows = this.getNumberOfTableRows(colMap);
            for (int i = 1; i <= numberOfRows; ++i) {
                ArrayList rowsList = new ArrayList();
                for (int j = 1; j <= colMap.size(); ++j) {
                    List itemsList = (List)colMap.get(j);
                    if (itemsList == null || itemsList.size() < i) continue;
                    rowsList.add(itemsList.get(i - 1));
                }
                multiRowMap.put(i, rowsList);
            }
        }
        if (numberOfColumns == 1) {
            this.createSingleColumn(tbody, items, tabindex, hasDiscrepancyMgt, hasDBValues, forPrinting);
        } else {
            this.createMultipleCols(tbody, multiRowMap, tabindex, hasDiscrepancyMgt, numberOfColumns, hasDBValues, forPrinting);
        }
        return table;
    }

    private int getNumberOfTableRows(Map<Integer, List<DisplayItemBean>> columnsMap) {
        int highestRowNumber = 0;
        for (Map.Entry<Integer, List<DisplayItemBean>> me : columnsMap.entrySet()) {
            List<DisplayItemBean> beanList = me.getValue();
            int temp = beanList.size();
            highestRowNumber = temp > highestRowNumber ? temp : highestRowNumber;
        }
        return 1;
    }

    public int getNumberOfColumnsFromItems(List<DisplayItemBean> displayItems) {
        if (displayItems == null) {
            return 0;
        }
        int highestColumnNum = 1;
        for (DisplayItemBean displayItem : displayItems) {
            int temp = displayItem.getMetadata().getColumnNumber();
            highestColumnNum = highestColumnNum < temp ? temp : highestColumnNum;
        }
        return highestColumnNum;
    }

    private void createSingleColumn(Element tbody, List<DisplayItemBean> items, Integer tabindex, boolean hasDiscrepancyMgt, boolean hasDBValues, boolean forPrinting) {
        CellFactory cellFactory = new CellFactory();
        CellFactoryPrintDecorator cellFactoryPrintDecorator = new CellFactoryPrintDecorator();
        for (DisplayItemBean disBean : items) {
            String tmpName = disBean.getMetadata().getHeader();
            if (tmpName != null && tmpName.length() > 0) {
                Element tr = this.createHeaderSubheaderCell(disBean, true);
                tbody.addContent((Content)tr);
            }
            if ((tmpName = disBean.getMetadata().getSubHeader()) != null && tmpName.length() > 0) {
                Element tr2 = this.createHeaderSubheaderCell(disBean, false);
                tbody.addContent((Content)tr2);
            }
            Element trRow = new Element("tr");
            String leftSideTxt = "";
            String questNumber = "";
            tbody.addContent((Content)trRow);
            String responseName = disBean.getMetadata().getResponseSet().getResponseType().getName();
            Element tdCell = new Element("td");
            String classNames = CssRules.getClassNamesForTag((String)"td");
            tdCell.setAttribute("class", classNames);
            tdCell.setAttribute("style", "vertical-align:top");
            boolean horizontalLayout = "horizontal".equalsIgnoreCase(disBean.getMetadata().getResponseLayout());
            if (("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName)) && !horizontalLayout) {
                tabindex = tabindex + 1;
                cellFactoryPrintDecorator.createCellContentsForVerticalLayout(tdCell, responseName, disBean, tabindex, hasDiscrepancyMgt, hasDBValues, forPrinting);
            } else {
                tabindex = tabindex + 1;
                cellFactory.createCellContents(tdCell, responseName, disBean, tabindex, hasDiscrepancyMgt, hasDBValues, forPrinting);
            }
            questNumber = disBean.getMetadata().getQuestionNumberLabel();
            boolean hasQuestion = questNumber.length() > 0;
            leftSideTxt = disBean.getMetadata().getLeftItemText();
            cellFactory.addTextToCell(tdCell, leftSideTxt, "left");
            if (hasQuestion) {
                this.addQuestionNumbers(tdCell, questNumber);
            }
            trRow.addContent((Content)tdCell);
        }
    }

    private Element addQuestionNumbers(Element tdCell, String questNumber) {
        Element existingSpan = tdCell.getChild("span");
        Element newSpan = new Element("span");
        newSpan.setAttribute("style", "margin-right:1em");
        newSpan.addContent(questNumber);
        existingSpan.addContent(0, (Content)newSpan);
        return tdCell;
    }

    private Element createHeaderSubheaderCell(DisplayItemBean disBean, boolean isHeader) {
        CellFactory cellFactory = new CellFactory();
        Element tr = new Element("tr");
        Element td = new Element("td");
        String cssClassNames = CssRules.getClassNamesForTag((String)"tr header");
        tr.setAttribute("class", cssClassNames);
        cssClassNames = CssRules.getClassNamesForTag((String)"td header");
        td.setAttribute("class", cssClassNames);
        td = isHeader ? cellFactory.addTextToCell(td, disBean.getMetadata().getHeader(), "left") : cellFactory.addTextToCell(td, disBean.getMetadata().getSubHeader(), "left");
        tr.addContent((Content)td);
        return tr;
    }

    private Element createHeaderCellMultiColumn(DisplayItemBean disBean, boolean isHeader, Element row, int numberOfColumns) {
        CellFactory cellFactory = new CellFactory();
        if (row == null) {
            row = new Element("tr");
        }
        Element td = new Element("td");
        String cssClassNames = "";
        if (row.getAttribute("class") == null) {
            cssClassNames = CssRules.getClassNamesForTag((String)"tr header");
            row.setAttribute("class", cssClassNames);
        }
        cssClassNames = CssRules.getClassNamesForTag((String)"td header");
        td.setAttribute("class", cssClassNames);
        td = isHeader ? cellFactory.addTextToCell(td, disBean.getMetadata().getHeader(), "left") : cellFactory.addTextToCell(td, disBean.getMetadata().getSubHeader(), "left");
        row.addContent((Content)td);
        return row;
    }

    private void createMultipleCols(Element tbody, Map<Integer, List<DisplayItemBean>> displayItemRows, Integer tabindex, boolean hasDiscrepancyMgt, int numberOfColumns, boolean hasDBValues, boolean forPrinting) {
        CellFactory cellFactory = new CellFactory();
        CellFactoryPrintDecorator cellFactoryPrintDecorator = new CellFactoryPrintDecorator();
        Element formFieldRow = new Element("tr");
        for (Map.Entry<Integer, List<DisplayItemBean>> me : displayItemRows.entrySet()) {
            int cellCountDif;
            List<DisplayItemBean> itemsList = me.getValue();
            int numberOfBeansInRow = itemsList.size();
            Element headerRow = new Element("tr");
            Element subHeaderRow = new Element("tr");
            String leftSideTxt = "";
            for (DisplayItemBean disBean : me.getValue()) {
                if (disBean.getMetadata().getHeader().length() > 0) {
                    headerRow = this.createHeaderCellMultiColumn(disBean, true, headerRow, numberOfBeansInRow);
                }
                if (disBean.getMetadata().getSubHeader().length() > 0) {
                    subHeaderRow = this.createHeaderCellMultiColumn(disBean, false, subHeaderRow, numberOfBeansInRow);
                }
                String responseName = disBean.getMetadata().getResponseSet().getResponseType().getName();
                Element tdCell = new Element("td");
                String classNames = CssRules.getClassNamesForTag((String)"td");
                tdCell.setAttribute("class", classNames);
                String questNumber = "";
                questNumber = disBean.getMetadata().getQuestionNumberLabel();
                boolean hasQuestion = questNumber.length() > 0;
                leftSideTxt = disBean.getMetadata().getLeftItemText();
                tdCell.setAttribute("style", "vertical-align:top");
                boolean horizontalLayout = "horizontal".equalsIgnoreCase(disBean.getMetadata().getResponseLayout());
                if (("checkbox".equalsIgnoreCase(responseName) || "radio".equalsIgnoreCase(responseName)) && !horizontalLayout) {
                    tabindex = tabindex + 1;
                    cellFactoryPrintDecorator.createCellContentsForVerticalLayout(tdCell, responseName, disBean, tabindex, hasDiscrepancyMgt, hasDBValues, forPrinting);
                } else {
                    tabindex = tabindex + 1;
                    cellFactory.createCellContents(tdCell, responseName, disBean, tabindex, hasDiscrepancyMgt, hasDBValues, forPrinting);
                }
                cellFactory.addTextToCell(tdCell, leftSideTxt, "left");
                if (hasQuestion) {
                    this.addQuestionNumbers(tdCell, questNumber);
                }
                formFieldRow.addContent((Content)tdCell);
            }
            int childrenCount = headerRow.getChildren("td").size();
            if (childrenCount > 0) {
                int cellCountDif2 = numberOfBeansInRow - childrenCount;
                if (cellCountDif2 > 0) {
                    headerRow = this.addEmptyTDcells(headerRow, cellCountDif2);
                }
                tbody.addContent((Content)headerRow);
            }
            if ((childrenCount = subHeaderRow.getChildren("td").size()) > 0) {
                int cellCountDif3 = numberOfBeansInRow - childrenCount;
                if (cellCountDif3 > 0) {
                    subHeaderRow = this.addEmptyTDcells(subHeaderRow, cellCountDif3);
                }
                tbody.addContent((Content)subHeaderRow);
            }
            if ((cellCountDif = numberOfColumns - numberOfBeansInRow) <= 0) continue;
            formFieldRow = this.addEmptyTDcells(formFieldRow, cellCountDif);
        }
        tbody.addContent((Content)formFieldRow);
    }

    private Element addEmptyTDcells(Element row, int numberOfCellsToAdd) {
        for (int i = 1; i <= numberOfCellsToAdd; ++i) {
            Element td = new Element("td");
            row.addContent((Content)td);
        }
        return row;
    }

    public DisplayItemGroupBean createDisplayFormGroup(List<DisplayItemBean> displayItems, ItemGroupBean itemGroup) {
        DisplayItemGroupBean fgBean = new DisplayItemGroupBean();
        fgBean.setItems(displayItems);
        fgBean.setItemGroupBean(itemGroup);
        fgBean.setGroupMetaBean(itemGroup.getMeta());
        return fgBean;
    }

    public DisplaySectionBean createDisplaySectionBWithFormGroups(int sectionId, int crfVersionId, DataSource dataSource, int eventCRFDefId, EventCRFBean eventCrfBean, ServletContext context) {
        DisplaySectionBean displaySectionBean = new DisplaySectionBean();
        ItemGroupDAO formGroupDAO = new ItemGroupDAO(dataSource);
        ItemGroupMetadataDAO igMetaDAO = new ItemGroupMetadataDAO(dataSource);
        ItemDAO itemDao = new ItemDAO(dataSource);
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        SectionDAO sectionDao = new SectionDAO(dataSource);
        SectionBean secBean = (SectionBean)sectionDao.findByPK(sectionId);
        displaySectionBean.setSection(secBean);
        List itemGroupBeans = formGroupDAO.findLegitGroupAllBySectionId(sectionId);
        ArrayList allMetas = new ArrayList();
        try {
            allMetas = metaDao.findAllBySectionId(sectionId);
        }
        catch (OpenClinicaException oce) {
            logger.info("oce.getOpenClinicaMessage() = " + oce.getOpenClinicaMessage());
        }
        Collections.sort(allMetas);
        List nonGroupBeans = null;
        List nullValuesList = new ArrayList();
        boolean itemsHaveChecksRadios = this.itemsIncludeChecksRadiosSelects((List)allMetas);
        if (itemsHaveChecksRadios && eventCRFDefId > 0) {
            nullValuesList = this.getNullValuesByEventCRFDefId(eventCRFDefId, dataSource);
        }
        ArrayList<DisplayItemGroupBean> displayFormBeans = new ArrayList<DisplayItemGroupBean>();
        for (Object itemGroup : itemGroupBeans) {
            List itBeans = itemDao.findAllItemsByGroupId(itemGroup.getId(), crfVersionId);
            logger.debug("just ran find all by group id " + itemGroup.getId() + " found " + itBeans.size() + " item beans");
            List metadata = igMetaDAO.findMetaByGroupAndSection(itemGroup.getId(), crfVersionId, sectionId);
            if (!metadata.isEmpty()) {
                ItemGroupMetadataBean meta = (ItemGroupMetadataBean)metadata.get(0);
                itemGroup.setMeta(meta);
            }
            List displayItems = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)dataSource, (EventCRFBean)eventCrfBean, (int)sectionId, nullValuesList, (ServletContext)context);
            DisplayItemGroupBean displayItemGBean = this.createDisplayFormGroup(displayItems, (ItemGroupBean)itemGroup);
            displayFormBeans.add(displayItemGBean);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        int digOrdinal = 0;
        for (DisplayItemGroupBean digBean : displayFormBeans) {
            digBean.setOrdinal(++digOrdinal);
        }
        int tempCount = 0;
        for (DisplayItemGroupBean groupBean : displayFormBeans) {
            tempCount += groupBean.getItems().size();
        }
        if (tempCount < allMetas.size()) {
            nonGroupBeans = this.createGroupBeansForNongroupedItems((List)allMetas, displayFormBeans, sectionId, dataSource, nullValuesList, eventCrfBean, context);
        }
        if (nonGroupBeans != null) {
            displayFormBeans.addAll(nonGroupBeans);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        displaySectionBean.setDisplayFormGroups(displayFormBeans);
        return displaySectionBean;
    }

    public DisplaySectionBean createDisplaySectionBWithFormGroupsForPrint(int sectionId, int crfVersionId, DataSource dataSource, int eventCRFDefId, EventCRFBean eventCrfBean, ServletContext context) {
        DisplaySectionBean displaySectionBean = new DisplaySectionBean();
        ItemGroupDAO formGroupDAO = new ItemGroupDAO(dataSource);
        ItemGroupMetadataDAO igMetaDAO = new ItemGroupMetadataDAO(dataSource);
        ItemDAO itemDao = new ItemDAO(dataSource);
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        SectionDAO sectionDao = new SectionDAO(dataSource);
        SectionBean secBean = (SectionBean)sectionDao.findByPK(sectionId);
        displaySectionBean.setSection(secBean);
        List itemGroupBeans = formGroupDAO.findLegitGroupAllBySectionId(sectionId);
        ArrayList allMetas = new ArrayList();
        try {
            allMetas = metaDao.findAllBySectionId(sectionId);
        }
        catch (OpenClinicaException oce) {
            logger.info("oce.getOpenClinicaMessage() = " + oce.getOpenClinicaMessage());
        }
        Collections.sort(allMetas);
        List nonGroupBeans = null;
        List nullValuesList = new ArrayList();
        boolean itemsHaveChecksRadios = this.itemsIncludeChecksRadiosSelects((List)allMetas);
        if (itemsHaveChecksRadios && eventCRFDefId > 0) {
            nullValuesList = this.getNullValuesByEventCRFDefId(eventCRFDefId, dataSource);
        }
        ArrayList<DisplayItemGroupBean> displayFormBeans = new ArrayList<DisplayItemGroupBean>();
        for (Object itemGroup : itemGroupBeans) {
            List itBeans = itemDao.findAllItemsByGroupIdForPrint(itemGroup.getId(), crfVersionId, sectionId);
            logger.debug("just ran find all by group id " + itemGroup.getId() + " found " + itBeans.size() + " item beans");
            List metadata = igMetaDAO.findMetaByGroupAndSectionForPrint(itemGroup.getId(), crfVersionId, sectionId);
            if (!metadata.isEmpty()) {
                ItemGroupMetadataBean meta = (ItemGroupMetadataBean)metadata.get(0);
                itemGroup.setMeta(meta);
            }
            List displayItems = FormBeanUtil.getDisplayBeansFromItemsForPrint((List)itBeans, (DataSource)dataSource, (EventCRFBean)eventCrfBean, (int)sectionId, nullValuesList, (ServletContext)context, (int)crfVersionId);
            DisplayItemGroupBean displayItemGBean = this.createDisplayFormGroup(displayItems, (ItemGroupBean)itemGroup);
            displayFormBeans.add(displayItemGBean);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        int digOrdinal = 0;
        for (DisplayItemGroupBean digBean : displayFormBeans) {
            digBean.setOrdinal(++digOrdinal);
        }
        int tempCount = 0;
        for (DisplayItemGroupBean groupBean : displayFormBeans) {
            tempCount += groupBean.getItems().size();
        }
        if (tempCount < allMetas.size()) {
            nonGroupBeans = this.createGroupBeansForNongroupedItems((List)allMetas, displayFormBeans, sectionId, dataSource, nullValuesList, eventCrfBean, context);
        }
        if (nonGroupBeans != null) {
            displayFormBeans.addAll(nonGroupBeans);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        displaySectionBean.setDisplayFormGroups(displayFormBeans);
        return displaySectionBean;
    }

    private List<DisplayItemGroupBean> createGroupBeansForNongroupedItems(List<ItemFormMetadataBean> allItems, List<DisplayItemGroupBean> displayFormBeans, int sectionId, DataSource dataSource, List<String> nullValuesList, EventCRFBean eventCrfBean, ServletContext context) {
        ArrayList<DisplayItemGroupBean> groupBeans = new ArrayList<DisplayItemGroupBean>();
        TreeMap groupMapping = new TreeMap();
        int counter = 0;
        for (ItemFormMetadataBean imetaBean : allItems) {
            HashMap<ItemFormMetadataBean, Integer> innerMap = new HashMap<ItemFormMetadataBean, Integer>();
            if (this.isGrouped(imetaBean, displayFormBeans)) {
                int tmpOrdinal = this.getGroupOrdinal(imetaBean, displayFormBeans);
                innerMap.put(imetaBean, tmpOrdinal);
            } else {
                innerMap.put(imetaBean, 0);
            }
            groupMapping.put(++counter, innerMap);
        }
        ItemGroupBean itemGroup = new ItemGroupBean();
        ItemGroupMetadataBean metaBean = new ItemGroupMetadataBean();
        metaBean.setName("Ungrouped");
        int ordinalTracker = 0;
        DisplayItemGroupBean nongroupedBean = new DisplayItemGroupBean();
        boolean isOrphaned = false;
        for (Map.Entry entry : groupMapping.entrySet()) {
            ItemFormMetadataBean tempItemMeta;
            Map beanMap = (Map)entry.getValue();
            int tempOrdinal = (Integer)beanMap.get(tempItemMeta = (ItemFormMetadataBean)beanMap.keySet().iterator().next());
            if (tempOrdinal == 0) {
                if (ordinalTracker == 0 || !isOrphaned) {
                    nongroupedBean = new DisplayItemGroupBean();
                    itemGroup = new ItemGroupBean();
                    itemGroup.setName("Ungrouped");
                    nongroupedBean.setItemGroupBean(itemGroup);
                    isOrphaned = true;
                    nongroupedBean.setOrdinal(++ordinalTracker);
                }
                nongroupedBean.getItems().add(this.getDisplayBeanFromSingleItem(tempItemMeta, sectionId, dataSource, eventCrfBean, nullValuesList, context));
                continue;
            }
            if (isOrphaned) {
                groupBeans.add(nongroupedBean);
                this.incrementOrdinal(tempItemMeta, displayFormBeans, ++ordinalTracker);
            } else {
                ordinalTracker = this.getGroupOrdinal(tempItemMeta, displayFormBeans);
            }
            isOrphaned = false;
        }
        if (isOrphaned) {
            groupBeans.add(nongroupedBean);
        }
        return groupBeans;
    }

    private void incrementOrdinal(ItemFormMetadataBean itemFormBean, List<DisplayItemGroupBean> displayFormBeans, int ordinalTracker) {
        block0: for (DisplayItemGroupBean digBean : displayFormBeans) {
            for (DisplayItemBean diBean : digBean.getItems()) {
                if (itemFormBean.getItemId() != diBean.getItem().getId()) continue;
                digBean.setOrdinal(ordinalTracker);
                break block0;
            }
        }
    }

    private boolean isGrouped(ItemFormMetadataBean itemFormBean, List<DisplayItemGroupBean> displayFormBeans) {
        boolean grouped = false;
        block0: for (DisplayItemGroupBean digBean : displayFormBeans) {
            for (DisplayItemBean diBean : digBean.getItems()) {
                if (itemFormBean.getItemId() != diBean.getItem().getId()) continue;
                grouped = true;
                break block0;
            }
        }
        return grouped;
    }

    private int getGroupOrdinal(ItemFormMetadataBean itemFBean, List<DisplayItemGroupBean> displayFormBeans) {
        int ordinal = 0;
        block0: for (DisplayItemGroupBean digBean : displayFormBeans) {
            for (DisplayItemBean diBean : digBean.getItems()) {
                if (itemFBean.getItemId() != diBean.getItem().getId()) continue;
                ordinal = digBean.getOrdinal();
                break block0;
            }
        }
        return ordinal;
    }

    public DisplaySectionBean createDisplaySectionBeanWithItemGroups(int sectionId, EventCRFBean eventCrfBean, SectionBean sectionBean, SessionManager sm, ServletContext context) {
        DisplaySectionBean dBean = new DisplaySectionBean();
        ItemGroupDAO formGroupDAO = new ItemGroupDAO(sm.getDataSource());
        ItemGroupMetadataDAO igMetaDAO = new ItemGroupMetadataDAO(sm.getDataSource());
        ItemDAO itemDao = new ItemDAO(sm.getDataSource());
        ArrayList allItems = itemDao.findAllParentsBySectionId(sectionId);
        List arrList = formGroupDAO.findLegitGroupBySectionId(sectionId);
        if (arrList.isEmpty()) {
            return dBean;
        }
        ArrayList<DisplayItemGroupBean> displayFormBeans = new ArrayList<DisplayItemGroupBean>();
        for (ItemGroupBean itemGroup : arrList) {
            List itBeans = itemDao.findAllItemsByGroupId(itemGroup.getId(), eventCrfBean.getCRFVersionId());
            List metadata = igMetaDAO.findMetaByGroupAndSection(itemGroup.getId(), eventCrfBean.getCRFVersionId(), sectionId);
            if (!metadata.isEmpty()) {
                ItemGroupMetadataBean meta = (ItemGroupMetadataBean)metadata.get(0);
                itemGroup.setMeta(meta);
            }
            List displayItems = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)sm.getDataSource(), (EventCRFBean)eventCrfBean, (int)sectionBean.getId(), null, (ServletContext)context);
            DisplayItemGroupBean displayFormGBean = this.createDisplayFormGroup(displayItems, itemGroup);
            displayFormBeans.add(displayFormGBean);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        dBean.setDisplayFormGroups(displayFormBeans);
        return dBean;
    }

    public DisplaySectionBean createDisplaySectionWithItemGroups(StudyBean study, int sectionId, EventCRFBean eventCrfBean, int studyEventId, SessionManager sm, int eventDefinitionCRFId, ServletContext context) {
        DisplaySectionBean dBean = new DisplaySectionBean();
        ItemGroupDAO formGroupDAO = new ItemGroupDAO(sm.getDataSource());
        ItemGroupMetadataDAO igMetaDAO = new ItemGroupMetadataDAO(sm.getDataSource());
        ItemDAO itemDao = new ItemDAO(sm.getDataSource());
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(sm.getDataSource());
        List arrList = formGroupDAO.findLegitGroupBySectionId(sectionId);
        ArrayList allMetas = new ArrayList();
        try {
            allMetas = metaDao.findAllBySectionId(sectionId);
        }
        catch (OpenClinicaException oce) {
            logger.info("oce.getOpenClinicaMessage() = " + oce.getOpenClinicaMessage());
        }
        if (arrList.isEmpty()) {
            return dBean;
        }
        List nullValuesList = new ArrayList();
        boolean itemsHaveChecksRadios = this.itemsIncludeChecksRadiosSelects((List)allMetas);
        if (eventDefinitionCRFId <= 0) {
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(sm.getDataSource());
            EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(study, studyEventId, eventCrfBean.getCRFVersionId());
            eventDefinitionCRFId = edcBean.getId();
        }
        if (itemsHaveChecksRadios && eventDefinitionCRFId > 0) {
            nullValuesList = this.getNullValuesByEventCRFDefId(eventDefinitionCRFId, sm.getDataSource());
        }
        ArrayList<DisplayItemGroupBean> displayFormBeans = new ArrayList<DisplayItemGroupBean>();
        for (ItemGroupBean itemGroup : arrList) {
            List itBeans = itemDao.findAllItemsByGroupId(itemGroup.getId(), eventCrfBean.getCRFVersionId());
            List metadata = igMetaDAO.findMetaByGroupAndSection(itemGroup.getId(), eventCrfBean.getCRFVersionId(), sectionId);
            if (!metadata.isEmpty()) {
                ItemGroupMetadataBean meta = (ItemGroupMetadataBean)metadata.get(0);
                itemGroup.setMeta(meta);
            }
            List displayItems = FormBeanUtil.getDisplayBeansFromItems((List)itBeans, (DataSource)sm.getDataSource(), (EventCRFBean)eventCrfBean, (int)sectionId, nullValuesList, (ServletContext)context);
            DisplayItemGroupBean displayItemGBean = this.createDisplayFormGroup(displayItems, itemGroup);
            displayFormBeans.add(displayItemGBean);
        }
        Collections.sort(displayFormBeans, new /* Unavailable Anonymous Inner Class!! */);
        int digOrdinal = 0;
        for (DisplayItemGroupBean digBean : displayFormBeans) {
            digBean.setOrdinal(++digOrdinal);
        }
        dBean.setDisplayFormGroups(displayFormBeans);
        return dBean;
    }

    public boolean sectionHasUngroupedItems(DataSource dataSource, int sectionId, List<DisplayItemGroupBean> displayFormBeans) {
        ItemFormMetadataDAO metaDao = new ItemFormMetadataDAO(dataSource);
        ArrayList allMetas = new ArrayList();
        try {
            allMetas = metaDao.findAllBySectionId(sectionId);
        }
        catch (OpenClinicaException oce) {
            logger.info("oce.getOpenClinicaMessage() = " + oce.getOpenClinicaMessage());
        }
        int size = allMetas.size();
        int tempCount = 0;
        String grpName = "";
        for (DisplayItemGroupBean groupBean : displayFormBeans) {
            grpName = groupBean.getItemGroupBean().getName();
            if (grpName.equalsIgnoreCase("Ungrouped") || grpName.length() < 1) continue;
            tempCount += groupBean.getItems().size();
        }
        return tempCount < size;
    }

    public List<String> getNullValuesByEventCRFDefId(int eventDefinitionCRFId, DataSource dataSource) {
        if (eventDefinitionCRFId < 1 || dataSource == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> nullValuesList = new ArrayList<String>();
        ArrayList nullObjectList = new ArrayList();
        EventDefinitionCRFDAO eventDefinitionCRFDAO = new EventDefinitionCRFDAO(dataSource);
        EventDefinitionCRFBean eventCRFDefBean = (EventDefinitionCRFBean)eventDefinitionCRFDAO.findByPK(eventDefinitionCRFId);
        nullObjectList = eventCRFDefBean.getNullValuesList();
        if (nullObjectList == null) {
            return new ArrayList<String>();
        }
        for (NullValue nullVal : nullObjectList) {
            nullValuesList.add(nullVal.getName());
        }
        return nullValuesList;
    }

    private boolean itemsIncludeChecksRadiosSelects(List<ItemFormMetadataBean> metaBeans) {
        for (ItemFormMetadataBean fbean : metaBeans) {
            String responseName = fbean.getResponseSet().getResponseType().getName();
            if (responseName == null || responseName.length() < 1) {
                return false;
            }
            if (!responseName.equalsIgnoreCase("checkbox") && !responseName.equalsIgnoreCase("radio") && !responseName.equalsIgnoreCase("single-select") && !responseName.equalsIgnoreCase("multi-select")) continue;
            return true;
        }
        return false;
    }

    public void addNullValuesToDisplayItemWithGroupBeans(List<DisplayItemWithGroupBean> groupBeans, List<String> nullValuesList) {
        if (nullValuesList == null || nullValuesList.isEmpty() || groupBeans == null || groupBeans.isEmpty()) {
            return;
        }
        DisplayItemGroupBean displayItemGroupBean = null;
        List disBeans = new ArrayList();
        String responseName = "";
        for (DisplayItemWithGroupBean withGroupBean : groupBeans) {
            displayItemGroupBean = withGroupBean.getItemGroup();
            disBeans = displayItemGroupBean.getItems();
            for (DisplayItemBean singleBean : disBeans) {
                responseName = singleBean.getMetadata().getResponseSet().getResponseType().getName();
                ArrayList respOptions = singleBean.getMetadata().getResponseSet().getOptions();
                if (respOptions == null || !"checkbox".equalsIgnoreCase(responseName) && !"radio".equalsIgnoreCase(responseName) && !"single-select".equalsIgnoreCase(responseName) && !"multi-select".equalsIgnoreCase(responseName)) continue;
                this.addBeansToResponseOptions(nullValuesList, (List)respOptions);
            }
        }
    }
}

