/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.view.form.CellFactoryPrintDecorator;
import org.akaza.openclinica.view.form.CssRules;
import org.akaza.openclinica.view.form.DefaultFormBuilder;
import org.akaza.openclinica.view.form.FormBeanUtilDecorator;
import org.akaza.openclinica.view.form.RepeatManager;
import org.akaza.openclinica.view.form.ViewBuilderPrintDecorator;
import org.akaza.openclinica.view.form.ViewPersistanceHandler;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PrintHorizontalFormBuilder
extends DefaultFormBuilder {
    private int maxColRow = 4;
    private List<DisplaySectionBean> displaySectionBeans = new ArrayList();
    private StudyBean studyBean;
    private EventCRFBean eventCRFbean;
    private boolean involvesDataEntry;
    private boolean hasDbFormValues;
    private boolean isInternetExplorer = false;
    private boolean reconfigureView;
    private SectionBean sectionBean;

    public List<DisplaySectionBean> getDisplaySectionBeans() {
        return this.displaySectionBeans;
    }

    public void setDisplaySectionBeans(List<DisplaySectionBean> displaySectionBeans) {
        this.displaySectionBeans = displaySectionBeans;
    }

    public String createMarkup() {
        ViewPersistanceHandler persistanceHandler = new ViewPersistanceHandler();
        ViewBuilderPrintDecorator builderUtil = new ViewBuilderPrintDecorator();
        StringWriter writer = new StringWriter();
        StringBuilder webPageBuilder = new StringBuilder();
        int pageNumber = 0;
        if (this.isInternetExplorer) {
            for (DisplaySectionBean displaySecBean : this.displaySectionBeans) {
                this.reconfigureView = builderUtil.hasThreePlusColumns(displaySecBean);
                if (!this.reconfigureView) continue;
                break;
            }
        }
        int uniqueId = 0;
        for (DisplaySectionBean displaySecBean : this.displaySectionBeans) {
            CellFactoryPrintDecorator cellFactory = new CellFactoryPrintDecorator();
            RepeatManager repeatManager = new RepeatManager();
            FormBeanUtilDecorator formUtilDecorator = new FormBeanUtilDecorator();
            boolean changeHTMLForIE = false;
            if (this.reconfigureView) {
                // empty if block
            }
            ++pageNumber;
            this.sectionBean = displaySecBean.getSection();
            if (this.involvesDataEntry) {
                persistanceHandler = new ViewPersistanceHandler();
                List itemDataBeans = persistanceHandler.fetchPersistedData(this.sectionBean.getId(), this.eventCRFbean.getId());
                if (!itemDataBeans.isEmpty()) {
                    this.hasDbFormValues = true;
                }
                persistanceHandler.setItemDataBeans(itemDataBeans);
            }
            Element divRoot = new Element("div");
            divRoot.setAttribute("id", "toplevel" + pageNumber);
            divRoot.setAttribute("class", "toplevel");
            if (this.isInternetExplorer) {
                divRoot.setAttribute("style", "float:none");
            }
            Document doc = new Document(divRoot);
            builderUtil.showTitles(divRoot, this.sectionBean, pageNumber, this.isInternetExplorer);
            int tabindex = 1;
            boolean hasDiscrepancyMgt = false;
            StudyBean studBean = this.getStudyBean();
            if (studBean != null && studBean.getStudyParameterConfig().getDiscrepancyManagement().equalsIgnoreCase("true")) {
                hasDiscrepancyMgt = true;
            }
            for (DisplayItemGroupBean displayItemGroup : displaySecBean.getDisplayFormGroups()) {
                String groupHeader;
                boolean hasGroupHeader;
                ArrayList<Element> headerlist = new ArrayList<Element>();
                ArrayList<Element> bodylist = new ArrayList<Element>();
                ArrayList subHeadList = new ArrayList();
                List currentDisplayItems = displayItemGroup.getItems();
                SortedMap ordinalItemDataMap = new TreeMap();
                boolean hasStoredRepeatedRows = false;
                boolean unGroupedTable = displayItemGroup.getItemGroupBean().getName().equalsIgnoreCase("Ungrouped");
                if (this.hasDbFormValues) {
                    currentDisplayItems = persistanceHandler.loadDataIntoDisplayBeans(currentDisplayItems, !unGroupedTable);
                    if (this.involvesDataEntry && !unGroupedTable && persistanceHandler.hasPersistentRepeatedRows(currentDisplayItems)) {
                        hasStoredRepeatedRows = true;
                        ordinalItemDataMap = persistanceHandler.handleExtraGroupRows();
                    }
                }
                boolean bl = hasGroupHeader = (groupHeader = displayItemGroup.getGroupMetaBean().getHeader()) != null && groupHeader.length() > 0;
                if (hasGroupHeader) {
                    Element divGroupHeader = new Element("div");
                    divGroupHeader.setAttribute("class", "aka_group_header");
                    Element strong = new Element("strong");
                    strong.setAttribute("style", "float:none");
                    strong.addContent(groupHeader);
                    divGroupHeader.addContent((Content)strong);
                    divRoot.addContent((Content)divGroupHeader);
                }
                Element tableDiv = new Element("div");
                tableDiv.setAttribute("class", "tableDiv");
                if (this.isInternetExplorer) {
                    tableDiv.setAttribute("style", "float:none");
                }
                divRoot.addContent((Content)tableDiv);
                Element orphanTable = null;
                if (unGroupedTable) {
                    orphanTable = formUtilDecorator.createXHTMLTableFromNonGroup(currentDisplayItems, Integer.valueOf(tabindex), hasDiscrepancyMgt, this.hasDbFormValues, true);
                    tabindex += currentDisplayItems.size();
                    tableDiv.addContent((Content)orphanTable);
                    continue;
                }
                String repeatParentId = "repeatParent" + ++uniqueId;
                int repeatNumber = displayItemGroup.getGroupMetaBean().getRepeatNum();
                repeatNumber = repeatNumber < 1 ? 1 : repeatNumber;
                repeatNumber = repeatNumber > 12 ? 12 : repeatNumber;
                boolean repeatFlag = true;
                Element table = this.createTable();
                Element thead = new Element("tr");
                tableDiv.addContent((Content)table);
                boolean hasResponseLayout = builderUtil.hasResponseLayout(currentDisplayItems);
                List thTags = repeatFlag ? this.createTheadContentsFromDisplayItems(currentDisplayItems, true) : this.createTheadContentsFromDisplayItems(currentDisplayItems, false);
                int i = 0;
                for (Element el : thTags) {
                    thead.addContent((Content)el);
                    if (++i % this.maxColRow != 0) continue;
                    headerlist.add(thead);
                    thead = new Element("tr");
                }
                if (i % this.maxColRow != 0) {
                    headerlist.add(thead);
                }
                if (hasResponseLayout) {
                    this.addResponseLayoutRow(subHeadList, currentDisplayItems);
                }
                Element row = new Element("tr");
                if (!(!repeatFlag || this.involvesDataEntry && hasStoredRepeatedRows)) {
                    table = repeatManager.addParentRepeatAttributes(table, repeatParentId, Integer.valueOf(repeatNumber), displayItemGroup.getGroupMetaBean().getRepeatMax());
                }
                int j = 0;
                for (DisplayItemBean displayBean : currentDisplayItems) {
                    ++j;
                    String responseName = displayBean.getMetadata().getResponseSet().getResponseType().getName();
                    if (displayBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") && (responseName.equalsIgnoreCase("checkbox") || responseName.equalsIgnoreCase("radio"))) {
                        Element[] elements;
                        for (Element el : elements = cellFactory.createCellContentsForChecks(responseName, displayBean, Integer.valueOf(displayBean.getMetadata().getResponseSet().getOptions().size()), Integer.valueOf(++tabindex), false, true)) {
                            el = builderUtil.setClassNames(el);
                            if (repeatFlag) {
                                // empty if block
                            }
                            row.addContent((Content)el);
                        }
                        continue;
                    }
                    Element td = new Element("td");
                    td = builderUtil.setClassNames(td);
                    td = cellFactory.createCellContents(td, responseName, displayBean, Integer.valueOf(++tabindex), hasDiscrepancyMgt, this.hasDbFormValues, true);
                    if (repeatFlag) {
                        // empty if block
                    }
                    row.addContent((Content)td);
                    if (j % this.maxColRow != 0) continue;
                    bodylist.add(row);
                    row = new Element("tr");
                    if (!repeatFlag) continue;
                    repeatParentId = repeatParentId + uniqueId++;
                }
                if (j % this.maxColRow != 0) {
                    bodylist.add(row);
                }
                if (repeatNumber > 1 || hasStoredRepeatedRows) {
                    Element newRow = new Element("tr");
                    Element div = new Element("div");
                    div.setAttribute("id", "repeatCaption");
                    Element newCol = new Element("td");
                    Element strong = new Element("strong");
                    strong.addContent("Repeat: 1");
                    div.addContent((Content)strong);
                    newCol.addContent((Content)div);
                    newRow.addContent((Content)newCol);
                    table.addContent((Content)newRow);
                }
                for (int k = 0; k < headerlist.size(); ++k) {
                    Element head = (Element)headerlist.get(k);
                    Element body = (Element)bodylist.get(k);
                    table.addContent((Content)head);
                    if (subHeadList.size() > 0) {
                        try {
                            Element subHead = (Element)subHeadList.get(k);
                            table.addContent((Content)subHead);
                        }
                        catch (IndexOutOfBoundsException subHead) {
                            // empty catch block
                        }
                    }
                    table.addContent((Content)body);
                }
                if (!hasStoredRepeatedRows) continue;
                List storedRepeatedRows = builderUtil.generatePersistentMatrixRows(ordinalItemDataMap, currentDisplayItems, tabindex, repeatParentId, hasDiscrepancyMgt, true, this.maxColRow);
                int count = 1;
                for (int l = 0; l < storedRepeatedRows.size(); ++l) {
                    ArrayList rowsList = (ArrayList)storedRepeatedRows.get(l);
                    divRoot.addContent((Content)this.createTableWithData((List)rowsList, headerlist, subHeadList, ++count));
                }
            }
            XMLOutputter outp = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            format.setOmitDeclaration(true);
            outp.setFormat(format);
            writer = new StringWriter();
            try {
                outp.output(doc, (Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            webPageBuilder.append(((Object)writer).toString());
        }
        return webPageBuilder.toString();
    }

    public String createMarkupNoDE() {
        ViewPersistanceHandler persistanceHandler = new ViewPersistanceHandler();
        ViewBuilderPrintDecorator builderUtil = new ViewBuilderPrintDecorator();
        StringWriter writer = new StringWriter();
        StringBuilder webPageBuilder = new StringBuilder();
        int pageNumber = 0;
        if (this.isInternetExplorer) {
            for (DisplaySectionBean displaySecBean : this.displaySectionBeans) {
                this.reconfigureView = builderUtil.hasThreePlusColumns(displaySecBean);
                if (!this.reconfigureView) continue;
                break;
            }
        }
        int uniqueId = 0;
        for (DisplaySectionBean displaySecBean : this.displaySectionBeans) {
            CellFactoryPrintDecorator cellFactory = new CellFactoryPrintDecorator();
            RepeatManager repeatManager = new RepeatManager();
            FormBeanUtilDecorator formUtilDecorator = new FormBeanUtilDecorator();
            boolean changeHTMLForIE = false;
            if (this.reconfigureView) {
                // empty if block
            }
            ++pageNumber;
            this.sectionBean = displaySecBean.getSection();
            if (this.involvesDataEntry) {
                persistanceHandler = new ViewPersistanceHandler();
                List itemDataBeans = persistanceHandler.fetchPersistedData(this.sectionBean.getId(), this.eventCRFbean.getId());
                if (!itemDataBeans.isEmpty()) {
                    this.hasDbFormValues = true;
                }
                persistanceHandler.setItemDataBeans(itemDataBeans);
            }
            Element divRoot = new Element("div");
            divRoot.setAttribute("id", "toplevel" + pageNumber);
            divRoot.setAttribute("class", "toplevel");
            if (this.isInternetExplorer) {
                divRoot.setAttribute("style", "float:none");
            }
            Document doc = new Document(divRoot);
            builderUtil.showTitles(divRoot, this.sectionBean, pageNumber, this.isInternetExplorer);
            int tabindex = 1;
            boolean hasDiscrepancyMgt = false;
            StudyBean studBean = this.getStudyBean();
            if (studBean != null && studBean.getStudyParameterConfig().getDiscrepancyManagement().equalsIgnoreCase("true")) {
                hasDiscrepancyMgt = true;
            }
            hasDiscrepancyMgt = false;
            for (DisplayItemGroupBean displayItemGroup : displaySecBean.getDisplayFormGroups()) {
                String groupHeader;
                boolean hasGroupHeader;
                boolean unGroupedTable;
                ArrayList<Element> headerlist = new ArrayList<Element>();
                ArrayList<Element> bodylist = new ArrayList<Element>();
                ArrayList subHeadList = new ArrayList();
                List currentDisplayItems = displayItemGroup.getItems();
                SortedMap ordinalItemDataMap = new TreeMap();
                boolean hasStoredRepeatedRows = false;
                boolean bl = unGroupedTable = !displayItemGroup.getGroupMetaBean().isRepeatingGroup();
                if (this.hasDbFormValues) {
                    currentDisplayItems = persistanceHandler.loadDataIntoDisplayBeans(currentDisplayItems, !unGroupedTable);
                    if (this.involvesDataEntry && !unGroupedTable && persistanceHandler.hasPersistentRepeatedRows(currentDisplayItems)) {
                        hasStoredRepeatedRows = true;
                        ordinalItemDataMap = persistanceHandler.handleExtraGroupRows();
                    }
                }
                boolean bl2 = hasGroupHeader = (groupHeader = displayItemGroup.getGroupMetaBean().getHeader()) != null && groupHeader.length() > 0;
                if (hasGroupHeader) {
                    Element divGroupHeader = new Element("div");
                    divGroupHeader.setAttribute("class", "aka_group_header");
                    Element strong = new Element("strong");
                    strong.setAttribute("style", "float:none");
                    strong.addContent(groupHeader);
                    divGroupHeader.addContent((Content)strong);
                    divRoot.addContent((Content)divGroupHeader);
                }
                Element tableDiv = new Element("div");
                tableDiv.setAttribute("class", "tableDiv");
                if (this.isInternetExplorer) {
                    tableDiv.setAttribute("style", "float:none");
                }
                divRoot.addContent((Content)tableDiv);
                Element orphanTable = null;
                if (unGroupedTable) {
                    orphanTable = formUtilDecorator.createXHTMLTableFromNonGroup(currentDisplayItems, Integer.valueOf(tabindex), hasDiscrepancyMgt, this.hasDbFormValues, true);
                    tabindex += currentDisplayItems.size();
                    tableDiv.addContent((Content)orphanTable);
                    continue;
                }
                String repeatParentId = "repeatParent" + ++uniqueId;
                int repeatNumber = displayItemGroup.getGroupMetaBean().getRepeatNum();
                repeatNumber = repeatNumber < 1 ? 1 : repeatNumber;
                repeatNumber = repeatNumber > 12 ? 12 : repeatNumber;
                boolean repeatFlag = true;
                Element table = this.createTable();
                Element thead = new Element("tr");
                tableDiv.addContent((Content)table);
                boolean hasResponseLayout = builderUtil.hasResponseLayout(currentDisplayItems);
                List thTags = repeatFlag ? this.createTheadContentsFromDisplayItems(currentDisplayItems, true) : this.createTheadContentsFromDisplayItems(currentDisplayItems, false);
                int i = 0;
                for (Element el : thTags) {
                    thead.addContent((Content)el);
                    if (++i % this.maxColRow != 0) continue;
                    headerlist.add(thead);
                    thead = new Element("tr");
                }
                if (i % this.maxColRow != 0) {
                    headerlist.add(thead);
                }
                if (hasResponseLayout) {
                    this.addResponseLayoutRow(subHeadList, currentDisplayItems);
                }
                Element row = new Element("tr");
                if (!(!repeatFlag || this.involvesDataEntry && hasStoredRepeatedRows)) {
                    table = repeatManager.addParentRepeatAttributes(table, repeatParentId, Integer.valueOf(repeatNumber), displayItemGroup.getGroupMetaBean().getRepeatMax());
                }
                int j = 0;
                for (DisplayItemBean displayBean : currentDisplayItems) {
                    ++j;
                    String responseName = displayBean.getMetadata().getResponseSet().getResponseType().getName();
                    if (displayBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") && (responseName.equalsIgnoreCase("checkbox") || responseName.equalsIgnoreCase("radio"))) {
                        Element[] elements;
                        for (Element el : elements = cellFactory.createCellContentsForChecks(responseName, displayBean, Integer.valueOf(displayBean.getMetadata().getResponseSet().getOptions().size()), Integer.valueOf(++tabindex), false, true)) {
                            el = builderUtil.setClassNames(el);
                            if (repeatFlag) {
                                el = repeatManager.addChildRepeatAttributes(el, repeatParentId, Integer.valueOf(displayBean.getItem().getId()), null);
                            }
                            row.addContent((Content)el);
                        }
                        continue;
                    }
                    Element td = new Element("td");
                    td = builderUtil.setClassNames(td);
                    td = cellFactory.createCellContents(td, responseName, displayBean, Integer.valueOf(++tabindex), hasDiscrepancyMgt, this.hasDbFormValues, true);
                    if (repeatFlag) {
                        // empty if block
                    }
                    row.addContent((Content)td);
                    if (j % this.maxColRow != 0) continue;
                    bodylist.add(row);
                    row = new Element("tr");
                    if (!repeatFlag) continue;
                    repeatParentId = repeatParentId + uniqueId++;
                }
                if (j % this.maxColRow != 0) {
                    bodylist.add(row);
                }
                if (hasStoredRepeatedRows) {
                    Element newRow = new Element("tr");
                    Element div = new Element("div");
                    div.setAttribute("id", "repeatCaption");
                    Element newCol = new Element("td");
                    Element strong = new Element("strong");
                    strong.addContent("Repeat: 1");
                    div.addContent((Content)strong);
                    newCol.addContent((Content)div);
                    newRow.addContent((Content)newCol);
                    table.addContent((Content)newRow);
                }
                if (!hasStoredRepeatedRows) {
                    for (int ii = 0; ii < repeatNumber; ++ii) {
                        divRoot.addContent((Content)this.createTableWithoutData(bodylist, headerlist, subHeadList, ii, unGroupedTable));
                    }
                }
                if (!hasStoredRepeatedRows) continue;
                List storedRepeatedRows = builderUtil.generatePersistentMatrixRows(ordinalItemDataMap, currentDisplayItems, tabindex, repeatParentId, hasDiscrepancyMgt, true, this.maxColRow);
                int count = 1;
                for (int l = 0; l < storedRepeatedRows.size(); ++l) {
                    ArrayList rowsList = (ArrayList)storedRepeatedRows.get(l);
                    divRoot.addContent((Content)this.createTableWithData((List)rowsList, headerlist, subHeadList, ++count));
                }
            }
            XMLOutputter outp = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            format.setOmitDeclaration(true);
            outp.setFormat(format);
            writer = new StringWriter();
            try {
                outp.output(doc, (Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            webPageBuilder.append(((Object)writer).toString());
        }
        return webPageBuilder.toString();
    }

    private int getRepeatFromPrevMeta(List<DisplayItemGroupBean> displayFormGroups) {
        if (displayFormGroups.size() > 0) {
            return displayFormGroups.get(0).getGroupMetaBean().getRepeatNum();
        }
        return 0;
    }

    private Element createTableWithData(List<Element> rows, ArrayList headerList, ArrayList subHeaderList, int rep) {
        Element table = this.createTable();
        Element newRow = new Element("tr");
        Element newCol = new Element("td");
        Element strong = new Element("strong");
        strong.addContent("Repeat: " + rep);
        newCol.addContent((Content)strong);
        newRow.addContent((Content)newCol);
        table.addContent((Content)newRow);
        for (int i = 0; i < headerList.size(); ++i) {
            Element head = (Element)headerList.get(i);
            Element body = rows.get(i);
            table.addContent((Content)((Element)head.clone()));
            if (subHeaderList.size() > 0) {
                try {
                    Element subHead = (Element)subHeaderList.get(i);
                    table.addContent((Content)((Element)subHead.clone()));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            table.addContent((Content)body);
        }
        return table;
    }

    private Element createTableWithoutData(List<Element> rows, ArrayList headerList, ArrayList subHeaderList, int rep, boolean ungrouped) {
        Element table = this.createTable();
        table = this.createTable();
        if (!ungrouped) {
            table.setAttribute("id", "repeat" + rep);
            Element newCol = new Element("td");
            Element strong = new Element("strong");
            strong.setAttribute("style", "aka_font_general");
            strong.addContent("Repeat: " + (rep + 1));
            newCol.addContent((Content)strong);
            Element newRow = new Element("tr");
            newRow.addContent((Collection)newCol.cloneContent());
            table.addContent((Collection)newRow.cloneContent());
            strong.removeContent();
            if (headerList.size() == 0) {
                newRow.setAttribute("style", "display:none;");
                newCol.setAttribute("style", "display:none;");
                strong.setAttribute("style", "display:none;");
                table.setAttribute("style", "display:none;");
            }
        }
        for (int i = 0; i < headerList.size(); ++i) {
            Element head = (Element)headerList.get(i);
            Element body = rows.get(i);
            table.addContent((Content)((Element)head.clone()));
            if (subHeaderList.size() > 0) {
                try {
                    Element subHead = (Element)subHeaderList.get(i);
                    table.addContent((Content)((Element)subHead.clone()));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            table.addContent((Collection)body.cloneContent());
        }
        return table;
    }

    private void addResponseLayoutRow(ArrayList subHeadList, List<DisplayItemBean> displayBeans) {
        Element th2;
        Element thRow = new Element("tr");
        int j = 0;
        for (DisplayItemBean dBean : displayBeans) {
            String responseLayout;
            ++j;
            ItemFormMetadataBean metaBean = dBean.getMetadata();
            ResponseSetBean respBean = metaBean.getResponseSet();
            String responseName = respBean.getResponseType().getName();
            if (responseName == null) {
                responseName = "";
            }
            if ((responseLayout = metaBean.getResponseLayout()) == null) {
                responseLayout = "";
            }
            if ((responseName.equalsIgnoreCase("radio") || responseName.equalsIgnoreCase("checkbox")) && responseLayout.equalsIgnoreCase("horizontal")) {
                for (int i = 0; i < respBean.getOptions().size(); ++i) {
                    ResponseOptionBean optBean = (ResponseOptionBean)respBean.getOptions().get(i);
                    if (optBean == null) continue;
                    th2 = this.createThCell(optBean.getText(), 1);
                    String classNames = th2.getAttribute("class").getValue();
                    classNames = classNames + " general_font";
                    th2.setAttribute("class", classNames);
                    thRow.addContent((Content)th2);
                }
            } else {
                th2 = this.createThCell("", 1);
                thRow.addContent((Content)th2);
            }
            if (j % this.maxColRow != 0) continue;
            subHeadList.add(thRow);
            thRow = new Element("tr");
        }
        if (j % this.maxColRow != 0) {
            subHeadList.add(thRow);
        }
        th2 = this.createThCell();
        thRow.addContent((Content)th2);
    }

    public Element createTable() {
        Element tab = super.createTable();
        return this.setClassNames(tab);
    }

    public Element createThCell(String cellText, int colSpan) {
        Element th = new Element("td");
        th.setText(cellText);
        if (colSpan > 1) {
            th.setAttribute("colspan", colSpan + "");
        }
        th.setAttribute("class", "aka_headerBackground aka_padding_large aka_cellBorders aka_font_general");
        th.setAttribute("align", "center");
        return th;
    }

    public Element createTHTagFromItemMeta(ItemFormMetadataBean itemFormBean) {
        String responseType = itemFormBean.getResponseSet().getResponseType().getName();
        boolean hasQuestNumber = !"".equalsIgnoreCase(itemFormBean.getQuestionNumberLabel());
        Element newSpan = new Element("span");
        String header = itemFormBean.getHeader();
        if (hasQuestNumber) {
            newSpan = new Element("span");
            newSpan.setAttribute("style", "margin-right:1em");
            newSpan.addContent(itemFormBean.getQuestionNumberLabel());
        }
        if (header != null && header.length() == 0) {
            header = itemFormBean.getLeftItemText();
        }
        Element thTag = (responseType.equalsIgnoreCase("radio") || responseType.equalsIgnoreCase("checkbox")) && itemFormBean.getResponseLayout().equalsIgnoreCase("horizontal") ? this.createThCell(header, itemFormBean.getResponseSet().getOptions().size()) : this.createThCell(header, 1);
        if (hasQuestNumber) {
            thTag.addContent(0, (Content)newSpan);
        }
        return thTag;
    }

    public void createDarkBorders(Element element) {
        if (element == null) {
            return;
        }
        element.removeAttribute("class");
        String cssRuleIdentifier = element.getName();
        String cssClasses = CssRules.getClassNamesForTag((String)(cssRuleIdentifier + " borders_on"));
        element.setAttribute("class", cssClasses);
    }

    public List<Element> createTheadContentsFromDisplayItems(List<DisplayItemBean> displayBeans, boolean generateExtraColumn) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (DisplayItemBean displayBean : displayBeans) {
            ItemFormMetadataBean itemFormBean = displayBean.getMetadata();
            elements.add(this.createTHTagFromItemMeta(itemFormBean));
        }
        return elements;
    }

    public Element setClassNames(Element styledElement) {
        String cssClasses = CssRules.getClassNamesForTag((String)styledElement.getName());
        return cssClasses.length() == 0 ? styledElement : styledElement.setAttribute("class", cssClasses);
    }

    public SectionBean getSectionBean() {
        return this.sectionBean;
    }

    public void setSectionBean(SectionBean sectionBean) {
        this.sectionBean = sectionBean;
    }

    public boolean isInvolvesDataEntry() {
        return this.involvesDataEntry;
    }

    public void setInvolvesDataEntry(boolean involvesDataEntry) {
        this.involvesDataEntry = involvesDataEntry;
    }

    public EventCRFBean getEventCRFbean() {
        return this.eventCRFbean;
    }

    public void setEventCRFbean(EventCRFBean eventCRFbean) {
        this.eventCRFbean = eventCRFbean;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }

    public boolean isInternetExplorer() {
        return this.isInternetExplorer;
    }

    public void setInternetExplorer(boolean internetExplorer) {
        this.isInternetExplorer = internetExplorer;
    }
}

