/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.view.form.ViewBuilderUtil;

public class ViewPersistanceHandler {
    private List<ItemDataBean> itemDataBeans = new ArrayList();
    private ViewBuilderUtil viewBuilderUtil = new ViewBuilderUtil();

    public List<ItemDataBean> fetchPersistedData(int sectionId, int eventcrfId) {
        ItemDataDAO itemDataDAO = new ItemDataDAO(SessionManager.getStaticDataSource());
        ArrayList itemDataBeans = itemDataDAO.findAllActiveBySectionIdAndEventCRFId(sectionId, eventcrfId);
        return itemDataBeans == null ? new ArrayList() : itemDataBeans;
    }

    public List<DisplayItemBean> loadDataIntoDisplayBeans(List<DisplayItemBean> disBeans, boolean hasGroupedItems) {
        List dataBeans = this.getItemDataBeans();
        if (dataBeans.isEmpty() || disBeans == null || disBeans.isEmpty()) {
            return new ArrayList<DisplayItemBean>();
        }
        block0: for (DisplayItemBean itemBean : disBeans) {
            for (ItemDataBean iDataBean : dataBeans) {
                if (iDataBean.getOrdinal() != 1 || iDataBean.getItemId() != itemBean.getItem().getId()) continue;
                itemBean.setData(iDataBean);
                continue block0;
            }
        }
        return disBeans;
    }

    public boolean hasPersistentRepeatedRows(List<DisplayItemBean> itemBeans) {
        for (DisplayItemBean disBean : itemBeans) {
            for (ItemDataBean dataBean : this.getItemDataBeans()) {
                if (disBean.getItem().getId() != dataBean.getItemId() || dataBean.getOrdinal() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public SortedMap<Integer, List<ItemDataBean>> handleExtraGroupRows() {
        List dataBeans = this.getItemDataBeans();
        TreeMap<Integer, List<ItemDataBean>> ordinalItemDataMap = new TreeMap<Integer, List<ItemDataBean>>();
        ArrayList<ItemDataBean> innerDataBeanList = new ArrayList<ItemDataBean>();
        int tracker = 0;
        ArrayList<Integer> listOrdinal = new ArrayList<Integer>();
        boolean currentOrdinal = false;
        for (ItemDataBean itemDataBean : dataBeans) {
            int tempOrdinal = itemDataBean.getOrdinal();
            if (tempOrdinal <= 1) continue;
            if (++tracker == 1) {
                innerDataBeanList.add(itemDataBean);
                listOrdinal.add(tempOrdinal);
                ordinalItemDataMap.put(tempOrdinal, innerDataBeanList);
                continue;
            }
            if (listOrdinal.contains(tempOrdinal)) {
                ((List)ordinalItemDataMap.get(tempOrdinal)).add(itemDataBean);
                continue;
            }
            listOrdinal.add(tempOrdinal);
            innerDataBeanList = new ArrayList();
            innerDataBeanList.add(itemDataBean);
            ordinalItemDataMap.put(tempOrdinal, innerDataBeanList);
        }
        return ordinalItemDataMap;
    }

    public Map<Integer, List<DisplayItemBean>> sortDuplicatesIntoRows(List<DisplayItemBean> displayBeans) {
        HashMap<Integer, List<DisplayItemBean>> rowMap = new HashMap<Integer, List<DisplayItemBean>>();
        ArrayList<DisplayItemBean> mapList = new ArrayList<DisplayItemBean>();
        ArrayList<DisplayItemBean> dupesList = new ArrayList<DisplayItemBean>();
        for (DisplayItemBean disBean : displayBeans) {
            if (disBean.getData().getOrdinal() <= 1) continue;
            dupesList.add(disBean);
        }
        int currentOrdinal = 0;
        int currentItemId = 0;
        for (DisplayItemBean disBean : dupesList) {
            if (currentItemId == 0) {
                currentItemId = disBean.getItem().getId();
                currentOrdinal = disBean.getData().getOrdinal();
                mapList.add(disBean);
                rowMap.put(currentItemId, mapList);
                continue;
            }
            if (disBean.getData().getOrdinal() == currentOrdinal) {
                mapList.add(disBean);
                continue;
            }
            currentOrdinal = disBean.getData().getOrdinal();
            mapList = new ArrayList();
            mapList.add(disBean);
            rowMap.put(disBean.getItem().getId(), mapList);
        }
        return rowMap;
    }

    private boolean listContainsDisplayItem(List<DisplayItemBean> beanList, DisplayItemBean singleBean) {
        for (DisplayItemBean disBean : beanList) {
            if (singleBean.getItem().getId() != disBean.getItem().getId()) continue;
            return true;
        }
        return false;
    }

    public List<ItemDataBean> getItemDataBeans() {
        return this.itemDataBeans;
    }

    public void setItemDataBeans(List<ItemDataBean> itemDataBeans) {
        this.itemDataBeans = itemDataBeans;
    }

    public ViewBuilderUtil getViewBuilderUtil() {
        return this.viewBuilderUtil;
    }

    public void setViewBuilderUtil(ViewBuilderUtil viewBuilderUtil) {
        this.viewBuilderUtil = viewBuilderUtil;
    }
}

