/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.akaza.openclinica.view.Link;
import org.akaza.openclinica.web.domain.EntityBeanColumn;
import org.akaza.openclinica.web.domain.EntityBeanRow;

public class EntityBeanTable {
    public static final int NUM_ROWS_PER_PAGE = 10;
    protected ArrayList rows = new ArrayList();
    protected ArrayList columns = new ArrayList();
    protected int numColumns = 0;
    protected int currPageNumber = 1;
    protected int totalPageNumbers = 0;
    protected int sortingColumnInd = 0;
    protected boolean sortingColumnExplicitlySet = false;
    protected boolean ascendingSort = true;
    protected boolean filtered = false;
    protected String keywordFilter = "";
    protected boolean paginated = true;
    protected ArrayList links;
    protected String postAction = "";
    protected HashMap postArgs = new HashMap();
    protected String baseGetQuery = "";
    protected String noRowsMessage = "";
    protected String noColsMessage = "";

    public EntityBeanTable() {
        this.links = new ArrayList();
    }

    public int getTotalPageNumbers() {
        return this.totalPageNumbers;
    }

    public ArrayList getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList columns) {
        ArrayList<EntityBeanColumn> newColumns = new ArrayList<EntityBeanColumn>();
        for (int i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            EntityBeanColumn c = new EntityBeanColumn();
            c.setName(name);
            newColumns.add(c);
        }
        this.columns = newColumns;
        this.numColumns = this.columns.size();
    }

    public boolean isAscendingSort() {
        return this.ascendingSort;
    }

    public int getCurrPageNumber() {
        return this.currPageNumber;
    }

    public String getKeywordFilter() {
        return this.keywordFilter;
    }

    public ArrayList getRows() {
        return this.rows;
    }

    private void updateTotalPageNumbers() {
        this.totalPageNumbers = this.rows.size() / 10;
        if (this.rows.size() > this.totalPageNumbers * 10) {
            ++this.totalPageNumbers;
        }
    }

    public void setRows(ArrayList rows) {
        this.rows = rows;
        this.updateTotalPageNumbers();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public int getSortingColumnInd() {
        return this.sortingColumnInd;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setQuery(String baseURL, HashMap args) {
        this.postAction = baseURL;
        this.postArgs = args;
        this.baseGetQuery = baseURL + "?";
        this.baseGetQuery = this.baseGetQuery + "submitted=1";
        for (String key : args.keySet()) {
            String value = (String)args.get(key);
            this.baseGetQuery = this.baseGetQuery + "&" + key + "=" + value;
        }
    }

    public String getBaseGetQuery() {
        return this.baseGetQuery;
    }

    public String getPostAction() {
        return this.postAction;
    }

    public HashMap getPostArgs() {
        return this.postArgs;
    }

    public void setAscendingSort(boolean ascendingSort) {
        this.ascendingSort = ascendingSort;
    }

    public void setCurrPageNumber(int currPageNumber) {
        this.currPageNumber = currPageNumber;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setKeywordFilter(String keywordFilter) {
        this.keywordFilter = keywordFilter;
    }

    public void setSortingColumnInd(int sortingColumnInd) {
        this.sortingColumnInd = sortingColumnInd;
    }

    public String getNoColsMessage() {
        return this.noColsMessage;
    }

    public String getNoRowsMessage() {
        return this.noRowsMessage;
    }

    public boolean isPaginated() {
        return this.paginated;
    }

    public void setPaginated(boolean paginated) {
        this.paginated = paginated;
    }

    public void computeDisplay() {
        HashSet<EntityBeanRow> temprows = new HashSet<EntityBeanRow>();
        boolean filterExecuted = false;
        ArrayList displayRows = new ArrayList();
        if (this.filtered) {
            String[] keywords = null;
            if (this.keywordFilter != null) {
                keywords = this.keywordFilter.startsWith(" ") ? new String[]{this.keywordFilter} : this.keywordFilter.split("\\s");
            }
            if (keywords != null) {
                for (int j = 0; j < keywords.length; ++j) {
                    String keyword = keywords[j];
                    if (keyword == null || "".equals(keyword)) continue;
                    keyword = keyword.toLowerCase();
                    filterExecuted = true;
                    block1: for (int i = 0; i < this.rows.size(); ++i) {
                        EntityBeanRow row = (EntityBeanRow)this.rows.get(i);
                        String searchString = row.getSearchString().toLowerCase();
                        if (searchString.equalsIgnoreCase(keyword)) {
                            temprows.add(row);
                            continue;
                        }
                        if (searchString.contains("-")) {
                            String[] newSearchString = searchString.split(" ");
                            String[] subStrings = null;
                            for (String component : newSearchString) {
                                if (component.equalsIgnoreCase(keyword)) {
                                    temprows.add(row);
                                    continue block1;
                                }
                                for (String innerStr : subStrings = component.split("-")) {
                                    if (!innerStr.equalsIgnoreCase(keyword)) continue;
                                    temprows.add(row);
                                }
                            }
                            continue;
                        }
                        if (searchString.indexOf(keyword) < 0) continue;
                        temprows.add(row);
                    }
                }
            }
            Iterator it = temprows.iterator();
            while (it.hasNext()) {
                displayRows.add(it.next());
            }
        }
        if (!filterExecuted) {
            displayRows = this.rows;
        }
        this.setRows(displayRows);
        for (int i = 0; i < displayRows.size(); ++i) {
            EntityBeanRow row = (EntityBeanRow)displayRows.get(i);
            row.setSortingColumn(this.sortingColumnInd);
            row.setAscendingSort(this.ascendingSort);
            displayRows.set(i, row);
        }
        Collections.sort(displayRows);
        if (this.paginated) {
            ArrayList currPage;
            if (this.currPageNumber < 1) {
                this.currPageNumber = 1;
            }
            if (this.currPageNumber > this.totalPageNumbers && this.totalPageNumbers > 0) {
                this.currPageNumber = this.totalPageNumbers;
            }
            int firstInd = (this.currPageNumber - 1) * 10;
            int lastInd = this.currPageNumber * 10;
            int n = lastInd = lastInd > displayRows.size() ? displayRows.size() : lastInd;
            if (firstInd > lastInd && lastInd == 0) {
                firstInd = 0;
            }
            this.rows = currPage = new ArrayList(displayRows.subList(firstInd, lastInd));
        } else {
            this.rows = displayRows;
        }
    }

    public ArrayList getLinks() {
        return this.links;
    }

    public void setLinks(ArrayList links) {
        this.links = links;
    }

    public void addLink(String caption, String url) {
        Link l = new Link(caption, url);
        this.links.add(l);
    }

    public boolean isSortingColumnExplicitlySet() {
        return this.sortingColumnExplicitlySet;
    }

    public void setSortingColumnExplicitlySet(boolean sortingColumnExplicitlySet) {
        this.sortingColumnExplicitlySet = sortingColumnExplicitlySet;
    }

    public void setSortingIfNotExplicitlySet(int sortingColumnInd, boolean ascendingSort) {
        if (!this.sortingColumnExplicitlySet) {
            this.sortingColumnInd = sortingColumnInd;
            this.ascendingSort = ascendingSort;
        }
    }

    public void hideColumnLink(int i) {
        if (i >= 0 && i < this.columns.size()) {
            EntityBeanColumn c = (EntityBeanColumn)this.columns.get(i);
            c.setShowLink(false);
            this.columns.set(i, c);
        }
    }
}

