/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocaleFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.updateLocale(req, resp, LocaleResolver.resolveLocale((HttpServletRequest)req));
        if (chain != null) {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private void updateLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (locale != null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.setAttribute(LocaleResolver.getLocaleSessionAttributeName(), (Object)locale);
                Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
                if (response != null) {
                    response.setLocale(locale);
                }
            } else {
                this.logger.debug("Locale can not be saved into session because session is null.");
            }
        } else {
            this.logger.debug("No Locale updating has been done because passed Locale is null.");
        }
    }
}

