/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class XalanTransformJob
extends QuartzJobBean {
    public static final String DATASET_ID = "dsId";
    public static final String EMAIL = "contactEmail";
    public static final String USER_ID = "user_id";
    public static final String XSL_FILE_PATH = "xslFilePath";
    public static final String XML_FILE_PATH = "xmlFilePath";
    public static final String SQL_FILE_PATH = "sqlFilePath";

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        Locale locale = new Locale("en-US");
        ResourceBundleProvider.updateLocale((Locale)locale);
        ResourceBundle pageMessages = ResourceBundleProvider.getPageMessagesBundle();
        JobDataMap dataMap = context.getMergedJobDataMap();
        String alertEmail = dataMap.getString(EMAIL);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            FileInputStream in = new FileInputStream(dataMap.getString(XSL_FILE_PATH));
            Transformer transformer = tFactory.newTransformer(new StreamSource(in));
            long start = System.currentTimeMillis();
            transformer.transform(new StreamSource(dataMap.getString(XML_FILE_PATH)), new StreamResult(new FileOutputStream(dataMap.getString(SQL_FILE_PATH))));
            long l = System.currentTimeMillis() - start;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

