/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.SimpleTrigger;

public class XalanTriggerService {
    public static final String DATASET_ID = "dsId";
    public static final String EMAIL = "contactEmail";
    public static final String USER_ID = "user_id";
    public static final String XSL_FILE_PATH = "xslFilePath";
    public static final String XML_FILE_PATH = "xmlFilePath";
    public static final String SQL_FILE_PATH = "sqlFilePath";
    public static String TRIGGER_GROUP_NAME = "XalanTriggers";

    public SimpleTrigger generateXalanTrigger(String xslFile, String xmlFile, String sqlFile, int datasetId) {
        Date startDateTime = new Date(System.currentTimeMillis());
        String jobName = xmlFile + datasetId;
        SimpleTrigger trigger = new SimpleTrigger(jobName, TRIGGER_GROUP_NAME, 1, 1L);
        trigger.setStartTime(startDateTime);
        trigger.setName(jobName);
        trigger.setGroup(TRIGGER_GROUP_NAME);
        trigger.setMisfireInstruction(5);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(XSL_FILE_PATH, xslFile);
        jobDataMap.put(XML_FILE_PATH, xmlFile);
        jobDataMap.put(SQL_FILE_PATH, sqlFile);
        trigger.setJobDataMap(jobDataMap);
        trigger.setVolatility(false);
        return trigger;
    }
}

