/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.managestudy.CRFVersionMetadataUtil;
import org.akaza.openclinica.core.XMLContextFactory;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.RuleActionPropertyDao;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.domain.rule.action.PropertyBean;
import org.akaza.openclinica.domain.rule.action.RuleActionBean;
import org.akaza.openclinica.domain.rule.expression.ExpressionBean;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.web.pform.ExpressionExpressionEvaluate;
import org.akaza.openclinica.web.pform.dto.Bind;
import org.akaza.openclinica.web.pform.dto.Body;
import org.akaza.openclinica.web.pform.dto.Group;
import org.akaza.openclinica.web.pform.dto.Html;
import org.akaza.openclinica.web.pform.dto.Label;
import org.akaza.openclinica.web.pform.dto.Model;
import org.akaza.openclinica.web.pform.dto.Repeat;
import org.akaza.openclinica.web.pform.widget.Widget;
import org.akaza.openclinica.web.pform.widget.WidgetFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenRosaXmlGenerator {
    private XMLContext xmlContext = null;
    private DataSource dataSource = null;
    protected final Logger log = LoggerFactory.getLogger(OpenRosaXmlGenerator.class);
    CoreResources coreResources;
    private RuleActionPropertyDao ruleActionPropertyDao;
    private ItemDAO idao;
    private ItemGroupDAO igdao;
    private ItemGroupMetadataDAO igmdao;
    private ItemFormMetadataDAO itemFormMetadataDAO;
    private SectionDAO sdao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public OpenRosaXmlGenerator(CoreResources core, DataSource dataSource, RuleActionPropertyDao ruleActionPropertyDao) throws Exception {
        this.dataSource = dataSource;
        this.coreResources = core;
        this.ruleActionPropertyDao = ruleActionPropertyDao;
        try {
            this.xmlContext = XMLContextFactory.getXmlContextNoNamespace();
            Mapping mapping = this.xmlContext.createMapping();
            mapping.loadMapping(core.getURL("openRosaXFormMapping.xml"));
            this.xmlContext.addMapping(mapping);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception(e);
        }
    }

    public String buildForm(String formId) throws Exception {
        try {
            CRFVersionDAO versionDAO = new CRFVersionDAO(this.dataSource);
            CRFVersionBean crfVersion = versionDAO.findByOid(formId);
            CRFDAO crfDAO = new CRFDAO(this.dataSource);
            CRFBean crf = (CRFBean)crfDAO.findByPK(crfVersion.getCrfId());
            CRFVersionMetadataUtil metadataUtil = new CRFVersionMetadataUtil(this.dataSource);
            ArrayList crfSections = metadataUtil.retrieveFormMetadata(crfVersion);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/properties/xform_template.xml"), (Writer)writer, (String)"UTF-8");
            String xform = writer.toString();
            Html html = this.buildJavaXForm(xform);
            int sectionCount = this.mapBeansToDTO(html, crf, crfVersion, crfSections);
            if (sectionCount > 1) {
                this.setFormPaging(html);
            }
            String xformMinusInstance = this.buildStringXForm(html);
            String preInstance = xformMinusInstance.substring(0, xformMinusInstance.indexOf("<instance>"));
            String instance = this.buildInstance(html.getHead().getModel(), crfVersion, crfSections);
            String nodeset = xformMinusInstance.substring(xformMinusInstance.indexOf("</instance>") + "</instance>".length());
            String postInstance = "<bind calculate=\"concat('uuid:', uuid())\" nodeset=\"/" + crfVersion.getOid() + "/meta/instanceID\" readonly=\"true()\" type=\"string\"/>" + nodeset;
            this.logger.debug(preInstance + "<instance>\n" + instance + "\n</instance>" + postInstance);
            System.out.println(preInstance + "<instance>\n" + instance + "\n</instance>" + postInstance);
            return preInstance + "<instance>\n" + instance + "\n</instance>" + postInstance;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception(e);
        }
    }

    private ArrayList<ItemGroupBean> getItemGroupBeans(SectionBean section) throws Exception {
        ArrayList itemGroupBeans = null;
        this.igdao = new ItemGroupDAO(this.dataSource);
        itemGroupBeans = (ArrayList)this.igdao.findGroupBySectionId(section.getId());
        return itemGroupBeans;
    }

    private ArrayList<ItemGroupBean> getItemGroupBeansByCrfVersion(CRFVersionBean crfVersion) throws Exception {
        ArrayList itemGroupBeans = null;
        this.igdao = new ItemGroupDAO(this.dataSource);
        itemGroupBeans = (ArrayList)this.igdao.findGroupByCRFVersionID(crfVersion.getId());
        return itemGroupBeans;
    }

    private ItemGroupBean getItemGroupBeanByItemId(Integer itemId) {
        ArrayList itemGroupBean = null;
        this.igdao = new ItemGroupDAO(this.dataSource);
        itemGroupBean = (ArrayList)this.igdao.findGroupsByItemID(itemId.intValue());
        return (ItemGroupBean)itemGroupBean.get(0);
    }

    private SectionBean getSectionBean(Integer ID) {
        this.sdao = new SectionDAO(this.dataSource);
        SectionBean sBean = (SectionBean)this.sdao.findByPK(ID.intValue());
        return sBean;
    }

    private ItemBean getItemBean(String itemOid) {
        ArrayList itemBean = null;
        this.idao = new ItemDAO(this.dataSource);
        itemBean = (ArrayList)this.idao.findByOid(itemOid);
        return (ItemBean)itemBean.get(0);
    }

    private ItemBean getItemBean(int itemId) {
        ItemBean itemBean = null;
        this.idao = new ItemDAO(this.dataSource);
        itemBean = (ItemBean)this.idao.findByPK(itemId);
        return itemBean;
    }

    private ItemFormMetadataBean getItemFormMetadataBeanById(Integer id) throws OpenClinicaException {
        this.itemFormMetadataDAO = new ItemFormMetadataDAO(this.dataSource);
        ItemFormMetadataBean itemFormMetadataBean = (ItemFormMetadataBean)this.itemFormMetadataDAO.findByPK(id.intValue());
        return itemFormMetadataBean;
    }

    private ItemFormMetadataBean getItemFormMetadata(ItemBean item, CRFVersionBean crfVersion) throws Exception {
        ItemFormMetadataBean itemFormMetadataBean = null;
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.dataSource);
        itemFormMetadataBean = ifmdao.findByItemIdAndCRFVersionId(item.getId(), crfVersion.getId());
        return itemFormMetadataBean;
    }

    private ItemGroupMetadataBean getItemGroupMetadata(ItemGroupBean itemGroupBean, CRFVersionBean crfVersion, SectionBean section) throws Exception {
        ArrayList itemGroupMetadataBean = null;
        ItemGroupMetadataDAO itemGroupMetadataDAO = new ItemGroupMetadataDAO(this.dataSource);
        itemGroupMetadataBean = (ArrayList)itemGroupMetadataDAO.findMetaByGroupAndSection(itemGroupBean.getId(), crfVersion.getId(), section.getId());
        return (ItemGroupMetadataBean)itemGroupMetadataBean.get(0);
    }

    private ItemGroupMetadataBean getItemGroupMetadataByGroup(ItemGroupBean itemGroupBean, CRFVersionBean crfVersion) throws Exception {
        ArrayList itemGroupMetadataBean = null;
        ItemGroupMetadataDAO itemGroupMetadataDAO = new ItemGroupMetadataDAO(this.dataSource);
        itemGroupMetadataBean = (ArrayList)itemGroupMetadataDAO.findMetaByGroupAndCrfVersion(itemGroupBean.getId(), crfVersion.getId());
        return (ItemGroupMetadataBean)itemGroupMetadataBean.get(0);
    }

    private ArrayList<PropertyBean> getItemGroupPropertyBean(String itemOid, String groupOid) {
        ArrayList propertyBeans = null;
        propertyBeans = this.getRuleActionPropertyDao().findByOid(itemOid, groupOid);
        return propertyBeans;
    }

    private ArrayList<PropertyBean> getGroupPropertyBean(String groupOid) {
        ArrayList propertyBeans = null;
        propertyBeans = this.getRuleActionPropertyDao().findByOid(groupOid);
        return propertyBeans;
    }

    private ExpressionExpressionEvaluate getSkipPattern(ItemBean itemBean, ItemGroupBean itemGroupBean) {
        ExpressionExpressionEvaluate eev = new ExpressionExpressionEvaluate();
        boolean expressionEvaluate = true;
        String expression = null;
        ExpressionBean expressionBean = null;
        ArrayList propertyBeans = null;
        propertyBeans = itemBean == null ? this.getGroupPropertyBean(itemGroupBean.getOid()) : this.getItemGroupPropertyBean(itemBean.getOid(), itemGroupBean.getOid());
        if (propertyBeans.size() != 0) {
            for (PropertyBean propertyBean : propertyBeans) {
                this.logger.info("property bean oid:   " + propertyBean.getOid());
                RuleActionBean ruleActionBean = propertyBean.getRuleActionBean();
                if (ruleActionBean.getActionType().getCode() != 3 || ruleActionBean.getRuleSetRule().getStatus().getCode() != 1) continue;
                expressionBean = ruleActionBean.getRuleSetRule().getRuleBean().getExpression();
                expressionEvaluate = ruleActionBean.getExpressionEvaluatesTo();
                this.logger.info("    ExpressionBean:   " + expressionBean.getValue());
                if (expression != null) {
                    expression = expression + " and " + expressionBean.getValue();
                    continue;
                }
                expression = expressionBean.getValue();
            }
        }
        eev.setExpressionEvaluate(expressionEvaluate);
        eev.setExpression(expression);
        return eev;
    }

    private HashMap<String, Object> getGroupInfo(ItemGroupBean itemGroupBean, CRFVersionBean crfVersion, SectionBean section, WidgetFactory factory, ArrayList<Bind> bindList) throws Exception {
        boolean expressionEvaluate = true;
        this.igmdao = new ItemGroupMetadataDAO(this.dataSource);
        List itemGroupMetadata = this.igmdao.findMetaByGroupAndSection(itemGroupBean.getId(), crfVersion.getId(), section.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        Group group = new Group();
        Repeat repeat = new Repeat();
        group.setUsercontrol(new ArrayList());
        repeat.setUsercontrol(new ArrayList());
        Label groupHeader = new Label();
        groupHeader.setLabel(((ItemGroupMetadataBean)itemGroupMetadata.get(0)).getHeader());
        boolean isGroupRepeating = this.getItemGroupMetadata(itemGroupBean, crfVersion, section).isRepeatingGroup();
        String nodeset = "/" + crfVersion.getOid() + "/" + itemGroupBean.getOid();
        repeat.setJrCount(nodeset);
        group.setRef(nodeset);
        repeat.setNodeset(nodeset);
        String groupExpression = null;
        ExpressionExpressionEvaluate eev = this.getSkipPattern(null, itemGroupBean);
        groupExpression = eev.getExpression();
        expressionEvaluate = eev.isExpressionEvaluate();
        if (groupExpression != null) {
            groupExpression = this.getFullExpressionToParse(groupExpression, crfVersion, expressionEvaluate);
        }
        this.setGroupWidget(section, crfVersion, groupExpression, bindList, factory, itemGroupBean, group, repeat, isGroupRepeating, groupHeader);
        map.put("group", group);
        map.put("repeat", repeat);
        map.put("isGroupRepeating", isGroupRepeating);
        return map;
    }

    private void setFormPaging(Html html) {
        html.getBody().setCssClass("pages");
        List groups = html.getBody().getGroup();
        for (Group group : groups) {
            group.setAppearance("field-list");
        }
    }

    private Integer mapBeansToDTO(Html html, CRFBean crf, CRFVersionBean crfVersion, ArrayList<SectionBean> crfSections) throws Exception {
        boolean expressionEvaluate = true;
        int sectionCount = 0;
        ItemFormMetadataBean itemFormMetadataBean = null;
        Body body = html.getBody();
        ArrayList<Group> allSections = new ArrayList<Group>();
        ArrayList bindList = new ArrayList();
        WidgetFactory factory = new WidgetFactory(crfVersion);
        html.getHead().setTitle(crf.getName());
        for (SectionBean section : crfSections) {
            ArrayList<Group> groups = new ArrayList<Group>();
            Group singleSection = new Group();
            singleSection.setUsercontrol(new ArrayList());
            String ref = "/" + crfVersion.getOid() + "/SECTION_" + section.getLabel().replaceAll("\\W", "_");
            singleSection.setRef(ref);
            String sectionExpression = null;
            this.igdao = new ItemGroupDAO(this.dataSource);
            ArrayList groupBeans = (ArrayList)this.igdao.findGroupBySectionId(section.getId());
            int count = 0;
            if (groupBeans.size() > 0) {
                for (ItemGroupBean groupBean : groupBeans) {
                    ExpressionExpressionEvaluate eev = this.getSkipPattern(null, groupBean);
                    String expr = eev.getExpression();
                    expressionEvaluate = eev.isExpressionEvaluate();
                    if (expr == null) continue;
                    if (sectionExpression != null) {
                        sectionExpression = sectionExpression + " and " + expr;
                        ++count;
                        continue;
                    }
                    sectionExpression = expr;
                    ++count;
                }
                sectionExpression = sectionExpression != null && groupBeans.size() == count ? this.getFullExpressionToParse(sectionExpression, crfVersion, expressionEvaluate) : null;
                this.setSectionWidget(section, crfVersion, sectionExpression, bindList, factory, singleSection);
                HashMap groupMap = null;
                boolean isGroupRepeating = false;
                Group group = null;
                Repeat repeat = null;
                this.idao = new ItemDAO(this.dataSource);
                ArrayList items = this.idao.findAllBySectionIdOrderedByItemFormMetadataOrdinal(section.getId());
                Integer itemGroupId = 0;
                for (ItemBean item : items) {
                    ItemGroupBean itemGroupBean = this.getItemGroupBeanByItemId(Integer.valueOf(item.getId()));
                    if (itemGroupId.intValue() != itemGroupBean.getId()) {
                        groupMap = this.getGroupInfo(itemGroupBean, crfVersion, section, factory, bindList);
                        isGroupRepeating = (Boolean)groupMap.get("isGroupRepeating");
                        group = (Group)groupMap.get("group");
                        repeat = (Repeat)groupMap.get("repeat");
                    }
                    itemFormMetadataBean = this.getItemFormMetadata(item, crfVersion);
                    int responseTypeId = itemFormMetadataBean.getResponseSet().getResponseTypeId();
                    boolean isItemRequired = itemFormMetadataBean.isRequired();
                    String responseLayout = itemFormMetadataBean.getResponseLayout();
                    String itemExpression = null;
                    ExpressionExpressionEvaluate eev = this.getSkipPattern(item, itemGroupBean);
                    itemExpression = eev.getExpression();
                    expressionEvaluate = eev.isExpressionEvaluate();
                    if (itemExpression != null) {
                        itemExpression = this.getFullExpressionToParse(itemExpression, crfVersion, expressionEvaluate);
                    }
                    this.setHeaderWidget(item, itemFormMetadataBean, itemGroupBean, bindList, factory, isGroupRepeating, repeat, group, itemExpression);
                    this.setSubHeaderWidget(item, itemFormMetadataBean, itemGroupBean, bindList, factory, isGroupRepeating, repeat, group, itemExpression);
                    this.setItemWidget(item, responseTypeId, itemFormMetadataBean, itemGroupBean, bindList, factory, isGroupRepeating, repeat, group, isItemRequired, responseLayout, itemExpression);
                    if (itemGroupId.intValue() == itemGroupBean.getId()) continue;
                    groups.add(group);
                    itemGroupId = itemGroupBean.getId();
                }
                singleSection.setGroup(groups);
                allSections.add(singleSection);
            }
            sectionCount = allSections.size();
        }
        body.setGroup(allSections);
        html.getHead().getModel().setBind(bindList);
        return sectionCount;
    }

    private String buildInstance(Model model, CRFVersionBean crfVersion, ArrayList<SectionBean> crfSections) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder build = docFactory.newDocumentBuilder();
        Document doc = build.newDocument();
        Element crfElement = doc.createElement(crfVersion.getOid());
        crfElement.setAttribute("id", crfVersion.getOid());
        doc.appendChild(crfElement);
        crfElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jr", "http://openrosa.org/javarosa");
        for (SectionBean sectionBean : crfSections) {
            Element sectionSubTitle = doc.createElement("SECTION_" + sectionBean.getId() + ".SUBTITLE");
            Element sectionInstructions = doc.createElement("SECTION_" + sectionBean.getId() + ".INSTRUCTIONS");
            Element sectionElm = doc.createElement("SECTION_" + sectionBean.getLabel().replaceAll("\\W", "_"));
            crfElement.appendChild(sectionSubTitle);
            crfElement.appendChild(sectionInstructions);
            crfElement.appendChild(sectionElm);
        }
        ArrayList itemGroupBeans = this.getItemGroupBeansByCrfVersion(crfVersion);
        for (ItemGroupBean itemGroupBean : itemGroupBeans) {
            ItemGroupMetadataBean itemGroupMetadataBean = this.getItemGroupMetadataByGroup(itemGroupBean, crfVersion);
            String repeatGroupMin = itemGroupMetadataBean.getRepeatNum().toString();
            Boolean isrepeating = itemGroupMetadataBean.isRepeatingGroup();
            Element groupElement = doc.createElement(itemGroupBean.getOid());
            if (isrepeating.booleanValue()) {
                groupElement.setTextContent(repeatGroupMin);
                groupElement.setAttribute("jr:template", "");
                Element hiddenOrdinalItem = doc.createElement("OC.REPEAT_ORDINAL");
                groupElement.appendChild(hiddenOrdinalItem);
            }
            crfElement.appendChild(groupElement);
            this.idao = new ItemDAO(this.dataSource);
            ArrayList items = (ArrayList)this.idao.findAllItemsByGroupIdOrdered(itemGroupBean.getId(), crfVersion.getId());
            for (ItemBean item : items) {
                ItemFormMetadataBean itemMetaData = this.getItemFormMetadata(item, crfVersion);
                if (itemMetaData.getHeader() != null && !itemMetaData.getHeader().equals("")) {
                    Element header = doc.createElement(item.getOid() + ".HEADER");
                    groupElement.appendChild(header);
                }
                if (itemMetaData.getHeader() != null && !itemMetaData.getSubHeader().equals("")) {
                    Element subHeader = doc.createElement(item.getOid() + ".SUBHEADER");
                    groupElement.appendChild(subHeader);
                }
                Element question = doc.createElement(item.getOid());
                groupElement.appendChild(question);
            }
        }
        Element element = doc.createElement("meta");
        Element instanceId = doc.createElement("instanceID");
        element.appendChild(instanceId);
        crfElement.appendChild(element);
        TransformerFactory transformFactory = TransformerFactory.newInstance();
        Transformer transformer = transformFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return writer.toString();
    }

    private void setDefaultElement(ItemBean item, CRFVersionBean crfVersion, Element question) throws Exception {
        Integer responseTypeId = this.getItemFormMetadata(item, crfVersion).getResponseSet().getResponseTypeId();
        if (responseTypeId == 3 || responseTypeId == 7) {
            String defaultValue = this.getItemFormMetadata(item, crfVersion).getDefaultValue();
            defaultValue = defaultValue.replace(" ", "");
            defaultValue = defaultValue.replace(",", " ");
            question.setTextContent(defaultValue);
        } else {
            question.setTextContent(this.getItemFormMetadata(item, crfVersion).getDefaultValue());
        }
    }

    private Html buildJavaXForm(String content) throws Exception {
        StringReader reader = new StringReader(content);
        Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
        unmarshaller.setClass(Html.class);
        unmarshaller.setWhitespacePreserve(false);
        Html html = (Html)unmarshaller.unmarshal((Reader)reader);
        ((Reader)reader).close();
        return html;
    }

    private String buildStringXForm(Html html) throws Exception {
        StringWriter writer = new StringWriter();
        Marshaller marshaller = this.xmlContext.createMarshaller();
        marshaller.setNamespaceMapping("h", "http://www.w3.org/1999/xhtml");
        marshaller.setNamespaceMapping("jr", "http://openrosa.org/javarosa");
        marshaller.setNamespaceMapping("xsd", "http://www.w3.org/2001/XMLSchema");
        marshaller.setNamespaceMapping("ev", "http://www.w3.org/2001/xml-events");
        marshaller.setNamespaceMapping("", "http://www.w3.org/2002/xforms");
        marshaller.setProperty("org.exolab.castor.indent", "false");
        marshaller.setWriter((Writer)writer);
        marshaller.marshal((Object)html);
        String xform = writer.toString();
        return xform;
    }

    private String getFullExpressionToParse(String expression, CRFVersionBean version, boolean expressionEvaluates) throws Exception {
        String result = "";
        expression = " " + expression;
        expression = expression.replaceAll("\\(", "\\( ");
        expression = expression.replaceAll("_CURRENT_DATE", "today()");
        expression = expression.replaceAll(" I_", " ../I_");
        expression = expression.replaceAll("\\S*/I_", " ../I_");
        expression = expression.replaceAll(" eq ", " = ");
        expression = expression.replaceAll(" ct ", " = ");
        expression = expression.replaceAll(" ne ", " != ");
        expression = expression.replaceAll(" gt ", " > ");
        expression = expression.replaceAll(" gte ", " >= ");
        expression = expression.replaceAll(" lt ", " < ");
        expression = expression.replaceAll(" lte ", " <= ");
        if (!expressionEvaluates) {
            expression = "not(" + expression + ")";
        }
        String[] exprs = expression.split(" ");
        boolean byPass = false;
        String tempExpr = "";
        for (String expr : exprs) {
            if (expr.contains("../I_")) {
                String itemOid = expr.substring(3);
                this.logger.info("itemOid:  " + itemOid);
                ItemBean itemBean = this.getItemBean(itemOid);
                ItemGroupBean itemGroupBean = this.getItemGroupBeanByItemId(Integer.valueOf(itemBean.getId()));
                this.itemFormMetadataDAO = new ItemFormMetadataDAO(this.dataSource);
                ItemFormMetadataBean ifmBean = this.itemFormMetadataDAO.findByItemIdAndCRFVersionId(itemBean.getId(), version.getId());
                if (ifmBean.getResponseSet().getResponseTypeId() == 3 || ifmBean.getResponseSet().getResponseTypeId() == 7) {
                    byPass = true;
                    tempExpr = expr;
                }
                expr = "/" + version.getOid() + "/" + itemGroupBean.getOid() + "/" + itemOid;
            }
            if (byPass && tempExpr.contains("../I_")) {
                tempExpr = expr;
                continue;
            }
            if (byPass && expr.equals("=")) {
                tempExpr = "selected (" + tempExpr + " , ";
                continue;
            }
            if (byPass && expr.equals("!=")) {
                tempExpr = " not selected (" + tempExpr + " , ";
                continue;
            }
            if (byPass && (expr.equals(">") || expr.equals(">=") || expr.equals("<") || expr.equals("<="))) {
                tempExpr = tempExpr + " " + expr;
                result = result + " " + tempExpr;
                byPass = false;
                continue;
            }
            if (!(!byPass || expr.contains("../I_") || expr.equals("!=") || expr.equals("=") || expr.equals(">") || expr.equals(">=") || expr.equals("<") || expr.equals("<="))) {
                tempExpr = tempExpr + " " + expr + " ) ";
                result = result + " " + tempExpr;
                byPass = false;
                continue;
            }
            result = result + " " + expr;
        }
        this.logger.info("Full Expression is:  " + result);
        return result;
    }

    private void setHeaderWidget(ItemBean item, ItemFormMetadataBean itemFormMetadataBean, ItemGroupBean itemGroupBean, ArrayList<Bind> bindList, WidgetFactory factory, boolean isGroupRepeating, Repeat repeat, Group group, String itemExpression) {
        Widget headerWidget = factory.getHeaderWidget(item, itemFormMetadataBean, itemGroupBean, itemExpression);
        if (headerWidget != null) {
            bindList.add(headerWidget.getBinding());
            if (isGroupRepeating) {
                repeat.getUsercontrol().add(headerWidget.getUserControl());
            } else {
                group.getUsercontrol().add(headerWidget.getUserControl());
            }
        } else {
            this.log.debug("Invalid/Missing instructive header text encountered while loading PForm (" + item.getDataType().getName() + "). Skipping.");
        }
    }

    private void setSubHeaderWidget(ItemBean item, ItemFormMetadataBean itemFormMetadataBean, ItemGroupBean itemGroupBean, ArrayList<Bind> bindList, WidgetFactory factory, boolean isGroupRepeating, Repeat repeat, Group group, String itemExpression) {
        Widget subHeaderWidget = factory.getSubHeaderWidget(item, itemFormMetadataBean, itemGroupBean, itemExpression);
        if (subHeaderWidget != null) {
            bindList.add(subHeaderWidget.getBinding());
            if (isGroupRepeating) {
                repeat.getUsercontrol().add(subHeaderWidget.getUserControl());
            } else {
                group.getUsercontrol().add(subHeaderWidget.getUserControl());
            }
        } else {
            this.log.debug("Invalid/Missing instructive subheader text encountered while loading PForm (" + item.getDataType().getName() + "). Skipping.");
        }
    }

    private void setItemWidget(ItemBean item, int responseTypeId, ItemFormMetadataBean itemFormMetadataBean, ItemGroupBean itemGroupBean, ArrayList<Bind> bindList, WidgetFactory factory, boolean isGroupRepeating, Repeat repeat, Group group, boolean isItemRequired, String responseLayout, String itemExpression) {
        Widget widget = factory.getItemWidget(item, Integer.valueOf(responseTypeId), itemGroupBean, itemFormMetadataBean, isItemRequired, responseLayout, itemExpression);
        if (widget != null) {
            bindList.add(widget.getBinding());
            if (isGroupRepeating) {
                repeat.getUsercontrol().add(widget.getUserControl());
                group.setRepeat(repeat);
            } else {
                group.getUsercontrol().add(widget.getUserControl());
            }
        } else {
            this.log.debug("Unsupported datatype encountered while loading PForm (" + item.getDataType().getName() + "). Skipping.");
        }
    }

    private void setSectionWidget(SectionBean section, CRFVersionBean crfVersion, String sectionExpression, ArrayList<Bind> bindList, WidgetFactory factory, Group singleSection) {
        Widget sectionWidget = factory.getSectionWidget(section, crfVersion, sectionExpression);
        bindList.add(sectionWidget.getBinding());
        if (section.getTitle() != null && !section.getTitle().equals("")) {
            Label sectionLabel = new Label();
            sectionLabel.setLabel(section.getTitle());
            singleSection.setLabel(sectionLabel);
        }
        singleSection.setGroup(new ArrayList());
        Widget subtitle = factory.getSectionTextWidget(crfVersion.getOid(), "SUBTITLE", section);
        Widget instructions = factory.getSectionTextWidget(crfVersion.getOid(), "INSTRUCTIONS", section);
        if (subtitle != null) {
            singleSection.getUsercontrol().add(subtitle.getUserControl());
            bindList.add(subtitle.getBinding());
        }
        if (instructions != null) {
            singleSection.getUsercontrol().add(instructions.getUserControl());
            bindList.add(instructions.getBinding());
        }
    }

    private void setGroupWidget(SectionBean section, CRFVersionBean crfVersion, String groupExpression, ArrayList<Bind> bindList, WidgetFactory factory, ItemGroupBean itemGroupBean, Group group, Repeat repeat, boolean isGroupRepeating, Label groupHeader) {
        Widget groupWidget = factory.getGroupWidget(itemGroupBean, crfVersion, groupExpression);
        bindList.add(groupWidget.getBinding());
        if (groupWidget != null) {
            if (isGroupRepeating) {
                repeat.setLabel(groupHeader);
            } else {
                group.setLabel(groupHeader);
            }
        }
    }

    public RuleActionPropertyDao getRuleActionPropertyDao() {
        return this.ruleActionPropertyDao;
    }

    public void setRuleActionPropertyDao(RuleActionPropertyDao ruleActionPropertyDao) {
        this.ruleActionPropertyDao = ruleActionPropertyDao;
    }
}

