/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform;

import java.util.HashMap;
import javax.servlet.ServletContext;
import org.akaza.openclinica.web.pform.EnketoAPI;
import org.akaza.openclinica.web.pform.EnketoCredentials;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;

public class PFormCache {
    HashMap<String, HashMap<String, String>> urlCache = null;
    HashMap<String, HashMap<String, String>> offlineUrlCache = null;
    HashMap<String, HashMap<String, String>> subjectContextCache = null;

    private PFormCache() {
    }

    private PFormCache(ServletContext context) {
        this.urlCache = (HashMap)context.getAttribute("pformURLCache");
        this.offlineUrlCache = (HashMap)context.getAttribute("pformOfflineURLCache");
        this.subjectContextCache = (HashMap)context.getAttribute("subjectContextCache");
        if (this.urlCache == null) {
            this.urlCache = new HashMap();
            context.setAttribute("pformURLCache", (Object)this.urlCache);
        }
        if (this.offlineUrlCache == null) {
            this.offlineUrlCache = new HashMap();
            context.setAttribute("pformOfflineURLCache", (Object)this.offlineUrlCache);
        }
        if (this.subjectContextCache == null) {
            this.subjectContextCache = new HashMap();
            context.setAttribute("subjectContextCache", (Object)this.subjectContextCache);
        }
    }

    public static PFormCache getInstance(ServletContext context) throws Exception {
        return new PFormCache(context);
    }

    public String getPFormURL(String studyOID, String crfVersionOID) throws Exception {
        return this.getPFormURL(studyOID, crfVersionOID, false);
    }

    public String getPFormURL(String studyOID, String crfVersionOID, boolean isOffline) throws Exception {
        EnketoAPI enketo = new EnketoAPI(EnketoCredentials.getInstance((String)studyOID));
        HashMap<String, String> studyURLs = null;
        studyURLs = isOffline ? (HashMap<String, String>)this.offlineUrlCache.get(studyOID) : (HashMap)this.urlCache.get(studyOID);
        if (studyURLs == null) {
            studyURLs = new HashMap<String, String>();
            String url = null;
            url = isOffline ? enketo.getOfflineFormURL(crfVersionOID) : enketo.getFormURL(crfVersionOID);
            if (url.equals("")) {
                throw new Exception("Unable to get enketo form url.");
            }
            studyURLs.put(crfVersionOID, url);
            if (isOffline) {
                this.offlineUrlCache.put(studyOID, studyURLs);
            } else {
                this.urlCache.put(studyOID, studyURLs);
            }
            return url;
        }
        if (studyURLs.get(crfVersionOID) == null) {
            String url = null;
            url = isOffline ? enketo.getOfflineFormURL(crfVersionOID) : enketo.getFormURL(crfVersionOID);
            studyURLs.put(crfVersionOID, url);
            return url;
        }
        return (String)studyURLs.get(crfVersionOID);
    }

    public HashMap<String, String> getSubjectContext(String key) throws Exception {
        return (HashMap)this.subjectContextCache.get(key);
    }

    public String putSubjectContext(String studySubjectOID, String studyEventDefinitionID, String studyEventOrdinal, String crfVersionOID) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("studySubjectOID", studySubjectOID);
        contextMap.put("studyEventDefinitionID", studyEventDefinitionID);
        contextMap.put("studyEventOrdinal", studyEventOrdinal);
        contextMap.put("crfVersionOID", crfVersionOID);
        String hashString = studySubjectOID + "." + studyEventDefinitionID + "." + studyEventOrdinal + "." + crfVersionOID;
        ShaPasswordEncoder encoder = new ShaPasswordEncoder(256);
        String hashOutput = encoder.encodePassword(hashString, null);
        this.subjectContextCache.put(hashOutput, contextMap);
        return hashOutput;
    }

    public String putAnonymousFormContext(String studyOID, String crfVersionOID, int studyEventDefinitionId) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("studySubjectOID", null);
        contextMap.put("studyOID", studyOID);
        contextMap.put("crfVersionOID", crfVersionOID);
        contextMap.put("studyEventDefinitionID", String.valueOf(studyEventDefinitionId));
        contextMap.put("studyEventOrdinal", "1");
        String hashString = studyOID + "." + crfVersionOID;
        ShaPasswordEncoder encoder = new ShaPasswordEncoder(256);
        String hashOutput = encoder.encodePassword(hashString, null);
        this.subjectContextCache.put(hashOutput, contextMap);
        return hashOutput;
    }
}

