/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform.widget;

import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.web.pform.dto.Bind;
import org.akaza.openclinica.web.pform.dto.Input;
import org.akaza.openclinica.web.pform.dto.Label;
import org.akaza.openclinica.web.pform.dto.UserControl;
import org.akaza.openclinica.web.pform.widget.BaseWidget;

public class InputWidget
extends BaseWidget {
    private ItemBean item = null;
    private CRFVersionBean version = null;
    private String appearance = null;
    private ItemGroupBean itemGroupBean = null;
    private ItemFormMetadataBean itemFormMetadataBean = null;
    private boolean isItemRequired;
    private String expression;

    public InputWidget(CRFVersionBean version, ItemBean item, String appearance, ItemGroupBean itemGroupBean, ItemFormMetadataBean itemFormMetadataBean, boolean isItemRequired, String expression) {
        this.item = item;
        this.version = version;
        this.itemGroupBean = itemGroupBean;
        this.itemFormMetadataBean = itemFormMetadataBean;
        this.isItemRequired = isItemRequired;
        this.appearance = appearance;
        this.expression = expression;
    }

    public UserControl getUserControl() {
        Input input = new Input();
        Label label = new Label();
        label.setLabel(this.itemFormMetadataBean.getLeftItemText());
        input.setLabel(label);
        if (this.appearance != null) {
            input.setAppearance(this.appearance);
        }
        input.setRef("/" + this.version.getOid() + "/" + this.itemGroupBean.getOid() + "/" + this.item.getOid());
        return input;
    }

    public Bind getBinding() {
        String relevant = null;
        Bind binding = new Bind();
        binding.setNodeSet("/" + this.version.getOid() + "/" + this.itemGroupBean.getOid() + "/" + this.item.getOid());
        Integer responseTypeId = this.itemFormMetadataBean.getResponseSet().getResponseTypeId();
        if (responseTypeId == 8 || responseTypeId == 9) {
            binding.setReadOnly("true()");
        }
        if ((relevant = this.expression) != null) {
            binding.setRelevant(relevant);
        }
        binding.setType(this.getDataType(this.item));
        if (this.isItemRequired) {
            binding.setRequired("true()");
        }
        return binding;
    }
}

