/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.restful;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONClinicalDataPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONClinicalDataPostProcessor.class);
    private static final DateFormat DATE_INTERNAL_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DATE_TIME_INTERNAL_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat DATE_TIME_AUDIT_LOG_INTERNAL_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String DATE_FORMAT_KEY = "date_format_string";
    private static final String DATE_TIME_FORMAT_KEY = "date_time_format_string";
    private static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]");
    private static final Pattern DATE_TIME_AUDIT_LOG_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}");
    private final Locale locale;
    private final ResourceBundle formatResourceBundle;

    public JSONClinicalDataPostProcessor(Locale locale) {
        this.locale = locale;
        this.formatResourceBundle = ResourceBundleProvider.getFormatBundle((Locale)locale);
    }

    public void process(JSON json) {
        this.processJSONFields(json);
    }

    private void processJSONFields(JSON json) {
        if (json instanceof JSONArray) {
            this.processJSONArray((JSONArray)json);
        } else if (json instanceof JSONObject) {
            this.processJSONObject((JSONObject)json);
        }
    }

    private JSON processJSONArray(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object elem = jsonArray.get(i);
            if (elem instanceof JSONArray) {
                this.processJSONArray((JSONArray)elem);
                continue;
            }
            if (elem instanceof JSONObject) {
                this.processJSONObject((JSONObject)elem);
                continue;
            }
            if (!(elem instanceof String)) continue;
            jsonArray.set(i, (Object)this.processString((String)elem));
        }
        return jsonArray;
    }

    private JSON processJSONObject(JSONObject jsonObject) {
        for (Object key : jsonObject.keySet()) {
            Object elem = jsonObject.get(key);
            if (elem instanceof JSONArray) {
                this.processJSONArray((JSONArray)elem);
                continue;
            }
            if (elem instanceof JSONObject) {
                this.processJSONObject((JSONObject)elem);
                continue;
            }
            if (!(elem instanceof String)) continue;
            jsonObject.put(key, (Object)this.processString((String)elem));
        }
        return jsonObject;
    }

    private String processString(String elem) {
        boolean isShort = DATE_PATTERN.matcher(elem).matches();
        boolean isLong = DATE_TIME_PATTERN.matcher(elem).matches();
        boolean isAudit = DATE_TIME_AUDIT_LOG_PATTERN.matcher(elem).matches();
        if (isShort || isLong || isAudit) {
            try {
                SimpleDateFormat formatter;
                Date date;
                if (isShort) {
                    date = DATE_INTERNAL_FORMAT.parse(elem);
                    formatter = new SimpleDateFormat(this.formatResourceBundle.getString(DATE_FORMAT_KEY), this.locale);
                } else if (isLong) {
                    date = DATE_TIME_INTERNAL_FORMAT.parse(elem);
                    formatter = new SimpleDateFormat(this.formatResourceBundle.getString(DATE_TIME_FORMAT_KEY), this.locale);
                } else {
                    date = DATE_TIME_AUDIT_LOG_INTERNAL_FORMAT.parse(elem);
                    formatter = new SimpleDateFormat(this.formatResourceBundle.getString(DATE_TIME_FORMAT_KEY), this.locale);
                }
                return formatter.format(date);
            }
            catch (ParseException e) {
                LOG.warn("Could not parse date from ODM element '" + elem + "'", (Throwable)e);
            }
        }
        return elem;
    }
}

