/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.restful;

import com.sun.jersey.api.view.Viewable;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateExceptionHandler;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.akaza.openclinica.web.restful.MetadataCollectorResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/metadata")
@Component
@Scope(value="prototype")
public class ODMMetadataRestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ODMMetadataRestResource.class);
    private MetadataCollectorResource metadataCollectorResource;

    public MetadataCollectorResource getMetadataCollectorResource() {
        return this.metadataCollectorResource;
    }

    public void setMetadataCollectorResource(MetadataCollectorResource metadataCollectorResource) {
        this.metadataCollectorResource = metadataCollectorResource;
    }

    @GET
    @Path(value="/xml/view/{studyOID}")
    @Produces(value={"text/xml"})
    public String getODMMetadata(@PathParam(value="studyOID") String studyOID) {
        LOGGER.debug("returning here........" + studyOID);
        return this.metadataCollectorResource.collectODMMetadata(studyOID);
    }

    @GET
    @Path(value="/json/view/{studyOID}")
    @Produces(value={"application/json"})
    public String getODMMetadataJson(@PathParam(value="studyOID") String studyOID) {
        LOGGER.debug("returning here........" + studyOID);
        return this.metadataCollectorResource.collectODMMetadataJson(studyOID);
    }

    @GET
    @Path(value="/html/print/{studyOID}/{eventOID}/{formVersionOID}")
    public Viewable getPrintCRFController(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @PathParam(value="eventOID") String eventOID, @PathParam(value="formVersionOID") String formVersionOID) throws Exception {
        request.setAttribute("studyOID", (Object)studyOID);
        request.setAttribute("eventOID", (Object)eventOID);
        request.setAttribute("formVersionOID", (Object)formVersionOID);
        return new Viewable("/WEB-INF/jsp/printcrf.jsp", null);
    }

    @GET
    @Path(value="/xml/view/{studyOID}/{studyEventDefinitionOId}/{formVersionOID}")
    @Produces(value={"text/xml"})
    public String getODMMetadataWithFormVersionOID(@PathParam(value="studyOID") String studyOID, @PathParam(value="formVersionOID") String formVersionOID) {
        LOGGER.debug("returning here........" + formVersionOID);
        return this.metadataCollectorResource.collectODMMetadataForForm(studyOID, formVersionOID);
    }

    @GET
    @Path(value="/json/view/{studyOID}/{studyEventDefinitionOId}/{formVersionOID}")
    @Produces(value={"application/json"})
    public String getODMMetadataJson(@PathParam(value="studyOID") String studyOID, @PathParam(value="formVersionOID") String formVersionOID) {
        LOGGER.debug("returning here........" + formVersionOID);
        return this.metadataCollectorResource.collectODMMetadataJsonString(studyOID, formVersionOID);
    }

    private Configuration initFreemarker(ServletContext context) {
        Configuration cfg = new Configuration();
        cfg.setServletContextForTemplateLoading((Object)context, "WEB-INF/template");
        cfg.setTemplateUpdateDelay(0);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        cfg.setDefaultEncoding("ISO-8859-1");
        cfg.setOutputEncoding("UTF-8");
        cfg.setLocale(Locale.US);
        return cfg;
    }
}

