/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.crfdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemBeanWrapper;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.rulerunner.ExecutionMode;
import org.akaza.openclinica.logic.rulerunner.ImportDataRuleRunnerContainer;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.web.crfdata.ImportCRFDataService;
import org.akaza.openclinica.web.job.CrfBusinessLogicHelper;
import org.akaza.openclinica.web.job.TriggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;

public class DataImportService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    ResourceBundle respage;
    Locale locales;
    private ImportCRFDataService dataService;

    public ResourceBundle getRespage() {
        return this.respage;
    }

    public void setRespage(ResourceBundle respage) {
        this.respage = respage;
    }

    public Locale getLocale() {
        if (this.locales == null) {
            this.locales = new Locale("en-US");
        }
        return this.locales;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = new Locale("en-us");
        }
        this.locales = locale;
    }

    public List<String> validateMetaData(ODMContainer odmContainer, DataSource dataSource, CoreResources resources, StudyBean studyBean, UserAccountBean userBean, List<DisplayItemBeanWrapper> displayItemBeanWrappers, HashMap<Integer, String> importedCRFStatuses) {
        this.logger.debug("passing an odm container and study bean id: " + studyBean.getId());
        List errors = this.getImportCRFDataService(dataSource).validateStudyMetadata(odmContainer, studyBean.getId());
        if (errors == null) {
            return new ArrayList<String>();
        }
        return errors;
    }

    public List<String> validateData(ODMContainer odmContainer, DataSource dataSource, CoreResources resources, StudyBean studyBean, UserAccountBean userBean, List<DisplayItemBeanWrapper> displayItemBeanWrappers, HashMap<Integer, String> importedCRFStatuses) {
        ResourceBundle respage = ResourceBundleProvider.getPageMessagesBundle();
        this.setRespage(respage);
        TriggerService triggerService = new TriggerService();
        StringBuffer auditMsg = new StringBuffer();
        ArrayList<String> errors = new ArrayList<String>();
        auditMsg.append(respage.getString("passed_study_check") + " ");
        auditMsg.append(respage.getString("passed_oid_metadata_check") + " ");
        Boolean eventCRFStatusesValid = this.getImportCRFDataService(dataSource).eventCRFStatusesValid(odmContainer, userBean);
        List eventCRFBeans = this.getImportCRFDataService(dataSource).fetchEventCRFBeans(odmContainer, userBean);
        this.getImportCRFDataService(dataSource).fetchEventCRFStatuses(odmContainer, importedCRFStatuses);
        ArrayList<Integer> permittedEventCRFIds = new ArrayList<Integer>();
        if (eventCRFBeans == null) {
            errors.add(respage.getString("the_event_crf_not_correct_status"));
            return errors;
        }
        if (eventCRFBeans.isEmpty() && !eventCRFStatusesValid.booleanValue()) {
            errors.add(respage.getString("the_event_crf_not_correct_status"));
            return errors;
        }
        if (eventCRFBeans.isEmpty()) {
            errors.add(respage.getString("no_event_crfs_matching_the_xml_metadata"));
            return errors;
        }
        this.logger.debug("found a list of eventCRFBeans: " + eventCRFBeans.toString());
        for (EventCRFBean eventCRFBean : eventCRFBeans) {
            DataEntryStage dataEntryStage = eventCRFBean.getStage();
            Status eventCRFStatus = eventCRFBean.getStatus();
            this.logger.debug("Event CRF Bean: id " + eventCRFBean.getId() + ", data entry stage " + dataEntryStage.getName() + ", status " + eventCRFStatus.getName());
            if (eventCRFStatus.equals((Term)Status.AVAILABLE) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                permittedEventCRFIds.add(new Integer(eventCRFBean.getId()));
                continue;
            }
            errors.add(respage.getString("your_listed_crf_in_the_file") + " " + eventCRFBean.getEventName());
        }
        if (eventCRFBeans.size() >= permittedEventCRFIds.size()) {
            auditMsg.append(respage.getString("passed_event_crf_status_check") + " ");
        } else {
            auditMsg.append(respage.getString("the_event_crf_not_correct_status") + " ");
        }
        HashMap totalValidationErrors = new HashMap();
        HashMap hardValidationErrors = new HashMap();
        try {
            List tempDisplayItemBeanWrappers = new ArrayList();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addPreferredLocale(this.getLocale());
            tempDisplayItemBeanWrappers = this.getImportCRFDataService(dataSource).lookupValidationErrors((HttpServletRequest)request, odmContainer, userBean, totalValidationErrors, hardValidationErrors, permittedEventCRFIds);
            displayItemBeanWrappers.addAll(tempDisplayItemBeanWrappers);
            this.logger.debug("size of total validation errors: " + (totalValidationErrors.size() + hardValidationErrors.size()));
            ArrayList subjectData = odmContainer.getCrfDataPostImportContainer().getSubjectData();
            if (!hardValidationErrors.isEmpty()) {
                errors.add(triggerService.generateHardValidationErrorMessage(subjectData, hardValidationErrors, "1"));
            }
            if (!totalValidationErrors.isEmpty()) {
                errors.add(triggerService.generateHardValidationErrorMessage(subjectData, totalValidationErrors, "1"));
            }
        }
        catch (NullPointerException npe1) {
            npe1.printStackTrace();
            errors.add(respage.getString("an_error_was_thrown_while_validation_errors"));
            this.logger.debug("=== threw the null pointer, import === " + npe1.getMessage());
        }
        catch (OpenClinicaException oce1) {
            errors.add(oce1.getOpenClinicaMessage());
            this.logger.debug("=== threw the openclinica message, import === " + oce1.getOpenClinicaMessage());
        }
        auditMsg.append(respage.getString("passing_crf_edit_checks") + " ");
        return errors;
    }

    public ArrayList<String> submitData(ODMContainer odmContainer, DataSource dataSource, StudyBean studyBean, UserAccountBean userBean, List<DisplayItemBeanWrapper> displayItemBeanWrappers, Map<Integer, String> importedCRFStatuses) throws Exception {
        boolean discNotesGenerated = false;
        ItemDataDAO itemDataDao = new ItemDataDAO(dataSource);
        itemDataDao.setFormatDates(false);
        EventCRFDAO eventCrfDao = new EventCRFDAO(dataSource);
        StringBuffer auditMsg = new StringBuffer();
        int eventCrfBeanId = -1;
        EventCRFBean eventCrfBean = null;
        CrfBusinessLogicHelper crfBusinessLogicHelper = new CrfBusinessLogicHelper(dataSource);
        for (DisplayItemBeanWrapper wrapper : displayItemBeanWrappers) {
            boolean resetSDV = false;
            this.logger.debug("right before we check to make sure it is savable: " + wrapper.isSavable());
            if (!wrapper.isSavable()) continue;
            ArrayList<Integer> eventCrfInts = new ArrayList<Integer>();
            this.logger.debug("wrapper problems found : " + wrapper.getValidationErrors().toString());
            if (wrapper.getDisplayItemBeans() != null && wrapper.getDisplayItemBeans().size() == 0) {
                return this.getReturnList("fail", "", "No items to submit. Please check your XML.");
            }
            int eventCrfBeanIdProcessed = 0;
            for (DisplayItemBean displayItemBean : wrapper.getDisplayItemBeans()) {
                eventCrfBeanId = displayItemBean.getData().getEventCRFId();
                eventCrfBean = (EventCRFBean)eventCrfDao.findByPK(eventCrfBeanId);
                this.logger.debug("found value here: " + displayItemBean.getData().getValue());
                this.logger.debug("found status here: " + eventCrfBean.getStatus().getName());
                int currentCRFVersionId = eventCrfBean.getCRFVersionId();
                int newCRFVersionId = displayItemBean.getMetadata().getCrfVersionId();
                if (currentCRFVersionId != newCRFVersionId && eventCrfBeanIdProcessed != eventCrfBeanId) {
                    eventCrfDao.updateCRFVersionID(eventCrfBeanId, newCRFVersionId, userBean.getId());
                    eventCrfBeanIdProcessed = eventCrfBeanId;
                    eventCrfBean.setCRFVersionId(newCRFVersionId);
                }
                ItemDataBean itemDataBean = itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                if (wrapper.isOverwrite() && itemDataBean.getStatus() != null) {
                    if (!itemDataBean.getValue().equals(displayItemBean.getData().getValue())) {
                        resetSDV = true;
                    }
                    this.logger.debug("just tried to find item data bean on item name " + displayItemBean.getItem().getName());
                    itemDataBean.setUpdatedDate(new Date());
                    itemDataBean.setUpdater(userBean);
                    itemDataBean.setValue(displayItemBean.getData().getValue());
                    itemDataDao.update((EntityBean)itemDataBean);
                    this.logger.debug("updated: " + itemDataBean.getItemId());
                    displayItemBean.getData().setId(itemDataBean.getId());
                } else {
                    resetSDV = true;
                    itemDataDao.create((EntityBean)displayItemBean.getData());
                    this.logger.debug("created: " + displayItemBean.getData().getItemId());
                    itemDataBean = itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                    displayItemBean.getData().setId(itemDataBean.getId());
                }
                ItemDAO idao = new ItemDAO(dataSource);
                ItemBean ibean = (ItemBean)idao.findByPK(displayItemBean.getData().getItemId());
                String itemOid = displayItemBean.getItem().getOid() + "_" + wrapper.getStudyEventRepeatKey() + "_" + displayItemBean.getData().getOrdinal() + "_" + wrapper.getStudySubjectOid();
                if (wrapper.getValidationErrors().containsKey(itemOid)) {
                    ArrayList messageList = (ArrayList)wrapper.getValidationErrors().get(itemOid);
                    for (String message : messageList) {
                        DiscrepancyNoteBean parentDn = this.createDiscrepancyNote(ibean, message, eventCrfBean, displayItemBean, null, userBean, dataSource, studyBean);
                        this.createDiscrepancyNote(ibean, message, eventCrfBean, displayItemBean, Integer.valueOf(parentDn.getId()), userBean, dataSource, studyBean);
                        discNotesGenerated = true;
                        this.logger.debug("*** created disc note with message: " + message);
                        auditMsg.append(wrapper.getStudySubjectOid() + ": " + ibean.getOid() + ": " + message + "---");
                    }
                }
                if (eventCrfInts.contains(new Integer(eventCrfBean.getId()))) continue;
                String eventCRFStatus = importedCRFStatuses.get(new Integer(eventCrfBean.getId()));
                if (eventCRFStatus != null && eventCRFStatus.equals(DataEntryStage.INITIAL_DATA_ENTRY.getName()) && eventCrfBean.getStatus().isAvailable()) {
                    crfBusinessLogicHelper.markCRFStarted(eventCrfBean, userBean, true);
                } else {
                    crfBusinessLogicHelper.markCRFComplete(eventCrfBean, userBean, true);
                }
                eventCrfInts.add(new Integer(eventCrfBean.getId()));
            }
            if (eventCrfBean == null || !resetSDV) continue;
            eventCrfDao.setSDVStatus(false, userBean.getId(), eventCrfBean.getId());
        }
        if (!discNotesGenerated) {
            return this.getReturnList("success", "", auditMsg.toString());
        }
        return this.getReturnList("warn", "", auditMsg.toString());
    }

    public DiscrepancyNoteBean createDiscrepancyNote(ItemBean itemBean, String message, EventCRFBean eventCrfBean, DisplayItemBean displayItemBean, Integer parentId, UserAccountBean uab, DataSource ds, StudyBean study) {
        DiscrepancyNoteBean note = new DiscrepancyNoteBean();
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        note.setDescription(message);
        note.setDetailedNotes("Failed Validation Check");
        note.setOwner(uab);
        note.setCreatedDate(new Date());
        note.setResolutionStatusId(ResolutionStatus.OPEN.getId());
        note.setDiscrepancyNoteTypeId(DiscrepancyNoteType.FAILEDVAL.getId());
        if (parentId != null) {
            note.setParentDnId(parentId.intValue());
        }
        note.setField(itemBean.getName());
        note.setStudyId(study.getId());
        note.setEntityName(itemBean.getName());
        note.setEntityType("ItemData");
        note.setEntityValue(displayItemBean.getData().getValue());
        note.setEventName(eventCrfBean.getName());
        note.setEventStart(eventCrfBean.getCreatedDate());
        note.setCrfName(displayItemBean.getEventDefinitionCRF().getCrfName());
        StudySubjectBean ss = (StudySubjectBean)ssdao.findByPK(eventCrfBean.getStudySubjectId());
        note.setSubjectName(ss.getName());
        note.setEntityId(displayItemBean.getData().getId());
        note.setColumn("value");
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(ds);
        note = (DiscrepancyNoteBean)dndao.create((EntityBean)note);
        this.logger.debug("trying to create mapping with " + note.getId() + " " + note.getEntityId() + " " + note.getColumn() + " " + note.getEntityType());
        dndao.createMapping(note);
        this.logger.debug("just created mapping");
        return note;
    }

    public List<ImportDataRuleRunnerContainer> runRulesSetup(DataSource dataSource, StudyBean studyBean, UserAccountBean userBean, List<SubjectDataBean> subjectDataBeans, RuleSetServiceInterface ruleSetService) {
        ArrayList<ImportDataRuleRunnerContainer> containers = new ArrayList<ImportDataRuleRunnerContainer>();
        if (ruleSetService.getCountByStudy(studyBean) > 0) {
            for (SubjectDataBean subjectDataBean : subjectDataBeans) {
                ImportDataRuleRunnerContainer container = new ImportDataRuleRunnerContainer();
                container.initRuleSetsAndTargets(dataSource, studyBean, subjectDataBean, ruleSetService);
                if (!container.getShouldRunRules().booleanValue()) continue;
                containers.add(container);
            }
            if (containers != null && !containers.isEmpty()) {
                ruleSetService.runRulesInImportData(containers, studyBean, userBean, ExecutionMode.DRY_RUN);
            }
        }
        return containers;
    }

    public List<String> runRules(StudyBean studyBean, UserAccountBean userBean, List<ImportDataRuleRunnerContainer> containers, RuleSetServiceInterface ruleSetService, ExecutionMode executionMode) {
        List<String> messages = new ArrayList<String>();
        if (containers != null && !containers.isEmpty()) {
            HashMap summary = ruleSetService.runRulesInImportData(containers, studyBean, userBean, executionMode);
            messages = this.extractRuleActionWarnings(summary);
        }
        return messages;
    }

    private List<String> extractRuleActionWarnings(HashMap<String, ArrayList<String>> summaryMap) {
        ArrayList<String> messages = new ArrayList<String>();
        if (summaryMap != null && !summaryMap.isEmpty()) {
            for (String key : summaryMap.keySet()) {
                StringBuilder mesg = new StringBuilder(key + " : ");
                for (String s : summaryMap.get(key)) {
                    mesg.append(s + ", ");
                }
                messages.add(mesg.toString());
            }
        }
        return messages;
    }

    private ImportCRFDataService getImportCRFDataService(DataSource dataSource) {
        return new ImportCRFDataService(dataSource, this.getLocale());
    }

    private ArrayList<String> getReturnList(String status, String msg, String auditMsg) {
        ArrayList<String> retList = new ArrayList<String>(3);
        retList.add(status);
        retList.add(msg.toString());
        retList.add(auditMsg.toString());
        return retList;
    }
}

