/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.crfdata;

import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.Validation;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;

public class ImportHelper {
    public final String getInputName(DisplayItemBean dib) {
        ItemBean ib = dib.getItem();
        String inputName = "input" + ib.getId();
        return inputName;
    }

    public DisplayItemBean validateDisplayItemBeanSingleCV(DiscrepancyValidator v, DisplayItemBean dib, String inputName) {
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
        }
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        if (StringUtil.isBlank((String)idb.getValue()) && ibMeta.isRequired()) {
            v.addValidation(inputName, 26);
        }
        return dib;
    }

    public DisplayItemBean validateDisplayItemBeanMultipleCV(DiscrepancyValidator v, DisplayItemBean dib, String inputName) {
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
        }
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataBean idb = dib.getData();
        if (StringUtil.isBlank((String)idb.getValue()) && ibMeta.isRequired()) {
            v.addValidation(inputName, 26);
        }
        return dib;
    }

    public DisplayItemBean validateDisplayItemBeanText(DiscrepancyValidator discValidator, DisplayItemBean dib, String inputName) {
        if (StringUtil.isBlank((String)inputName)) {
            inputName = this.getInputName(dib);
        }
        ItemBean ib = dib.getItem();
        ItemFormMetadataBean ibMeta = dib.getMetadata();
        ItemDataType idt = ib.getDataType();
        ItemDataBean idb = dib.getData();
        boolean isNull = false;
        if (!isNull) {
            if (StringUtil.isBlank((String)idb.getValue())) {
                if (ibMeta.isRequired()) {
                    discValidator.addValidation(inputName, 26);
                }
            } else {
                if (idt.equals((Term)ItemDataType.ST)) {
                    discValidator.addValidation(inputName, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 3999);
                } else if (!(idt.equals((Term)ItemDataType.INTEGER) || idt.equals((Term)ItemDataType.REAL) || idt.equals((Term)ItemDataType.BL) || idt.equals((Term)ItemDataType.BN))) {
                    if (idt.equals((Term)ItemDataType.SET)) {
                        discValidator.addValidation(inputName, 24, dib.getMetadata().getResponseSet());
                    } else if (idt.equals((Term)ItemDataType.DATE)) {
                        // empty if block
                    }
                }
                String customValidationString = dib.getMetadata().getRegexp();
                if (!StringUtil.isBlank((String)customValidationString)) {
                    Validation customValidation = null;
                    if (customValidationString.startsWith("func:")) {
                        try {
                            customValidation = Validator.processCRFValidationFunction((String)customValidationString);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (customValidationString.startsWith("regexp:")) {
                        try {
                            customValidation = Validator.processCRFValidationRegex((String)customValidationString);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (customValidation != null) {
                        customValidation.setErrorMessage(dib.getMetadata().getRegexpErrorMsg());
                        discValidator.addValidation(inputName, customValidation);
                    }
                }
            }
        }
        return dib;
    }
}

