/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.util.ArrayList;
import java.util.Date;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrfBusinessLogicHelper {
    DataSource ds;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public CrfBusinessLogicHelper(DataSource ds) {
        this.ds = ds;
    }

    private EventDefinitionCRFBean getEventDefinitionCrfByStudyEventAndCrfVersion(EventCRFBean eventCrf, StudyBean study) {
        EventDefinitionCRFDAO eventDefinitionCrfDao = new EventDefinitionCRFDAO(this.ds);
        eventDefinitionCrfDao = new EventDefinitionCRFDAO(this.ds);
        EventDefinitionCRFBean eventDefinitionCrf = eventDefinitionCrfDao.findByStudyEventIdAndCRFVersionId(study, eventCrf.getStudyEventId(), eventCrf.getCRFVersionId());
        return eventDefinitionCrf;
    }

    protected boolean isEachRequiredFieldFillout(EventCRFBean ecb) {
        int allRequiredFilledOut;
        ItemDataDAO iddao = new ItemDataDAO(this.ds);
        ItemDAO idao = new ItemDAO(this.ds);
        int allRequiredNum = idao.findAllRequiredByCRFVersionId(ecb.getCRFVersionId());
        if (allRequiredNum > (allRequiredFilledOut = iddao.findAllRequiredByEventCRFId(ecb))) {
            return false;
        }
        ArrayList allFilled = iddao.findAllBlankRequiredByEventCRFId(ecb.getId(), ecb.getCRFVersionId());
        return allFilled.isEmpty();
    }

    protected boolean areAllCompleted(StudyEventBean seBean, StudyBean study) {
        EventDefinitionCRFDAO edcDao = new EventDefinitionCRFDAO(this.ds);
        EventCRFDAO eventCrfDao = new EventCRFDAO(this.ds);
        ArrayList allCRFs = eventCrfDao.findAllByStudyEvent(seBean);
        ArrayList allEDCs = (ArrayList)edcDao.findAllActiveByEventDefinitionId(study, seBean.getStudyEventDefinitionId());
        boolean eventCompleted = true;
        this.logger.info("found all crfs: " + allCRFs.size());
        this.logger.info("found all edcs: " + allEDCs.size());
        for (int i = 0; i < allCRFs.size(); ++i) {
            EventCRFBean ec = (EventCRFBean)allCRFs.get(i);
            this.logger.info("found a event name from event crf bean: " + ec.getEventName() + " crf version id: " + ec.getCRFVersionId());
            if (ec.getStatus().equals((Term)Status.UNAVAILABLE) && allCRFs.size() >= allEDCs.size()) continue;
            eventCompleted = false;
            break;
        }
        this.logger.info("returning for are all completed: " + eventCompleted);
        return eventCompleted;
    }

    protected boolean areAllRequiredCompleted(StudyEventBean seBean, StudyBean study) {
        EventCRFBean ec;
        int i;
        EventDefinitionCRFDAO edcDao = new EventDefinitionCRFDAO(this.ds);
        EventCRFDAO eventCrfDao = new EventCRFDAO(this.ds);
        ArrayList allCRFs = eventCrfDao.findAllByStudyEvent(seBean);
        ArrayList allEDCs = (ArrayList)edcDao.findAllActiveByEventDefinitionId(study, seBean.getStudyEventDefinitionId());
        boolean eventRequiredCompleted = true;
        for (i = 0; i < allCRFs.size(); ++i) {
            ec = (EventCRFBean)allCRFs.get(i);
            EventDefinitionCRFBean edcBean = edcDao.findByStudyEventIdAndCRFVersionId(study, seBean.getId(), ec.getCRFVersionId());
            if (ec.getStatus().equals((Term)Status.UNAVAILABLE) || !edcBean.isRequiredCRF()) continue;
            eventRequiredCompleted = false;
            break;
        }
        if (allCRFs.size() < allEDCs.size()) {
            for (i = 0; i < allEDCs.size(); ++i) {
                ec = (EventDefinitionCRFBean)allEDCs.get(i);
                if (!ec.isRequiredCRF()) continue;
                eventRequiredCompleted = false;
                break;
            }
        }
        this.logger.info("returning for event required completed: " + eventRequiredCompleted);
        return eventRequiredCompleted;
    }

    protected boolean noneAreRequired(StudyEventBean seBean, StudyBean study) {
        boolean noneAreRequired = true;
        EventDefinitionCRFDAO edcDao = new EventDefinitionCRFDAO(this.ds);
        ArrayList allEDCs = (ArrayList)edcDao.findAllActiveByEventDefinitionId(study, seBean.getStudyEventDefinitionId());
        this.logger.info("found all EDCs: " + allEDCs.size());
        for (int i = 0; i < allEDCs.size(); ++i) {
            EventDefinitionCRFBean ec = (EventDefinitionCRFBean)allEDCs.get(i);
            this.logger.info("found crf name: " + ec.getCrfName());
            if (!ec.isRequiredCRF()) continue;
            noneAreRequired = false;
            break;
        }
        this.logger.info("returning for none are required: " + noneAreRequired);
        return noneAreRequired;
    }

    protected boolean areAllRequired(StudyEventBean seBean, StudyBean study) {
        EventDefinitionCRFDAO edcDao = new EventDefinitionCRFDAO(this.ds);
        ArrayList allEDCs = (ArrayList)edcDao.findAllActiveByEventDefinitionId(study, seBean.getStudyEventDefinitionId());
        boolean areAllRequired = true;
        for (int i = 0; i < allEDCs.size(); ++i) {
            EventDefinitionCRFBean ec = (EventDefinitionCRFBean)allEDCs.get(i);
            if (ec.isRequiredCRF()) continue;
            areAllRequired = false;
            break;
        }
        this.logger.info("returning for are all required: " + areAllRequired);
        return areAllRequired;
    }

    public boolean markCRFComplete(EventCRFBean ecb, UserAccountBean ub, boolean inTransaction) throws Exception {
        DataEntryStage stage = ecb.getStage();
        EventCRFDAO eventCrfDao = new EventCRFDAO(this.ds);
        ItemDataDAO itemDataDao = new ItemDataDAO(this.ds);
        StudyDAO sdao = new StudyDAO(this.ds);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.ds);
        StudyBean study = sdao.findByStudySubjectId(ecb.getStudySubjectId());
        EventDefinitionCRFBean edcb = this.getEventDefinitionCrfByStudyEventAndCrfVersion(ecb, study);
        StudyEventDefinitionDAO studyEventDefinitionDao = new StudyEventDefinitionDAO(this.ds);
        StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)studyEventDefinitionDao.findByPK(edcb.getStudyEventDefinitionId());
        CRFDAO crfDao = new CRFDAO(this.ds);
        ArrayList crfs = (ArrayList)crfDao.findAllActiveByDefinition(sedBean);
        sedBean.setCrfs(crfs);
        this.logger.debug("inout_event_crf_id:" + ecb.getId());
        this.logger.debug("inout_study_event_def_id:" + sedBean.getId());
        Status newStatus = ecb.getStatus();
        DataEntryStage newStage = ecb.getStage();
        boolean ide = true;
        newStatus = Status.UNAVAILABLE;
        ecb.setUpdater(ub);
        ecb.setUpdatedDate(new Date());
        ecb.setDateCompleted(new Date());
        ecb.setDateValidateCompleted(new Date());
        ecb.setStatus(newStatus);
        ecb.setStage(newStage);
        ecb = (EventCRFBean)eventCrfDao.update((EntityBean)ecb);
        this.logger.debug("just updated event crf id: " + ecb.getId());
        eventCrfDao.markComplete(ecb, ide);
        itemDataDao.updateStatusByEventCRF(ecb, newStatus);
        StudyEventDAO sedao = new StudyEventDAO(this.ds);
        StudyEventBean seb = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
        seb.setUpdatedDate(new Date());
        seb.setUpdater(ub);
        this.logger.debug("sed bean get crfs get size: " + sedBean.getCrfs().size());
        this.logger.debug("edcb get crf id: " + edcb.getCrfId() + " version size? " + edcb.getVersions().size());
        this.logger.debug("ecb get crf id: " + ecb.getCrf().getId());
        this.logger.debug("ecb get crf version id: " + ecb.getCRFVersionId());
        if (sedBean.getCrfs().size() == 1) {
            seb.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
            this.logger.info("just set subj event status to -- COMPLETED --");
        } else if (this.areAllRequired(seb, study) && !this.areAllCompleted(seb, study)) {
            seb.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
            this.logger.info("just set subj event status to -- DATAENTRYSTARTED --");
        } else if (!this.areAllRequired(seb, study)) {
            if (this.areAllRequiredCompleted(seb, study)) {
                seb.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                this.logger.info("just set subj event status to -- 3completed3 --");
            } else {
                seb.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
                this.logger.info("just set subj event status to -- DATAENTRYSTARTED --");
            }
        } else if (this.noneAreRequired(seb, study)) {
            seb.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
            this.logger.info("just set subj event status to -- 5completed5 --");
        }
        this.logger.debug("just set subj event status, final status is " + seb.getSubjectEventStatus().getName());
        this.logger.debug("final overall status is " + seb.getStatus().getName());
        seb = (StudyEventBean)sedao.update((EntityBean)seb, inTransaction);
        return true;
    }

    public boolean markCRFStarted(EventCRFBean ecb, UserAccountBean ub, boolean inTransaction) throws Exception {
        EventCRFDAO eventCrfDao = new EventCRFDAO(this.ds);
        StudyDAO sdao = new StudyDAO(this.ds);
        StudyBean study = sdao.findByStudySubjectId(ecb.getStudySubjectId());
        EventDefinitionCRFBean edcb = this.getEventDefinitionCrfByStudyEventAndCrfVersion(ecb, study);
        StudyEventDefinitionDAO studyEventDefinitionDao = new StudyEventDefinitionDAO(this.ds);
        StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)studyEventDefinitionDao.findByPK(edcb.getStudyEventDefinitionId());
        CRFDAO crfDao = new CRFDAO(this.ds);
        ArrayList crfs = (ArrayList)crfDao.findAllActiveByDefinition(sedBean);
        sedBean.setCrfs(crfs);
        this.logger.debug("inout_event_crf_id:" + ecb.getId());
        this.logger.debug("inout_study_event_def_id:" + sedBean.getId());
        Status newStatus = Status.AVAILABLE;
        DataEntryStage newStage = ecb.getStage();
        ecb.setUpdater(ub);
        ecb.setUpdatedDate(new Date());
        ecb.setStatus(newStatus);
        ecb.setStage(newStage);
        ecb = (EventCRFBean)eventCrfDao.update((EntityBean)ecb);
        this.logger.debug("just updated event crf id: " + ecb.getId());
        StudyEventDAO sedao = new StudyEventDAO(this.ds);
        StudyEventBean seb = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
        if (seb.getSubjectEventStatus().isScheduled() || seb.getSubjectEventStatus().isNotScheduled() || seb.getSubjectEventStatus().isDE_Started()) {
            seb.setUpdatedDate(new Date());
            seb.setUpdater(ub);
            seb.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
            seb = (StudyEventBean)sedao.update((EntityBean)seb, inTransaction);
        }
        return true;
    }
}

