/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.subject.SubjectServiceInterface;
import org.openclinica.ws.crf.v1.CreateCrfResponse;
import org.openclinica.ws.crf.v1.CrfType;
import org.openclinica.ws.crf.v1.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Endpoint
public class CrfEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/crf/v1";
    private final String SUCCESS_MESSAGE = "success";
    private final String FAIL_MESSAGE = "fail";
    private String dateFormat;
    private Properties dataInfo;
    private final SubjectServiceInterface subjectService;
    private final DataSource dataSource;
    private final ObjectFactory objectFactory;

    public CrfEndpoint(SubjectServiceInterface subjectService, DataSource dataSource) {
        this.subjectService = subjectService;
        this.dataSource = dataSource;
        this.objectFactory = new ObjectFactory();
    }

    @PayloadRoot(localPart="createCrfRequest", namespace="http://openclinica.org/ws/crf/v1")
    public CreateCrfResponse store(JAXBElement<CrfType> requestElement) throws Exception {
        CrfType crf = (CrfType)requestElement.getValue();
        String filePathWithName = this.getDataInfo().getProperty("filePath") + "crf/original/" + crf.getFileName();
        try {
            FileOutputStream fstream = new FileOutputStream(filePathWithName);
            crf.getFile().writeTo((OutputStream)fstream);
            fstream.close();
        }
        catch (Exception fstream) {
            // empty catch block
        }
        CreateCrfResponse crfResponse = new CreateCrfResponse();
        crfResponse.setResult("success");
        crfResponse.setKey("test");
        return crfResponse;
    }

    private Element mapConfirmation(String confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/crf/v1", "commitResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/crf/v1", "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        return responseElement;
    }

    private Date getDate(String dateAsString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        return sdf.parse(dateAsString);
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        UserAccountDAO userAccountDao = new UserAccountDAO(this.dataSource);
        return (UserAccountBean)userAccountDao.findByUserName(username);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(Properties dataInfo) {
        this.dataInfo = dataInfo;
    }
}

