/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.rulerunner.ExecutionMode;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.web.crfdata.DataImportService;
import org.akaza.openclinica.web.crfdata.ImportCRFInfo;
import org.akaza.openclinica.web.crfdata.ImportCRFInfoContainer;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.CRFDataImportValidator;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Endpoint
public class DataEndpoint {
    protected static final Logger LOG = LoggerFactory.getLogger(DataEndpoint.class);
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/data/v1";
    private final String ODM_HEADER_NAMESPACE = "<ODM xmlns=\"http://www.cdisc.org/ns/odm/v1.3\" targetNamespace=\"http://openclinica.org/ws/data/v1\" xmlns:OpenClinica=\"http://www.openclinica.org/ns/openclinica_odm/v1.3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.cdisc.org/ns/odm/v1.3\">";
    private final DataSource dataSource;
    private final MessageSource messages;
    private final CoreResources coreResources;
    private final Locale locale;
    private final DataImportService dataImportService = new DataImportService();
    private RuleSetServiceInterface ruleSetService;
    private TransactionTemplate transactionTemplate;

    public DataEndpoint(DataSource dataSource, MessageSource messages, CoreResources coreResources) {
        this.dataSource = dataSource;
        this.messages = messages;
        this.coreResources = coreResources;
        this.ruleSetService = this.getRuleSetService();
        this.locale = new Locale("en_US");
    }

    @PayloadRoot(localPart="importRequest", namespace="http://openclinica.org/ws/data/v1")
    public Source importData(@XPathParam(value="//ODM") Element odmElement) throws Exception {
        return (Source)this.getTransactionTemplate().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Source importDataInTransaction(Element odmElement) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        LOG.debug("rootElement=" + odmElement);
        UserAccountBean userBean = null;
        try {
            if (odmElement == null) {
                return new DOMSource(this.mapFailConfirmation(null, "Your XML is not well-formed."));
            }
            ODMContainer odmContainer = this.unmarshallToODMContainer(odmElement);
            String studyUniqueID = odmContainer.getCrfDataPostImportContainer().getStudyOID();
            userBean = this.getUserAccount();
            BaseStudyDefinitionBean crfDataImportBean = new BaseStudyDefinitionBean(studyUniqueID, userBean);
            DataBinder dataBinder = new DataBinder((Object)crfDataImportBean);
            BindingResult errors = dataBinder.getBindingResult();
            CRFDataImportValidator crfDataImportValidator = new CRFDataImportValidator(this.dataSource);
            crfDataImportValidator.validate((Object)crfDataImportBean, (Errors)errors);
            if (!errors.hasErrors()) {
                HashMap importedCRFStatuses;
                ArrayList displayItemBeanWrappers;
                StudyBean studyBean = crfDataImportBean.getStudy();
                List errorMessagesFromValidation = this.dataImportService.validateMetaData(odmContainer, this.dataSource, this.coreResources, studyBean, userBean, displayItemBeanWrappers = new ArrayList(), importedCRFStatuses = new HashMap());
                if (errorMessagesFromValidation.size() > 0) {
                    String err_msg = this.convertToErrorString(errorMessagesFromValidation);
                    return new DOMSource(this.mapFailConfirmation(null, err_msg));
                }
                ImportCRFInfoContainer importCrfInfo = new ImportCRFInfoContainer(odmContainer, this.dataSource);
                errorMessagesFromValidation = this.dataImportService.validateData(odmContainer, this.dataSource, this.coreResources, studyBean, userBean, displayItemBeanWrappers, importedCRFStatuses);
                if (errorMessagesFromValidation.size() > 0) {
                    String err_msg = this.convertToErrorString(errorMessagesFromValidation);
                    return new DOMSource(this.mapFailConfirmation(null, err_msg));
                }
                ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
                List containers = this.dataImportService.runRulesSetup(this.dataSource, studyBean, userBean, (List)subjectDataBeans, this.ruleSetService);
                ArrayList auditMsgs = new DataImportService().submitData(odmContainer, this.dataSource, studyBean, userBean, displayItemBeanWrappers, importedCRFStatuses);
                List ruleActionMsgs = this.dataImportService.runRules(studyBean, userBean, containers, this.ruleSetService, ExecutionMode.SAVE);
                List skippedCRFMsgs = this.getSkippedCRFMessages(importCrfInfo);
                return new DOMSource(this.mapConfirmation((List)auditMsgs, ruleActionMsgs, skippedCRFMsgs, importCrfInfo));
            }
            return new DOMSource(this.mapFailConfirmation((Errors)errors, null));
        }
        catch (Exception e) {
            LOG.error("Error processing data import request", (Throwable)e);
            throw new Exception(e);
        }
    }

    private List<String> getSkippedCRFMessages(ImportCRFInfoContainer importCrfInfo) {
        ArrayList<String> msgList = new ArrayList<String>();
        ResourceBundle respage = ResourceBundleProvider.getPageMessagesBundle();
        ResourceBundle resword = ResourceBundleProvider.getWordsBundle();
        MessageFormat mf = new MessageFormat("");
        mf.applyPattern(respage.getString("crf_skipped"));
        for (ImportCRFInfo importCrf : importCrfInfo.getImportCRFList()) {
            if (importCrf.isProcessImport()) continue;
            String preImportStatus = "";
            preImportStatus = importCrf.getPreImportStage().isInitialDE() ? resword.getString("initial_data_entry") : (importCrf.getPreImportStage().isInitialDE_Complete() ? resword.getString("initial_data_entry_complete") : (importCrf.getPreImportStage().isDoubleDE() ? resword.getString("double_data_entry") : (importCrf.getPreImportStage().isDoubleDE_Complete() ? resword.getString("data_entry_complete") : (importCrf.getPreImportStage().isAdmin_Editing() ? resword.getString("administrative_editing") : (importCrf.getPreImportStage().isLocked() ? resword.getString("locked") : resword.getString("invalid"))))));
            Object[] arguments = new Object[]{importCrf.getStudyOID(), importCrf.getStudySubjectOID(), importCrf.getStudyEventOID(), importCrf.getFormOID(), preImportStatus};
            msgList.add(mf.format(arguments));
        }
        return msgList;
    }

    private ODMContainer unmarshallToODMContainer(Element odmElement) throws Exception {
        ResourceBundle respage = ResourceBundleProvider.getPageMessagesBundle();
        String xml = DataEndpoint.node2String((Node)odmElement);
        this.getClass();
        xml = xml.replaceAll("<ODM>", "<ODM xmlns=\"http://www.cdisc.org/ns/odm/v1.3\" targetNamespace=\"http://openclinica.org/ws/data/v1\" xmlns:OpenClinica=\"http://www.openclinica.org/ns/openclinica_odm/v1.3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.cdisc.org/ns/odm/v1.3\">");
        if (xml == null) {
            throw new Exception(respage.getString("unreadable_file"));
        }
        Mapping myMap = new Mapping();
        InputStream mapInputStream = this.coreResources.getInputStream("cd_odm_mapping.xml");
        myMap.loadMapping(new InputSource(mapInputStream));
        Unmarshaller um1 = new Unmarshaller(myMap);
        ODMContainer odmContainer = new ODMContainer();
        try {
            LOG.debug(xml);
            odmContainer = (ODMContainer)um1.unmarshal((Reader)new StringReader(xml));
            LOG.debug("Found crf data container for study oid: " + odmContainer.getCrfDataPostImportContainer().getStudyOID());
            LOG.debug("found length of subject list: " + odmContainer.getCrfDataPostImportContainer().getSubjectData().size());
            return odmContainer;
        }
        catch (Exception me1) {
            me1.printStackTrace();
            LOG.debug("failed in unmarshaling, trying another version = " + me1.getMessage());
            throw new Exception();
        }
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        UserAccountDAO userAccountDao = new UserAccountDAO(this.dataSource);
        return (UserAccountBean)userAccountDao.findByUserName(username);
    }

    private Element mapFailConfirmation(Errors errors, String message) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/data/v1", "importDataResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/data/v1", "result");
        String confirmation = this.messages.getMessage("dataEndpoint.fail", null, "Fail", this.locale);
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        if (errors != null) {
            for (ObjectError error : errors.getAllErrors()) {
                Element errorElement = document.createElementNS("http://openclinica.org/ws/data/v1", "error");
                String theMessage = this.messages.getMessage(error.getCode(), error.getArguments(), this.locale);
                errorElement.setTextContent(theMessage);
                responseElement.appendChild(errorElement);
            }
        }
        if (message != null) {
            Element msgElement = document.createElementNS("http://openclinica.org/ws/data/v1", "error");
            msgElement.setTextContent(message);
            responseElement.appendChild(msgElement);
            LOG.debug("sending fail message " + message);
        }
        return responseElement;
    }

    private Element mapConfirmation(List<String> auditMsgs, List<String> ruleActionMsgs, List<String> skippedCRFMsgs, ImportCRFInfoContainer importCRFs) throws Exception {
        Element responseElement;
        block11: {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            responseElement = document.createElementNS("http://openclinica.org/ws/data/v1", "importDataResponse");
            Element resultElement = document.createElementNS("http://openclinica.org/ws/data/v1", "result");
            String totalCRFs = String.valueOf(importCRFs.getImportCRFList().size());
            String importedCRFs = String.valueOf(importCRFs.getImportCRFList().size() - importCRFs.getCountSkippedEventCrfs());
            if (auditMsgs == null) break block11;
            String status = auditMsgs.get(0);
            if ("fail".equals(status)) {
                String confirmation = this.messages.getMessage("dataEndpoint.fail", null, "Fail", this.locale);
                resultElement.setTextContent(confirmation);
                responseElement.appendChild(resultElement);
                Element msgElement = document.createElementNS("http://openclinica.org/ws/data/v1", "error");
                auditMsgs.remove(0);
                StringBuffer output_msg = new StringBuffer("");
                for (String mes : auditMsgs) {
                    output_msg.append(mes);
                }
                msgElement.setTextContent(output_msg.toString());
                responseElement.appendChild(msgElement);
            } else if ("warn".equals(status)) {
                String confirmation = this.messages.getMessage("dataEndpoint.success", new Object[]{importedCRFs, totalCRFs}, "Success", this.locale);
                resultElement.setTextContent(confirmation);
                responseElement.appendChild(resultElement);
                Element msgElement = document.createElementNS("http://openclinica.org/ws/data/v1", "summary");
                msgElement.setTextContent(auditMsgs.get(1));
                responseElement.appendChild(msgElement);
                String listOfDns = auditMsgs.get(2);
                String[] splitListOfDns = listOfDns.split("---");
                for (String dn : splitListOfDns) {
                    Element warning = document.createElementNS("http://openclinica.org/ws/data/v1", "warning");
                    warning.setTextContent(dn);
                    responseElement.appendChild(warning);
                }
                for (String s : skippedCRFMsgs) {
                    Element skipMsg = document.createElementNS("http://openclinica.org/ws/data/v1", "warning");
                    skipMsg.setTextContent(s);
                    responseElement.appendChild(skipMsg);
                }
            } else {
                String confirmation;
                if (ruleActionMsgs != null && !ruleActionMsgs.isEmpty()) {
                    confirmation = this.messages.getMessage("dataEndpoint.success", new Object[]{importedCRFs, totalCRFs}, "Success", this.locale);
                    resultElement.setTextContent(confirmation);
                    responseElement.appendChild(resultElement);
                    for (String s : ruleActionMsgs) {
                        Element ruleMsg = document.createElementNS("http://openclinica.org/ws/data/v1", "rule_action_warning");
                        ruleMsg.setTextContent(s);
                        responseElement.appendChild(ruleMsg);
                    }
                } else {
                    confirmation = this.messages.getMessage("dataEndpoint.success", new Object[]{importedCRFs, totalCRFs}, "Success", this.locale);
                    resultElement.setTextContent(confirmation);
                    responseElement.appendChild(resultElement);
                }
                for (String s : skippedCRFMsgs) {
                    Element skipMsg = document.createElementNS("http://openclinica.org/ws/data/v1", "warning");
                    skipMsg.setTextContent(s);
                    responseElement.appendChild(skipMsg);
                }
            }
        }
        return responseElement;
    }

    private static String node2String(Node node) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter outStream = new StringWriter();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(outStream);
            transformer.transform(source, result);
            return outStream.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String convertToErrorString(List<String> errorMessages) {
        StringBuilder result = new StringBuilder();
        for (String str : errorMessages) {
            result.append(str + " \n");
        }
        return result.toString();
    }

    public RuleSetServiceInterface getRuleSetService() {
        return this.ruleSetService;
    }

    public void setRuleSetService(RuleSetServiceInterface ruleSetService) {
        this.ruleSetService = ruleSetService;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

