/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.EventServiceInterface;
import org.akaza.openclinica.ws.bean.StudyEventTransferBean;
import org.akaza.openclinica.ws.validator.StudyEventTransferValidator;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.xml.DomUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Endpoint
public class EventEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/event/v1";
    private String dateFormat;
    private final EventServiceInterface eventService;
    private final MessageSource messages;
    private final DataSource dataSource;
    Locale locale;
    private TransactionTemplate transactionTemplate;

    public EventEndpoint(EventServiceInterface eventService, DataSource dataSource, MessageSource messages) {
        this.eventService = eventService;
        this.messages = messages;
        this.dataSource = dataSource;
        this.locale = new Locale("en_US");
    }

    @PayloadRoot(localPart="scheduleRequest", namespace="http://openclinica.org/ws/event/v1")
    public Source scheduleEvent(@XPathParam(value="//e:event") NodeList event) throws Exception {
        return (Source)this.getTransactionTemplate().execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Source scheduleEventInTransaction(NodeList event) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        Element eventElement = (Element)event.item(0);
        StudyEventTransferBean studyEventTransferBean = this.unMarshallToEventTransfer(eventElement);
        DataBinder dataBinder = new DataBinder((Object)studyEventTransferBean);
        BindingResult errors = dataBinder.getBindingResult();
        StudyEventTransferValidator studyEventTransferValidator = new StudyEventTransferValidator(this.dataSource);
        studyEventTransferValidator.validate((Object)studyEventTransferBean, (Errors)errors);
        if (!errors.hasErrors()) {
            try {
                HashMap h = this.getEventService().scheduleEvent(studyEventTransferBean.getUser(), studyEventTransferBean.getStartDateTime(), studyEventTransferBean.getEndDateTime(), studyEventTransferBean.getLocation(), studyEventTransferBean.getStudyUniqueId(), studyEventTransferBean.getSiteUniqueId(), studyEventTransferBean.getEventDefinitionOID(), studyEventTransferBean.getSubjectLabel());
                return new DOMSource(this.mapSuccessConfirmation(h));
            }
            catch (OpenClinicaSystemException ose) {
                errors.reject("eventEndpoint.cannot_schedule", "Cannot schedule an event for this Subject.");
                return new DOMSource(this.mapFailConfirmation((Errors)errors));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        return new DOMSource(this.mapFailConfirmation((Errors)errors));
    }

    private Element mapSuccessConfirmation(HashMap<String, String> confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/event/v1", "scheduleResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/event/v1", "result");
        Element eventDefinitionOID = document.createElementNS("http://openclinica.org/ws/event/v1", "eventDefinitionOID");
        Element studySubjectOID = document.createElementNS("http://openclinica.org/ws/event/v1", "studySubjectOID");
        Element eventOrdinal = document.createElementNS("http://openclinica.org/ws/event/v1", "studyEventOrdinal");
        resultElement.setTextContent(this.messages.getMessage("eventEndpoint.success", null, "Success", this.locale));
        eventDefinitionOID.setTextContent(confirmation.get("eventDefinitionOID"));
        studySubjectOID.setTextContent(confirmation.get("studySubjectOID"));
        eventOrdinal.setTextContent(confirmation.get("studyEventOrdinal"));
        responseElement.appendChild(resultElement);
        responseElement.appendChild(eventDefinitionOID);
        responseElement.appendChild(studySubjectOID);
        responseElement.appendChild(eventOrdinal);
        return responseElement;
    }

    private StudyEventTransferBean unMarshallToEventTransfer(Element eventElement) throws ParseException {
        Element eventDefinitionOidElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"eventDefinitionOID");
        Element locationElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"location");
        Element startDateElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"startDate");
        Element endDateElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"endDate");
        Element startTimeElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"startTime");
        Element endTimeElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"endTime");
        Element subjectRefElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"studySubjectRef");
        Element labelElement = DomUtils.getChildElementByTagName((Element)subjectRefElement, (String)"label");
        Element studyRefElement = DomUtils.getChildElementByTagName((Element)eventElement, (String)"studyRef");
        Element studyIdentifierElement = DomUtils.getChildElementByTagName((Element)studyRefElement, (String)"identifier");
        Element siteRef = DomUtils.getChildElementByTagName((Element)studyRefElement, (String)"siteRef");
        Element siteIdentifierElement = siteRef == null ? null : DomUtils.getChildElementByTagName((Element)siteRef, (String)"identifier");
        String studySubjectId = DomUtils.getTextValue((Element)labelElement).trim();
        String eventDefinitionOID = DomUtils.getTextValue((Element)eventDefinitionOidElement).trim();
        String studyIdentifier = DomUtils.getTextValue((Element)studyIdentifierElement).trim();
        String siteIdentifier = siteIdentifierElement == null ? null : DomUtils.getTextValue((Element)siteIdentifierElement).trim();
        String location = locationElement == null ? null : DomUtils.getTextValue((Element)locationElement).trim();
        String startDate = DomUtils.getTextValue((Element)startDateElement).trim();
        String startTime = startTimeElement == null ? null : DomUtils.getTextValue((Element)startTimeElement).trim();
        String endDate = endDateElement == null ? null : DomUtils.getTextValue((Element)endDateElement).trim();
        String endTime = endTimeElement == null ? null : DomUtils.getTextValue((Element)endTimeElement).trim();
        StudyEventTransferBean studyEventTransferBean = new StudyEventTransferBean(studySubjectId, studyIdentifier, siteIdentifier, eventDefinitionOID, location, this.getDate(startDate, startTime), this.getDate(endDate, endTime), this.getUserAccount());
        return studyEventTransferBean;
    }

    private Element mapFailConfirmation(Errors errors) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/event/v1", "scheduleResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/event/v1", "result");
        resultElement.setTextContent(this.messages.getMessage("eventEndpoint.fail", null, "Fail", this.locale));
        responseElement.appendChild(resultElement);
        for (ObjectError error : errors.getAllErrors()) {
            Element errorElement = document.createElementNS("http://openclinica.org/ws/event/v1", "error");
            String theMessage = this.messages.getMessage(error.getCode(), error.getArguments(), this.locale);
            errorElement.setTextContent(theMessage);
            responseElement.appendChild(errorElement);
        }
        return responseElement;
    }

    private Date getDate(String dateAsString, String hourMinuteAsString) throws ParseException {
        Date d = null;
        if (dateAsString != null && dateAsString.length() != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            d = sdf.parse(dateAsString = dateAsString + (hourMinuteAsString == null ? " 00:00" : " " + hourMinuteAsString));
            if (!sdf.format(d).equals(dateAsString)) {
                throw new OpenClinicaSystemException("Date not parseable");
            }
            return sdf.parse(dateAsString);
        }
        return null;
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        UserAccountDAO userAccountDao = new UserAccountDAO(this.dataSource);
        return (UserAccountBean)userAccountDao.findByUserName(username);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public EventServiceInterface getEventService() {
        return this.eventService;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

