/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.odm.FullReportBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.odmbeans.ODMBean;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.odmExport.AdminDataCollector;
import org.akaza.openclinica.logic.odmExport.MetaDataCollector;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.StudyMetadataRequestValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.xml.DomUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Endpoint
public class StudyEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/study/v1";
    private final DataSource dataSource;
    StudyDAO studyDao;
    UserAccountDAO userAccountDao;
    private final MessageSource messages;
    private final CoreResources coreResources;
    private final RuleSetRuleDao ruleSetRuleDao;
    private final Locale locale;

    public StudyEndpoint(DataSource dataSource, MessageSource messages, CoreResources coreResources, RuleSetRuleDao ruleSetRuleDao) {
        this.dataSource = dataSource;
        this.messages = messages;
        this.locale = new Locale("en_US");
        this.coreResources = coreResources;
        this.ruleSetRuleDao = ruleSetRuleDao;
    }

    @PayloadRoot(localPart="getMetadataRequest", namespace="http://openclinica.org/ws/study/v1")
    public Source getStudyMetadata(@XPathParam(value="//study:studyMetadata") NodeList studyNodeList) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        Element studyRefElement = (Element)studyNodeList.item(0);
        BaseStudyDefinitionBean studyMetadataRequestBean = this.unMarshallRequest(studyRefElement);
        DataBinder dataBinder = new DataBinder((Object)studyMetadataRequestBean);
        BindingResult errors = dataBinder.getBindingResult();
        StudyMetadataRequestValidator studyMetadataRequestValidator = new StudyMetadataRequestValidator(this.dataSource);
        studyMetadataRequestValidator.validate((Object)studyMetadataRequestBean, (Errors)errors);
        if (!errors.hasErrors()) {
            return new DOMSource(this.mapSuccessConfirmation(this.getStudy(studyMetadataRequestBean), this.messages.getMessage("studyEndpoint.success", null, "Success", this.locale)));
        }
        return new DOMSource(this.mapConfirmation(this.messages.getMessage("studyEndpoint.fail", null, "Fail", this.locale), (Errors)errors));
    }

    private Element mapSuccessConfirmation(StudyBean study, String confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS(NAMESPACE_URI_V1, "createResponse");
        Element resultElement = document.createElementNS(NAMESPACE_URI_V1, "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        Element odmElement = document.createElementNS(NAMESPACE_URI_V1, "odm");
        String reportText = this.getReport(study);
        odmElement.setTextContent(reportText);
        responseElement.appendChild(odmElement);
        return responseElement;
    }

    private String getReport(StudyBean currentStudy) {
        MetaDataCollector mdc = new MetaDataCollector(this.dataSource, currentStudy, this.ruleSetRuleDao);
        AdminDataCollector adc = new AdminDataCollector(this.dataSource, currentStudy);
        MetaDataCollector.setTextLength((int)200);
        ODMBean odmb = mdc.getODMBean();
        odmb.setSchemaLocation("http://www.cdisc.org/ns/odm/v1.3 OpenClinica-ODM1-3-0-OC2-0.xsd");
        ArrayList<String> xmlnsList = new ArrayList<String>();
        xmlnsList.add("xmlns=\"http://www.cdisc.org/ns/odm/v1.3\"");
        xmlnsList.add("xmlns:OpenClinica=\"http://www.openclinica.org/ns/odm_ext_v130/v3.1\"");
        xmlnsList.add("xmlns:OpenClinicaRules=\"http://www.openclinica.org/ns/rules/v3.1\"");
        odmb.setXmlnsList(xmlnsList);
        odmb.setODMVersion("oc1.3");
        mdc.setODMBean(odmb);
        adc.setOdmbean(odmb);
        mdc.collectFileData();
        adc.collectFileData();
        FullReportBean report = new FullReportBean();
        report.setAdminDataMap(adc.getOdmAdminDataMap());
        report.setOdmStudyMap(mdc.getOdmStudyMap());
        report.setCoreResources(this.coreResources);
        report.setOdmBean(mdc.getODMBean());
        report.setODMVersion("oc1.3");
        report.createStudyMetaOdmXml(Boolean.FALSE.booleanValue());
        return report.getXmlOutput().toString().trim();
    }

    private Element mapConfirmation(String confirmation, Errors errors) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS(NAMESPACE_URI_V1, "createResponse");
        Element resultElement = document.createElementNS(NAMESPACE_URI_V1, "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        for (ObjectError error : errors.getAllErrors()) {
            Element errorElement = document.createElementNS(NAMESPACE_URI_V1, "error");
            String theMessage = this.messages.getMessage(error.getCode(), error.getArguments(), this.locale);
            errorElement.setTextContent(theMessage);
            responseElement.appendChild(errorElement);
        }
        return responseElement;
    }

    private BaseStudyDefinitionBean unMarshallRequest(Element studyEventDefinitionListAll) {
        Element studyIdentifierElement = DomUtils.getChildElementByTagName((Element)studyEventDefinitionListAll, (String)"identifier");
        String studyIdentifier = studyIdentifierElement == null ? null : DomUtils.getTextValue((Element)studyIdentifierElement).trim();
        BaseStudyDefinitionBean studyMetadataRequest = new BaseStudyDefinitionBean(studyIdentifier, this.getUserAccount());
        return studyMetadataRequest;
    }

    StudyBean getStudy(BaseStudyDefinitionBean studyMetadataRequest) {
        StudyBean study = null;
        if (studyMetadataRequest.getStudyUniqueId() != null && studyMetadataRequest.getSiteUniqueId() == null) {
            study = this.getStudyDao().findByUniqueIdentifier(studyMetadataRequest.getStudyUniqueId());
        }
        if (studyMetadataRequest.getStudyUniqueId() != null && studyMetadataRequest.getSiteUniqueId() != null) {
            study = this.getStudyDao().findByUniqueIdentifier(studyMetadataRequest.getSiteUniqueId());
        }
        return study;
    }

    @PayloadRoot(localPart="listAllRequest", namespace="http://openclinica.org/ws/study/v1")
    public Source getStudyList() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        return new DOMSource(this.mapConfirmation(this.messages.getMessage("studyEndpoint.success", null, "Success", this.locale)));
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return (UserAccountBean)this.getUserAccountDao().findByUserName(username);
    }

    private HashMap<Integer, ArrayList<StudyBean>> getStudies() {
        ArrayList studyUserRoleBeans = this.getUserAccountDao().findStudyByUser(this.getUserAccount().getName(), (ArrayList)this.getStudyDao().findAll());
        HashMap<Integer, ArrayList<StudyBean>> validStudySiteMap = new HashMap<Integer, ArrayList<StudyBean>>();
        for (int i = 0; i < studyUserRoleBeans.size(); ++i) {
            ArrayList<StudyBean> sites;
            StudyUserRoleBean sr = (StudyUserRoleBean)studyUserRoleBeans.get(i);
            StudyBean study = (StudyBean)this.studyDao.findByPK(sr.getStudyId());
            if (study != null && study.getStatus().equals((Term)Status.PENDING)) {
                sr.setStatus(study.getStatus());
            }
            if (study.isSite(study.getParentStudyId()) && !sr.isInvalid()) {
                if (validStudySiteMap.get(study.getParentStudyId()) == null) {
                    sites = new ArrayList<StudyBean>();
                    sites.add(study);
                    validStudySiteMap.put(study.getParentStudyId(), sites);
                    continue;
                }
                validStudySiteMap.get(study.getParentStudyId()).add(study);
                continue;
            }
            if (study.isSite(study.getParentStudyId()) || validStudySiteMap.get(study.getId()) != null) continue;
            sites = new ArrayList();
            validStudySiteMap.put(study.getId(), sites);
        }
        return validStudySiteMap;
    }

    private Element mapConfirmation(String confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS(NAMESPACE_URI_V1, "listAllResponse");
        Element resultElement = document.createElementNS(NAMESPACE_URI_V1, "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        Element studyListElement = document.createElementNS(NAMESPACE_URI_V1, "studies");
        responseElement.appendChild(studyListElement);
        for (Map.Entry entry : this.getStudies().entrySet()) {
            StudyBean study = (StudyBean)this.getStudyDao().findByPK(((Integer)entry.getKey()).intValue());
            studyListElement.appendChild(this.createStudyWithSiteElement(document, study, (ArrayList)entry.getValue()));
        }
        return responseElement;
    }

    private Element createStudyWithSiteElement(Document document, StudyBean study, ArrayList<StudyBean> sites) {
        Element studyElement = this.createStudyElement(document, "study", study);
        if (sites.size() > 0) {
            Element siteListElement = document.createElementNS(NAMESPACE_URI_V1, "sites");
            studyElement.appendChild(siteListElement);
            for (StudyBean siteBean : sites) {
                Element siteElement = this.createStudyElement(document, "site", siteBean);
                siteListElement.appendChild(siteElement);
            }
        }
        return studyElement;
    }

    private Element createStudyElement(Document document, String studyOrSite, StudyBean study) {
        Element studyElement = document.createElementNS(NAMESPACE_URI_V1, studyOrSite);
        Element element = document.createElementNS(NAMESPACE_URI_V1, "identifier");
        element.setTextContent(study.getIdentifier() + "");
        studyElement.appendChild(element);
        element = document.createElementNS(NAMESPACE_URI_V1, "oid");
        element.setTextContent(study.getOid());
        studyElement.appendChild(element);
        element = document.createElementNS(NAMESPACE_URI_V1, "name");
        element.setTextContent(study.getName());
        studyElement.appendChild(element);
        return studyElement;
    }

    public StudyDAO getStudyDao() {
        this.studyDao = this.studyDao != null ? this.studyDao : new StudyDAO(this.dataSource);
        return this.studyDao;
    }

    public UserAccountDAO getUserAccountDao() {
        this.userAccountDao = this.userAccountDao != null ? this.userAccountDao : new UserAccountDAO(this.dataSource);
        return this.userAccountDao;
    }
}

