/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.StudyEventDefinitionRequestValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.xml.DomUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Endpoint
public class StudyEventDefinitionEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/studyEventDefinition/v1";
    private final DataSource dataSource;
    private final MessageSource messages;
    private final Locale locale;
    StudyDAO studyDao;
    UserAccountDAO userAccountDao;
    CRFDAO crfDao;
    CRFVersionDAO crfVersionDao;
    StudyEventDefinitionDAO studyEventDefinitionDao;
    EventDefinitionCRFDAO eventDefinitionCRFDao;

    public StudyEventDefinitionEndpoint(DataSource dataSource, MessageSource messages) {
        this.dataSource = dataSource;
        this.messages = messages;
        this.locale = new Locale("en_US");
    }

    @PayloadRoot(localPart="listAllRequest", namespace="http://openclinica.org/ws/studyEventDefinition/v1")
    public Source getStudyList(@XPathParam(value="//sed:studyEventDefinitionListAll") NodeList studyNodeList) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        Element studyRefElement = (Element)studyNodeList.item(0);
        BaseStudyDefinitionBean studyEventDefinitionRequestBean = this.unMarshallRequest(studyRefElement);
        DataBinder dataBinder = new DataBinder((Object)studyEventDefinitionRequestBean);
        BindingResult errors = dataBinder.getBindingResult();
        StudyEventDefinitionRequestValidator studyEventDefinitionRequestValidator = new StudyEventDefinitionRequestValidator(this.dataSource);
        studyEventDefinitionRequestValidator.validate((Object)studyEventDefinitionRequestBean, (Errors)errors);
        if (!errors.hasErrors()) {
            return new DOMSource(this.mapConfirmation(this.getStudy(studyEventDefinitionRequestBean), this.messages.getMessage("studyEventDefinitionEndpoint.success", null, "Success", this.locale)));
        }
        return new DOMSource(this.mapFailConfirmation(this.messages.getMessage("studyEventDefinitionEndpoint.fail", null, "Fail", this.locale), (Errors)errors));
    }

    StudyBean getStudy(BaseStudyDefinitionBean studyEventDefinitionRequestBean) {
        StudyBean study = null;
        if (studyEventDefinitionRequestBean.getStudyUniqueId() != null && studyEventDefinitionRequestBean.getSiteUniqueId() == null) {
            study = this.getStudyDao().findByUniqueIdentifier(studyEventDefinitionRequestBean.getStudyUniqueId());
        }
        if (studyEventDefinitionRequestBean.getStudyUniqueId() != null && studyEventDefinitionRequestBean.getSiteUniqueId() != null) {
            study = this.getStudyDao().findByUniqueIdentifier(studyEventDefinitionRequestBean.getSiteUniqueId());
        }
        return study;
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return (UserAccountBean)this.getUserAccountDao().findByUserName(username);
    }

    private BaseStudyDefinitionBean unMarshallRequest(Element studyEventDefinitionListAll) {
        Element studyRefElement = DomUtils.getChildElementByTagName((Element)studyEventDefinitionListAll, (String)"studyRef");
        Element studyIdentifierElement = DomUtils.getChildElementByTagName((Element)studyRefElement, (String)"identifier");
        Element siteRef = DomUtils.getChildElementByTagName((Element)studyRefElement, (String)"siteRef");
        Element siteIdentifierElement = siteRef == null ? null : DomUtils.getChildElementByTagName((Element)siteRef, (String)"identifier");
        String studyIdentifier = studyIdentifierElement == null ? null : DomUtils.getTextValue((Element)studyIdentifierElement).trim();
        String siteIdentifier = siteIdentifierElement == null ? null : DomUtils.getTextValue((Element)siteIdentifierElement).trim();
        BaseStudyDefinitionBean studyEventDefinitionRequestBean = new BaseStudyDefinitionBean(studyIdentifier, siteIdentifier, this.getUserAccount());
        return studyEventDefinitionRequestBean;
    }

    private Element mapConfirmation(StudyBean study, String confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "listAllResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        Element studyListElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "studyEventDefinitions");
        responseElement.appendChild(studyListElement);
        ArrayList eventList = this.getStudyEventDefinitionDao().findAllByStudy(study);
        for (int index = 0; index < eventList.size(); ++index) {
            StudyEventDefinitionBean event = (StudyEventDefinitionBean)eventList.get(index);
            Element studyElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "studyEventDefinition");
            Element element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "oid");
            element.setTextContent(event.getOid());
            studyElement.appendChild(element);
            element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "name");
            element.setTextContent(event.getName());
            studyElement.appendChild(element);
            studyListElement.appendChild(studyElement);
            List eventCrfs = (List)this.getEventDefinitionCRFDao().findAllByDefinition(study, event.getId());
            Element eventDefinitionCrfListElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "eventDefinitionCrfs");
            studyElement.appendChild(eventDefinitionCrfListElement);
            for (int i = 0; i < eventCrfs.size(); ++i) {
                EventDefinitionCRFBean eventCrf = (EventDefinitionCRFBean)eventCrfs.get(i);
                Element eventDefinitionCrfElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "eventDefinitionCrf");
                eventDefinitionCrfListElement.appendChild(eventDefinitionCrfElement);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "required");
                element.setTextContent(String.valueOf(eventCrf.isRequiredCRF()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "doubleDataEntry");
                element.setTextContent(String.valueOf(eventCrf.isDoubleEntry()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "passwordRequired");
                element.setTextContent(String.valueOf(eventCrf.isElectronicSignature()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "hideCrf");
                element.setTextContent(String.valueOf(eventCrf.isHideCrf()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "participantForm");
                element.setTextContent(String.valueOf(eventCrf.isParticipantForm()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "allowAnonymousSubmission");
                element.setTextContent(String.valueOf(eventCrf.isAllowAnonymousSubmission()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "submissionUrl");
                element.setTextContent(String.valueOf(eventCrf.getSubmissionUrl()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "offline");
                element.setTextContent(String.valueOf(eventCrf.isOffline()));
                eventDefinitionCrfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "sourceDataVerificaiton");
                element.setTextContent(String.valueOf(eventCrf.getSourceDataVerification()));
                eventDefinitionCrfElement.appendChild(element);
                Element crfElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "crf");
                eventDefinitionCrfElement.appendChild(crfElement);
                CRFBean crfBean = (CRFBean)this.getCrfDao().findByPK(eventCrf.getCrfId());
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "oid");
                element.setTextContent(crfBean.getOid());
                crfElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "name");
                element.setTextContent(crfBean.getName());
                crfElement.appendChild(element);
                Element crfVersionElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "defaultCrfVersion");
                eventDefinitionCrfElement.appendChild(crfVersionElement);
                CRFVersionBean crfVersionBean = (CRFVersionBean)this.getCrfVersionDao().findByPK(eventCrf.getDefaultVersionId());
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "oid");
                element.setTextContent(crfVersionBean.getOid());
                crfVersionElement.appendChild(element);
                element = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "name");
                element.setTextContent(crfVersionBean.getName());
                crfVersionElement.appendChild(element);
            }
        }
        return responseElement;
    }

    private Element mapFailConfirmation(String confirmation, Errors errors) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "listAllResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        for (ObjectError error : errors.getAllErrors()) {
            Element errorElement = document.createElementNS("http://openclinica.org/ws/studyEventDefinition/v1", "error");
            String theMessage = this.messages.getMessage(error.getCode(), error.getArguments(), this.locale);
            errorElement.setTextContent(theMessage);
            responseElement.appendChild(errorElement);
        }
        return responseElement;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public StudyDAO getStudyDao() {
        this.studyDao = this.studyDao != null ? this.studyDao : new StudyDAO(this.dataSource);
        return this.studyDao;
    }

    public CRFDAO getCrfDao() {
        this.crfDao = this.crfDao != null ? this.crfDao : new CRFDAO(this.dataSource);
        return this.crfDao;
    }

    public CRFVersionDAO getCrfVersionDao() {
        this.crfVersionDao = this.crfVersionDao != null ? this.crfVersionDao : new CRFVersionDAO(this.dataSource);
        return this.crfVersionDao;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        this.studyEventDefinitionDao = this.studyEventDefinitionDao != null ? this.studyEventDefinitionDao : new StudyEventDefinitionDAO(this.dataSource);
        return this.studyEventDefinitionDao;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDao() {
        this.eventDefinitionCRFDao = this.eventDefinitionCRFDao != null ? this.eventDefinitionCRFDao : new EventDefinitionCRFDAO(this.dataSource);
        return this.eventDefinitionCRFDao;
    }

    public UserAccountDAO getUserAccountDao() {
        this.userAccountDao = this.userAccountDao != null ? this.userAccountDao : new UserAccountDAO(this.dataSource);
        return this.userAccountDao;
    }
}

