/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.managestudy.SubjectTransferBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.subject.SubjectServiceInterface;
import org.akaza.openclinica.ws.bean.SubjectStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.SubjectTransferValidator;
import org.openclinica.ws.beans.EventType;
import org.openclinica.ws.beans.EventsType;
import org.openclinica.ws.beans.GenderType;
import org.openclinica.ws.beans.ListStudySubjectsInStudyType;
import org.openclinica.ws.beans.StudyRefType;
import org.openclinica.ws.beans.StudySubjectWithEventsType;
import org.openclinica.ws.beans.StudySubjectsType;
import org.openclinica.ws.beans.SubjectType;
import org.openclinica.ws.studysubject.v1.ListAllByStudyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.xml.DomUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Endpoint
public class StudySubjectEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/studySubject/v1";
    private String dateFormat;
    private final SubjectServiceInterface subjectService;
    private final DataSource dataSource;
    private final MessageSource messages;
    StudyDAO studyDao;
    UserAccountDAO userAccountDao;
    SubjectDAO subjectDao;
    private final Locale locale;

    public StudySubjectEndpoint(SubjectServiceInterface subjectService, DataSource dataSource, MessageSource messages) {
        this.subjectService = subjectService;
        this.dataSource = dataSource;
        this.messages = messages;
        this.locale = new Locale("en_US");
    }

    @PayloadRoot(localPart="createRequest", namespace="http://openclinica.org/ws/studySubject/v1")
    public Source createStudySubject(@XPathParam(value="//studySubject:studySubject") NodeList subject) throws Exception {
        BindingResult errors = null;
        try {
            ResourceBundleProvider.updateLocale((Locale)this.locale);
            Element subjectElement = (Element)subject.item(0);
            SubjectTransferBean subjectTransferBean = this.unMarshallToSubjectTransfer(subjectElement);
            DataBinder dataBinder = new DataBinder((Object)subjectTransferBean);
            errors = dataBinder.getBindingResult();
            subjectTransferBean.setOwner(this.subjectService.getUserAccount());
            SubjectTransferValidator subjectTransferValidator = new SubjectTransferValidator(this.dataSource);
            subjectTransferValidator.validate((Object)subjectTransferBean, (Errors)errors);
            if (!errors.hasErrors()) {
                String label = this.create(subjectTransferBean);
                return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.success", null, "Success", this.locale), label, (Errors)errors));
            }
            return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.fail", null, "Fail", this.locale), null, (Errors)errors));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.fail", null, "Null Pointer Exception", this.locale), null, errors));
        }
        catch (Exception e) {
            ArrayList<String> error_messages = new ArrayList<String>();
            error_messages.add(e.getMessage());
            return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.fail", null, "Fail", this.locale), null, (Errors)errors, "label", error_messages));
        }
    }

    @PayloadRoot(localPart="listAllByStudyRequest", namespace="http://openclinica.org/ws/studySubject/v1")
    public ListAllByStudyResponse listStudySubjectsInStudy(JAXBElement<ListStudySubjectsInStudyType> requestElement) throws Exception {
        try {
            ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
            ListStudySubjectsInStudyType listStudySubjectsInStudyType = (ListStudySubjectsInStudyType)requestElement.getValue();
            StudyBean study = null;
            try {
                study = this.validateRequestAndReturnStudy(listStudySubjectsInStudyType.getStudyRef());
            }
            catch (OpenClinicaSystemException e) {
                e.printStackTrace();
                ListAllByStudyResponse response = new ListAllByStudyResponse();
                response.setResult(this.messages.getMessage("studySubjectEndpoint.fail", null, "Fail", this.locale));
                response.getError().add(this.messages.getMessage(e.getErrorCode(), null, e.getErrorCode(), this.locale));
                return response;
            }
            return this.mapListStudySubjectsInStudyResponse(study, this.messages.getMessage("studySubjectEndpoint.success", null, "Success", this.locale), listStudySubjectsInStudyType.getStudyRef());
        }
        catch (Exception eee) {
            eee.printStackTrace();
            throw eee;
        }
    }

    @PayloadRoot(localPart="isStudySubjectRequest", namespace="http://openclinica.org/ws/studySubject/v1")
    public Source isStudySubject(@XPathParam(value="//studySubject:studySubject") NodeList subject) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)this.locale);
        Element subjectElement = (Element)subject.item(0);
        SubjectStudyDefinitionBean subjectStudyBean = this.unMarshallToSubjectStudy(subjectElement);
        DataBinder dataBinder = new DataBinder((Object)subjectStudyBean);
        BindingResult errors = dataBinder.getBindingResult();
        SubjectTransferValidator subjectTransferValidator = new SubjectTransferValidator(this.dataSource);
        subjectTransferValidator.validateIsSubjectExists((Object)subjectStudyBean, (Errors)errors);
        if (subjectStudyBean.getSubjectOIDId() == null) {
            errors.reject("studySubjectEndpoint.fail");
        }
        if (!errors.hasErrors()) {
            return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.success", null, "Success", this.locale), subjectStudyBean.getSubjectOIDId(), (Errors)errors, "subjectOID"));
        }
        return new DOMSource(this.mapConfirmation(this.messages.getMessage("studySubjectEndpoint.fail", null, "Fail", this.locale), null, (Errors)errors));
    }

    private ListAllByStudyResponse mapListStudySubjectsInStudyResponse(StudyBean study, String message, StudyRefType studyRef) throws Exception {
        ListAllByStudyResponse response = new ListAllByStudyResponse();
        response.setResult(message);
        StudySubjectsType studySubjectsType = new StudySubjectsType();
        response.setStudySubjects(studySubjectsType);
        List studySubjects = this.subjectService.getStudySubject(study);
        for (StudySubjectBean studySubjectBean : studySubjects) {
            StudySubjectWithEventsType studySubjectType = new StudySubjectWithEventsType();
            SubjectType subjectType = new SubjectType();
            studySubjectType.setLabel(studySubjectBean.getLabel());
            studySubjectType.setSecondaryLabel(studySubjectBean.getSecondaryLabel());
            studySubjectType.setOid(studySubjectBean.getOid());
            if (studySubjectBean.getEnrollmentDate() != null) {
                studySubjectType.setEnrollmentDate(this.getXMLGregorianCalendarDate(studySubjectBean.getEnrollmentDate()));
            }
            SubjectBean subjectBean = (SubjectBean)this.getSubjectDao().findByPK(studySubjectBean.getSubjectId());
            subjectType.setUniqueIdentifier(subjectBean.getUniqueIdentifier());
            String genderStr = String.valueOf(subjectBean.getGender());
            if (!"".equals(genderStr.trim())) {
                subjectType.setGender(GenderType.fromValue((String)genderStr));
            }
            if (subjectBean.getDateOfBirth() != null) {
                subjectType.setDateOfBirth(this.getXMLGregorianCalendarDate(subjectBean.getDateOfBirth()));
            }
            studySubjectType.setSubject(subjectType);
            this.logger.debug(studySubjectBean.getLabel());
            studySubjectType.setEvents(this.getEvents(studySubjectBean));
            studySubjectsType.getStudySubject().add(studySubjectType);
        }
        return response;
    }

    private EventsType getEvents(StudySubjectBean studySubject) throws Exception {
        StudyEventDAO eventDao = new StudyEventDAO(this.dataSource);
        StudyEventDefinitionDAO studyEventDefinitionDao = new StudyEventDefinitionDAO(this.dataSource);
        EventsType eventsType = new EventsType();
        ArrayList events = eventDao.findAllByStudySubject(studySubject);
        Object eb = null;
        for (StudyEventBean studyEventBean : events) {
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)studyEventDefinitionDao.findByPK(studyEventBean.getStudyEventDefinitionId());
            studyEventBean.setStudyEventDefinition(sed);
            EventType eventType = new EventType();
            eventType.setEventDefinitionOID(studyEventBean.getStudyEventDefinition().getOid());
            eventType.setLocation(studyEventBean.getLocation());
            if (studyEventBean.getDateStarted() != null) {
                eventType.setStartDate(this.getXMLGregorianCalendarDate(studyEventBean.getDateStarted()));
                eventType.setStartTime(this.getXMLGregorianCalendarTime(studyEventBean.getDateStarted()));
            }
            if (studyEventBean.getDateEnded() != null) {
                eventType.setEndDate(this.getXMLGregorianCalendarDate(studyEventBean.getDateEnded()));
                eventType.setEndTime(this.getXMLGregorianCalendarTime(studyEventBean.getDateEnded()));
            }
            eventsType.getEvent().add(eventType);
            this.logger.debug(eventType.getEventDefinitionOID() + " " + eventType.getStartDate());
        }
        return eventsType;
    }

    private StudyBean validateRequestAndReturnStudy(StudyRefType studyRef) {
        String siteIdentifier;
        String studyIdentifier = studyRef == null ? null : studyRef.getIdentifier().trim();
        String string = siteIdentifier = studyRef.getSiteRef() == null ? null : studyRef.getSiteRef().getIdentifier().trim();
        if (studyIdentifier == null && siteIdentifier == null) {
            throw new OpenClinicaSystemException("studySubjectEndpoint.provide_valid_study_site", "Provide a valid study/site.");
        }
        if (studyIdentifier != null && siteIdentifier == null) {
            StudyBean study = this.getStudyDao().findByUniqueIdentifier(studyIdentifier);
            if (study == null) {
                throw new OpenClinicaSystemException("studySubjectEndpoint.invalid_study_identifier", "The study identifier you provided is not valid.");
            }
            StudyUserRoleBean studySur = this.getUserAccountDao().findRoleByUserNameAndStudyId(this.subjectService.getUserAccount().getName(), study.getId());
            if (studySur.getStatus() != Status.AVAILABLE) {
                throw new OpenClinicaSystemException("studySubjectEndpoint.insufficient_permissions", "You do not have sufficient privileges to proceed with this operation.");
            }
            return study;
        }
        if (studyIdentifier != null && siteIdentifier != null) {
            StudyBean study = this.getStudyDao().findByUniqueIdentifier(studyIdentifier);
            StudyBean site = this.getStudyDao().findByUniqueIdentifier(siteIdentifier);
            if (study == null || site == null || site.getParentStudyId() != study.getId()) {
                throw new OpenClinicaSystemException("studySubjectEndpoint.invalid_study_site_identifier", "The study/site identifier you provided is not valid.");
            }
            StudyUserRoleBean siteSur = this.getUserAccountDao().findRoleByUserNameAndStudyId(this.subjectService.getUserAccount().getName(), site.getId());
            if (siteSur.getStatus() != Status.AVAILABLE) {
                throw new OpenClinicaSystemException("studySubjectEndpoint.insufficient_permissions", "You do not have sufficient privileges to proceed with this operation.");
            }
            return site;
        }
        return null;
    }

    private SubjectTransferBean unMarshallToSubjectTransfer(Element subjectElement) throws ParseException, Exception {
        Element studySubjectIdElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"label");
        Element secondaryIdElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"secondaryLabel");
        Element enrollmentDateElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"enrollmentDate");
        Element subject = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"subject");
        Element personIdElement = DomUtils.getChildElementByTagName((Element)subject, (String)"uniqueIdentifier");
        Element genderElement = DomUtils.getChildElementByTagName((Element)subject, (String)"gender");
        Element dateOfBirthElement = DomUtils.getChildElementByTagName((Element)subject, (String)"dateOfBirth");
        Element yearOfBirthElement = DomUtils.getChildElementByTagName((Element)subject, (String)"yearOfBirth");
        Element study = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"studyRef");
        Element studyIdentifierElement = DomUtils.getChildElementByTagName((Element)study, (String)"identifier");
        Element site = DomUtils.getChildElementByTagName((Element)study, (String)"siteRef");
        Element siteIdentifierElement = site == null ? null : DomUtils.getChildElementByTagName((Element)site, (String)"identifier");
        String personIdValue = personIdElement == null ? "" : DomUtils.getTextValue((Element)personIdElement).trim();
        String studySubjectIdValue = studySubjectIdElement == null ? "" : DomUtils.getTextValue((Element)studySubjectIdElement).trim();
        String genderValue = genderElement == null ? null : DomUtils.getTextValue((Element)genderElement).trim();
        String secondaryIdValue = secondaryIdElement == null ? null : DomUtils.getTextValue((Element)secondaryIdElement).trim();
        String enrollmentDateValue = DomUtils.getTextValue((Element)enrollmentDateElement).trim();
        String dateOfBirthValue = dateOfBirthElement == null ? null : DomUtils.getTextValue((Element)dateOfBirthElement).trim();
        String yearOfBirthValue = yearOfBirthElement == null ? null : DomUtils.getTextValue((Element)yearOfBirthElement).trim();
        String studyIdentifier = studyIdentifierElement == null ? null : DomUtils.getTextValue((Element)studyIdentifierElement).trim();
        String siteIdentifier = siteIdentifierElement == null ? null : DomUtils.getTextValue((Element)siteIdentifierElement).trim();
        SubjectTransferBean subjectTransferBean = new SubjectTransferBean();
        subjectTransferBean.setStudyOid(studyIdentifier);
        subjectTransferBean.setSiteIdentifier(siteIdentifier);
        subjectTransferBean.setPersonId(personIdValue);
        subjectTransferBean.setStudySubjectId(studySubjectIdValue);
        if (genderValue != null && genderValue.length() >= 1) {
            subjectTransferBean.setGender(genderValue.toCharArray()[0]);
        }
        subjectTransferBean.setDateOfBirth(dateOfBirthValue == null || dateOfBirthValue.length() == 0 ? null : this.getDate(dateOfBirthValue));
        subjectTransferBean.setSecondaryId(secondaryIdValue == null ? "" : secondaryIdValue);
        subjectTransferBean.setYearOfBirth(yearOfBirthValue);
        subjectTransferBean.setEnrollmentDate(this.getDate(enrollmentDateValue));
        return subjectTransferBean;
    }

    private SubjectStudyDefinitionBean unMarshallToSubjectStudy(Element subjectStudyElement) throws ParseException {
        Element studySubjectIdElement = DomUtils.getChildElementByTagName((Element)subjectStudyElement, (String)"label");
        Element study = DomUtils.getChildElementByTagName((Element)subjectStudyElement, (String)"studyRef");
        Element studyIdentifierElement = DomUtils.getChildElementByTagName((Element)study, (String)"identifier");
        Element site = DomUtils.getChildElementByTagName((Element)study, (String)"siteRef");
        Element siteIdentifierElement = site == null ? null : DomUtils.getChildElementByTagName((Element)site, (String)"identifier");
        String studySubjectIdValue = DomUtils.getTextValue((Element)studySubjectIdElement).trim();
        String studyIdentifier = studyIdentifierElement == null ? null : DomUtils.getTextValue((Element)studyIdentifierElement).trim();
        String siteIdentifier = siteIdentifierElement == null ? null : DomUtils.getTextValue((Element)siteIdentifierElement).trim();
        SubjectStudyDefinitionBean subjectTransferBean = new SubjectStudyDefinitionBean(studyIdentifier, siteIdentifier, this.subjectService.getUserAccount(), studySubjectIdValue);
        return subjectTransferBean;
    }

    private String create(SubjectTransferBean subjectTransferBean) {
        this.logger.debug("creating subject transfer");
        return this.createSubject(subjectTransferBean);
    }

    private boolean doesSubjectExist(SubjectTransferBean subjectTransferBean) {
        StudySubjectDAO ssdao = new StudySubjectDAO(this.dataSource);
        StudyDAO studyDao = new StudyDAO(this.dataSource);
        StudyBean studyBean = studyDao.findByUniqueIdentifier(subjectTransferBean.getStudy().getIdentifier());
        StudySubjectBean ssbean = ssdao.findByLabelAndStudy(subjectTransferBean.getStudySubjectId(), studyBean);
        return ssbean.getId() > 0;
    }

    private String createSubject(SubjectTransferBean subjectTransfer) {
        SubjectBean subject = new SubjectBean();
        subject.setUniqueIdentifier(subjectTransfer.getPersonId());
        subject.setLabel(subjectTransfer.getStudySubjectId());
        subject.setDateOfBirth(subjectTransfer.getDateOfBirth());
        if (subject.getDateOfBirth() != null) {
            subject.setDobCollected(true);
        } else {
            subject.setDobCollected(false);
        }
        subject.setGender(subjectTransfer.getGender());
        if (subjectTransfer.getOwner() != null) {
            subject.setOwner(subjectTransfer.getOwner());
        }
        subject.setCreatedDate(new Date());
        return this.subjectService.createSubject(subject, subjectTransfer.getStudy(), subjectTransfer.getEnrollmentDate(), subjectTransfer.getSecondaryId());
    }

    private Element mapConfirmation(String confirmation, String studySubjectLabel, Errors errors) throws Exception {
        return this.mapConfirmation(confirmation, studySubjectLabel, errors, "label", null);
    }

    private Element mapConfirmation(String confirmation, String studySubjectLabel, Errors errors, String label) throws Exception {
        return this.mapConfirmation(confirmation, studySubjectLabel, errors, label, null);
    }

    private Element mapConfirmation(String confirmation, String studySubjectLabel, Errors errors, String label, List<String> error_messages) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/studySubject/v1", "createResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/studySubject/v1", "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        if (studySubjectLabel != null) {
            Element labelElement = document.createElementNS("http://openclinica.org/ws/studySubject/v1", label);
            labelElement.setTextContent(studySubjectLabel);
            responseElement.appendChild(labelElement);
        }
        if (errors != null) {
            for (Object error : errors.getAllErrors()) {
                Element errorElement = document.createElementNS("http://openclinica.org/ws/studySubject/v1", "error");
                String theMessage = this.messages.getMessage(error.getCode(), error.getArguments(), this.locale);
                errorElement.setTextContent(theMessage);
                responseElement.appendChild(errorElement);
            }
        }
        if (error_messages != null && error_messages.size() > 0) {
            StringBuilder output_msg = new StringBuilder();
            for (String mes : error_messages) {
                output_msg.append(mes);
            }
            Element msgElement = document.createElementNS("http://openclinica.org/ws/studySubject/v1", "error");
            msgElement.setTextContent(output_msg.toString());
            responseElement.appendChild(msgElement);
        }
        return responseElement;
    }

    private XMLGregorianCalendar getXMLGregorianCalendarDate(Date date) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        DatatypeFactory df = DatatypeFactory.newInstance();
        XMLGregorianCalendar gcDate = df.newXMLGregorianCalendarDate(gc.get(1), gc.get(2) + 1, gc.get(5), Integer.MIN_VALUE);
        return gcDate;
    }

    private XMLGregorianCalendar getXMLGregorianCalendarTime(Date date) throws Exception {
        GregorianCalendar gc = new GregorianCalendar(this.locale);
        gc.setTime(date);
        DatatypeFactory df = DatatypeFactory.newInstance();
        XMLGregorianCalendar gcTime = df.newXMLGregorianCalendarTime(gc.get(11), gc.get(12), gc.get(13), null, Integer.MIN_VALUE);
        return gcTime;
    }

    private Date getDate(String dateAsString) throws ParseException, Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        sdf.setLenient(false);
        Date dd = sdf.parse(dateAsString);
        Calendar c = Calendar.getInstance();
        c.setTime(dd);
        if (c.get(1) < 1900 || c.get(1) > 9999) {
            throw new Exception("Unparsable date: " + dateAsString);
        }
        return dd;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public StudyDAO getStudyDao() {
        this.studyDao = this.studyDao != null ? this.studyDao : new StudyDAO(this.dataSource);
        return this.studyDao;
    }

    public UserAccountDAO getUserAccountDao() {
        this.userAccountDao = this.userAccountDao != null ? this.userAccountDao : new UserAccountDAO(this.dataSource);
        return this.userAccountDao;
    }

    public SubjectDAO getSubjectDao() {
        this.subjectDao = this.subjectDao != null ? this.subjectDao : new SubjectDAO(this.dataSource);
        return this.subjectDao;
    }

    public MessageSource getMessages() {
        return this.messages;
    }
}

