/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.ccts;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.SubjectTransferBean;
import org.akaza.openclinica.service.subject.SubjectServiceInterface;
import org.akaza.openclinica.ws.logic.CctsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.xml.DomUtils;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Endpoint
public class CctsSubjectEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/ccts/subject/v1";
    private final String SUCCESS_MESSAGE = "success";
    private String dateFormat;
    private final SubjectServiceInterface subjectService;
    private final CctsService cctsService;

    public CctsSubjectEndpoint(SubjectServiceInterface subjectService, CctsService cctsService) {
        this.subjectService = subjectService;
        this.cctsService = cctsService;
    }

    @PayloadRoot(localPart="commitRequest", namespace="http://openclinica.org/ws/ccts/subject/v1")
    public Source createSubject(@XPathParam(value="//s:gridId") String gridId, @XPathParam(value="//s:subject") NodeList subject, @XPathParam(value="//s:study/@oid") String studyOid) throws Exception {
        Element subjectElement = (Element)subject.item(0);
        SubjectTransferBean subjectTranferBean = this.unMarshallToSubjectTransfer(gridId, subjectElement, studyOid);
        this.logger.debug("In CreateSubject");
        return new DOMSource(this.mapConfirmation("success"));
    }

    @PayloadRoot(localPart="rollbackRequest", namespace="http://openclinica.org/ws/ccts/subject/v1")
    public Source rollBackSubject(@XPathParam(value="//s:gridId") String gridId, @XPathParam(value="//s:subject") NodeList subject, @XPathParam(value="//s:study/@oid") String studyOid) throws Exception {
        Element subjectElement = (Element)subject.item(0);
        SubjectTransferBean subjectTranferBean = this.unMarshallToSubjectTransfer(gridId, subjectElement, studyOid);
        return new DOMSource(this.mapConfirmation("success"));
    }

    private SubjectTransferBean unMarshallToSubjectTransfer(String gridId, Element subjectElement, String studyOidValue) throws ParseException {
        Element personIdElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"personId");
        Element studySubjectIdElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"studySubjectId");
        Element secondaryIdElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"secondaryId");
        Element enrollmentDateElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"enrollmentDate");
        Element genderElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"gender");
        Element dateOfBirthElement = DomUtils.getChildElementByTagName((Element)subjectElement, (String)"dateOfBirth");
        String personIdValue = DomUtils.getTextValue((Element)personIdElement);
        String studySubjectIdValue = DomUtils.getTextValue((Element)studySubjectIdElement);
        String genderValue = DomUtils.getTextValue((Element)genderElement);
        String secondaryIdValue = DomUtils.getTextValue((Element)secondaryIdElement);
        String enrollmentDateValue = DomUtils.getTextValue((Element)enrollmentDateElement);
        String dateOfBirthValue = DomUtils.getTextValue((Element)dateOfBirthElement);
        SubjectTransferBean subjectTransferBean = new SubjectTransferBean();
        subjectTransferBean.setStudyOid(studyOidValue);
        subjectTransferBean.setPersonId(personIdValue);
        subjectTransferBean.setStudySubjectId(studySubjectIdValue);
        subjectTransferBean.setGender(genderValue.toCharArray()[0]);
        subjectTransferBean.setDateOfBirth(this.getDate(dateOfBirthValue));
        subjectTransferBean.setEnrollmentDate(this.getDate(enrollmentDateValue));
        return subjectTransferBean;
    }

    private Element mapConfirmation(String confirmation) throws Exception {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element responseElement = document.createElementNS("http://openclinica.org/ws/ccts/subject/v1", "commitResponse");
        Element resultElement = document.createElementNS("http://openclinica.org/ws/ccts/subject/v1", "result");
        resultElement.setTextContent(confirmation);
        responseElement.appendChild(resultElement);
        return responseElement;
    }

    private Date getDate(String dateAsString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        return sdf.parse(dateAsString);
    }

    private UserAccountBean getUserAccount() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

