/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.logic;

import java.util.Date;
import java.util.List;
import org.akaza.openclinica.bean.managestudy.SubjectTransferBean;
import org.akaza.openclinica.service.subject.SubjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CctsService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private SubjectService subjectService;
    private String waitBeforeCommit;

    public void commit(SubjectTransferBean subjectTransferBean) {
        boolean isSubjectInQueue = this.isSubjectInQueue();
        boolean isSubjectInMain = this.doesSubjectExit();
        if (!isSubjectInMain) {
            if (isSubjectInQueue) {
                this.createSubject(subjectTransferBean);
            } else {
                this.createSubjectTransfer(subjectTransferBean);
            }
        }
    }

    public void rollback() {
        boolean isSubjectInQueue = true;
        boolean isSubjectInMain = true;
        if (isSubjectInMain) {
            // empty if block
        }
        if (isSubjectInQueue) {
            // empty if block
        }
    }

    public void autoCommit() {
        List subjectTransfers = this.getAllSubjectsInQueue();
        for (SubjectTransferBean subjectTransferBean : subjectTransfers) {
            if (!this.isSubjectInQueueForMoreThanXSeconds(subjectTransferBean)) continue;
            this.removeSubjectFromQueue(subjectTransferBean);
        }
        this.logger.debug("The time is : " + new Date());
    }

    public abstract boolean isSubjectInQueue();

    public abstract boolean doesSubjectExit();

    public abstract void createSubjectTransfer(SubjectTransferBean var1);

    public abstract void createSubject(SubjectTransferBean var1);

    public abstract List<SubjectTransferBean> getAllSubjectsInQueue();

    public abstract void removeSubjectFromQueue(SubjectTransferBean var1);

    private boolean isSubjectInQueueForMoreThanXSeconds(SubjectTransferBean subjectTransferBean) {
        return true;
    }

    public SubjectService getSubjectService() {
        return this.subjectService;
    }

    public void setSubjectService(SubjectService subjectService) {
        this.subjectService = subjectService;
    }

    public String getWaitBeforeCommit() {
        return this.waitBeforeCommit;
    }

    public void setWaitBeforeCommit(String waitBeforeCommit) {
        this.waitBeforeCommit = waitBeforeCommit;
    }
}

