/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.validator;

import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.BaseVSValidatorImplementation;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class CRFDataImportValidator
implements Validator {
    DataSource dataSource;
    StudyDAO studyDAO;
    UserAccountDAO userAccountDAO;
    BaseVSValidatorImplementation helper;

    public CRFDataImportValidator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.helper = new BaseVSValidatorImplementation();
    }

    public boolean supports(Class clazz) {
        return BaseStudyDefinitionBean.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        BaseStudyDefinitionBean crfDataImportBean = (BaseStudyDefinitionBean)obj;
        if (crfDataImportBean.getStudyUniqueId() == null) {
            e.reject("studyEventDefinitionRequestValidator.study_does_not_exist");
            return;
        }
        Status[] included_status = new Status[]{Status.AVAILABLE, Status.PENDING};
        StudyBean study = this.helper.verifyStudyByOID(this.getStudyDAO(), crfDataImportBean.getStudyUniqueId(), included_status, e);
        if (study == null) {
            return;
        }
        boolean isRoleVerified = this.helper.verifyRole(crfDataImportBean.getUser(), study.getId(), -1, Role.MONITOR, e);
        if (!isRoleVerified) {
            return;
        }
        crfDataImportBean.setStudy(study);
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO != null ? this.studyDAO : new StudyDAO(this.dataSource);
    }

    public UserAccountDAO getUserAccountDAO() {
        return this.userAccountDAO != null ? this.userAccountDAO : new UserAccountDAO(this.dataSource);
    }
}

