/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.validator;

import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.ws.bean.StudyEventTransferBean;
import org.akaza.openclinica.ws.validator.BaseVSValidatorImplementation;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class StudyEventTransferValidator
implements Validator {
    DataSource dataSource;
    StudyDAO studyDAO;
    StudySubjectDAO studySubjectDAO;
    StudyEventDefinitionDAO studyEventDefinitionDAO;
    BaseVSValidatorImplementation helper;
    private StudyParameterValueDAO studyParameterValueDAO;
    private static String TRUE = "true";
    private static String REQUIRED = "required";

    public StudyEventTransferValidator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.helper = new BaseVSValidatorImplementation();
    }

    public boolean supports(Class clazz) {
        return StudyEventTransferBean.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        boolean isRoleVerified;
        StudyEventTransferBean studyEventTransferBean = (StudyEventTransferBean)obj;
        if (studyEventTransferBean.getStudyUniqueId() == null || studyEventTransferBean.getStudyUniqueId().length() < 1) {
            e.reject("studyEventTransferValidator.invalid_study_identifier");
            return;
        }
        Status[] included_status = new Status[]{Status.AVAILABLE, Status.PENDING};
        StudyBean study = this.helper.verifyStudy(this.getStudyDAO(), studyEventTransferBean.getStudyUniqueId(), included_status, e);
        if (study == null) {
            return;
        }
        studyEventTransferBean.setStudy(study);
        StudyBean site = null;
        int site_id = -1;
        if (studyEventTransferBean.getSiteUniqueId() != null) {
            site = this.helper.verifySite(this.getStudyDAO(), studyEventTransferBean.getStudyUniqueId(), studyEventTransferBean.getSiteUniqueId(), included_status, e);
            if (site == null) {
                return;
            }
            site_id = site.getId();
            studyEventTransferBean.setStudy(site);
        }
        if (!(isRoleVerified = this.helper.verifyRole(studyEventTransferBean.getUser(), study.getId(), site_id, Role.MONITOR, e))) {
            return;
        }
        if (studyEventTransferBean.getSubjectLabel() == null) {
            e.reject("studyEventTransferValidator.studySubjectId_required");
            return;
        }
        StudySubjectBean studySubject = this.getStudySubjectDAO().findByLabelAndStudy(studyEventTransferBean.getSubjectLabel(), studyEventTransferBean.getStudy());
        if (studySubject == null || studySubject.getOid() == null) {
            e.reject("studyEventTransferValidator.study_subject_does_not_exist", new Object[]{studyEventTransferBean.getSubjectLabel(), studyEventTransferBean.getStudy().getName()}, "StudySubject label you specified " + studyEventTransferBean.getSubjectLabel() + " does not correspond to a study " + studyEventTransferBean.getStudy().getName());
            return;
        }
        if (studyEventTransferBean.getEventDefinitionOID() == null || studyEventTransferBean.getEventDefinitionOID().length() < 1) {
            e.reject("studyEventTransferValidator.eventDefinitionOID_required");
            return;
        }
        if (studyEventTransferBean.getStartDateTime() == null) {
            e.reject("studyEventTransferValidator.startDateTime_required");
            return;
        }
        StudyParameterValueBean eventLocationRequiredSetting = this.getStudyParameterValueDAO().findByHandleAndStudy(studyEventTransferBean.getStudy().getId(), "eventLocationRequired");
        if (REQUIRED.equals(eventLocationRequiredSetting.getValue()) && (studyEventTransferBean.getLocation() == null || studyEventTransferBean.getLocation().length() < 1)) {
            e.reject("studyEventTransferValidator.location_required");
            return;
        }
        if (studyEventTransferBean.getEndDateTime() != null && studyEventTransferBean.getStartDateTime() != null && studyEventTransferBean.getEndDateTime().compareTo(studyEventTransferBean.getStartDateTime()) == -1) {
            e.reject("studyEventTransferValidator.start_date_after_end_date", new Object[]{studyEventTransferBean.getStartDateTime(), studyEventTransferBean.getEndDateTime()}, "Start date " + studyEventTransferBean.getStartDateTime() + "  after end date (" + studyEventTransferBean.getEndDateTime() + ").");
            return;
        }
        int parentStudyId = study.getParentStudyId();
        StudyEventDefinitionBean studyEventDefinition = this.getStudyEventDefinitionDAO().findByOidAndStudy(studyEventTransferBean.getEventDefinitionOID(), study.getId(), parentStudyId);
        if (studyEventDefinition == null) {
            e.reject("studyEventTransferValidator.invalid_eventDefinitionOID", new Object[]{studyEventTransferBean.getEventDefinitionOID()}, "EventDefinitionOID you specified " + studyEventTransferBean.getEventDefinitionOID() + " is not valid.");
            return;
        }
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO != null ? this.studyDAO : new StudyDAO(this.dataSource);
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO != null ? this.studySubjectDAO : new StudySubjectDAO(this.dataSource);
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDAO() {
        return this.studyEventDefinitionDAO != null ? this.studyEventDefinitionDAO : new StudyEventDefinitionDAO(this.dataSource);
    }

    public StudyParameterValueDAO getStudyParameterValueDAO() {
        return this.studyParameterValueDAO != null ? this.studyParameterValueDAO : new StudyParameterValueDAO(this.dataSource);
    }
}

